/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenRuleTarget;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.jdt.core.JavaConventions;

public class AuditHandcodedTest
extends ConfiguredTestCase {
    private final String javaLevel = "1.4";
    private GenAuditRoot root;
    private GenAuditContainer topCat;
    private GenAuditContainer child1;
    private GenAuditContainer child2;
    private GenAuditRule rule0;
    private GenAuditRule rule1;
    private GenAuditRule rule2;

    public AuditHandcodedTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.root = GMFGenFactory.eINSTANCE.createGenAuditRoot();
        this.topCat = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.root.getCategories().add((Object)this.topCat);
        this.topCat.getPath().add((Object)this.topCat);
        this.rule0 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        this.root.getRules().add((Object)this.rule0);
        this.rule0.setCategory(this.topCat);
        this.child1 = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.root.getCategories().add((Object)this.child1);
        this.child1.getPath().add((Object)this.topCat);
        this.child1.getPath().add((Object)this.child1);
        this.rule1 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        this.root.getRules().add((Object)this.rule1);
        this.rule1.setCategory(this.child1);
        this.child2 = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.root.getCategories().add((Object)this.child2);
        this.child2.getPath().add((Object)this.topCat);
        this.child2.getPath().add((Object)this.child1);
        this.child2.getPath().add((Object)this.child2);
        this.rule2 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        this.root.getRules().add((Object)this.rule2);
        this.rule2.setCategory(this.child2);
    }

    public void testRulesToContextMap() {
        GenDiagramElementTarget diagramElementTarget1 = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
        diagramElementTarget1.getElement().add((Object)this.getSetup().getGenModel().getNodeA());
        GenDiagramElementTarget diagramElementTarget2 = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
        diagramElementTarget2.getElement().add((Object)this.getSetup().getGenModel().getLinkC());
        GenDomainElementTarget domainElementTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
        domainElementTarget.setElement(this.getSetup().getGenModel().getNodeA().getDomainMetaClass());
        GenNotationElementTarget notationElementTarget = GMFGenFactory.eINSTANCE.createGenNotationElementTarget();
        notationElementTarget.setElement(this.getSetup().getGenModel().getLinkC().getDiagramRunTimeClass());
        GenRuleTarget[] targets = new GenRuleTarget[]{diagramElementTarget1, diagramElementTarget2, domainElementTarget, notationElementTarget};
        int expectedCtxCount = targets.length - 1;
        int numberOfAuditsToAdd = expectedCtxCount * 2 - this.root.getRules().size();
        int i = 0;
        while (i < numberOfAuditsToAdd) {
            GenAuditRule r = GMFGenFactory.eINSTANCE.createGenAuditRule();
            this.root.getRules().add((Object)r);
            r.setCategory(this.topCat);
            ++i;
        }
        i = 0;
        for (GenAuditRule audit : this.root.getRules()) {
            audit.setTarget((GenAuditable)EcoreUtil.copy((EObject)targets[i % targets.length]));
            IStatus s = JavaConventions.validateIdentifier((String)audit.getContextSelectorLocalClassName(), (String)"1.4", (String)"1.4");
            AuditHandcodedTest.assertTrue((String)"Context selectorClassLocalName must valid java name", (s.getSeverity() != 4 ? 1 : 0) != 0);
            String ctxID = audit.getTarget().getClientContextID();
            s = JavaConventions.validateIdentifier((String)ctxID, (String)"1.4", (String)"1.4");
            AuditHandcodedTest.assertTrue((String)"Context ID must be a valid java identifier", (s.getSeverity() != 4 ? 1 : 0) != 0);
            ++i;
        }
        this.assertTargetedModels(targets);
    }

    public void testModelConstraintAdapters() throws Exception {
        int i = 1;
        for (GenAuditRule nextAudit : this.root.getRules()) {
            AuditHandcodedTest.assertEquals((String)("Adapter" + i), (String)nextAudit.getConstraintAdapterLocalClassName());
            ++i;
        }
    }

    private void assertTargetedModels(GenRuleTarget[] targets) {
        List packageList = this.root.getTargetedModelPackages();
        AuditHandcodedTest.assertFalse((boolean)packageList.isEmpty());
        int i = 0;
        while (i < targets.length) {
            AuditHandcodedTest.assertTrue((String)"Package must be found targeted packages", (boolean)packageList.contains(targets[i].getContext().getGenPackage()));
            ++i;
        }
    }
}

