/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.core.commands.GroupCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.BringForwardCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.BringToFrontCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.SendBackwardCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.SendToBackCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.PasteCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.DuplicateViewsCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.RefreshEditPartCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SnapCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.IInternalLayoutRunnable;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.PasteViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ZOrderRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;

public class ContainerEditPolicy
extends org.eclipse.gef.editpolicies.ContainerEditPolicy {
    protected Command getAddCommand(GroupRequest request) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    public Command getOrphanChildrenCommand(GroupRequest request) {
        return null;
    }

    protected Command getPasteCommand(PasteViewRequest request) {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.getHost();
        View viewContext = (View)editPart.getAdapter(View.class);
        ICustomData[] data = request.getData();
        if (data != null && viewContext != null && editPart instanceof ISurfaceEditPart) {
            return new ICommandProxy((ICommand)new PasteCommand(editPart.getEditingDomain(), DiagramUIMessages.PasteCommand_Label, viewContext, data, MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)this.getHost()).getFigure())));
        }
        return null;
    }

    private List sortSelection(List editPartsToSort) {
        if (editPartsToSort.size() < 2) {
            return editPartsToSort;
        }
        ArrayList toReturn = new ArrayList(editPartsToSort.size());
        toReturn.addAll(editPartsToSort);
        Collections.sort(toReturn, new EditPartComparator());
        return toReturn;
    }

    private List reverseSortSelection(List toSort) {
        List toReturn = this.sortSelection(toSort);
        Collections.reverse(toReturn);
        return toReturn;
    }

    protected Command getBringToFrontCommand(ZOrderRequest request) {
        CompositeCommand toReturn = new CompositeCommand("");
        for (IGraphicalEditPart element : this.sortSelection(request.getPartsToOrder())) {
            toReturn.compose((IUndoableOperation)new BringToFrontCommand(element.getEditingDomain(), (View)element.getModel()));
        }
        return new ICommandProxy((ICommand)toReturn);
    }

    protected Command getBringForwardCommand(ZOrderRequest request) {
        CompositeCommand toReturn = new CompositeCommand("");
        for (IGraphicalEditPart toOrder : this.reverseSortSelection(request.getPartsToOrder())) {
            toReturn.compose((IUndoableOperation)new BringForwardCommand(toOrder.getEditingDomain(), (View)toOrder.getModel()));
        }
        return new ICommandProxy((ICommand)toReturn);
    }

    protected Command getSendToBackCommand(ZOrderRequest request) {
        CompositeCommand toReturn = new CompositeCommand("");
        for (IGraphicalEditPart toOrder : this.reverseSortSelection(request.getPartsToOrder())) {
            toReturn.compose((IUndoableOperation)new SendToBackCommand(toOrder.getEditingDomain(), (View)toOrder.getModel()));
        }
        return new ICommandProxy((ICommand)toReturn);
    }

    protected Command getSendBackwardCommand(ZOrderRequest request) {
        CompositeCommand toReturn = new CompositeCommand("");
        for (IGraphicalEditPart toOrder : this.sortSelection(request.getPartsToOrder())) {
            toReturn.compose((IUndoableOperation)new SendBackwardCommand(toOrder.getEditingDomain(), (View)toOrder.getModel()));
        }
        return new ICommandProxy((ICommand)toReturn);
    }

    protected Command getArrangeCommand(ArrangeRequest request) {
        IPreferenceStore preferenceStore;
        if ("arrange_deferred".equals(request.getType())) {
            String layoutType = request.getLayoutType();
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            return new ICommandProxy((ICommand)new DeferredLayoutCommand(editingDomain, request.getViewAdaptersToArrange(), (IGraphicalEditPart)this.getHost(), layoutType));
        }
        String layoutDesc = request.getLayoutType() != null ? request.getLayoutType() : "DEFAULT";
        boolean offsetFromBoundingBox = false;
        List editparts = new ArrayList();
        if ("arrangeAllAction".equals(request.getType()) || "toolbarArrangeAllAction".equals(request.getType())) {
            editparts = ((IGraphicalEditPart)this.getHost()).getChildren();
            request.setPartsToArrange(editparts);
        }
        if ("arrangeSelectionAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType())) {
            editparts = request.getPartsToArrange();
            if (editparts.size() < 2 || !(((GraphicalEditPart)((EditPart)editparts.get(0)).getParent()).getContentPane().getLayoutManager() instanceof XYLayout)) {
                return null;
            }
            offsetFromBoundingBox = true;
        }
        if ("arrange_radial".equals(request.getType())) {
            editparts = request.getPartsToArrange();
            offsetFromBoundingBox = true;
            layoutDesc = "RADIAL";
        }
        if (editparts.isEmpty()) {
            return null;
        }
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(editparts.size());
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            IGraphicalEditPart ep = (IGraphicalEditPart)li.next();
            View view = ep.getNotationView();
            if (!ep.isActive() || view == null || !(view instanceof Node)) continue;
            Rectangle bounds = ep.getFigure().getBounds();
            nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<String> hints = new ArrayList<String>(2);
        hints.add(layoutDesc);
        hints.add((String)this.getHost());
        ObjectAdapter layoutHint = new ObjectAdapter(hints);
        final Runnable layoutRun = this.layoutNodes(nodes, offsetFromBoundingBox, (IAdaptable)layoutHint);
        boolean isSnap = true;
        IGraphicalEditPart firstEditPart = (IGraphicalEditPart)editparts.get(0);
        if (firstEditPart.getViewer() instanceof DiagramGraphicalViewer && (preferenceStore = ((DiagramGraphicalViewer)firstEditPart.getViewer()).getWorkspaceViewerPreferenceStore()) != null) {
            isSnap = preferenceStore.getBoolean("rulergrid.snaptogrid");
        }
        CompoundCommand cmd = new CompoundCommand();
        if (layoutRun instanceof IInternalLayoutRunnable) {
            cmd.add(((IInternalLayoutRunnable)layoutRun).getCommand());
        } else {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            cmd.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    layoutRun.run();
                    return CommandResult.newOKCommandResult();
                }
            }));
        }
        if (isSnap) {
            cmd.add(this.getSnapCommand(request));
        }
        return cmd;
    }

    public Runnable layoutNodes(List nodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(nodes, offsetFromBoundingBox, layoutHint);
        return layoutRun;
    }

    private Command getDuplicateCommand(DuplicateRequest request) {
        ArrayList<Object> notationViewsToDuplicate = new ArrayList<Object>();
        HashSet<EObject> elementsToDuplicate = new HashSet<EObject>();
        for (Object ep : request.getEditParts()) {
            View view;
            if (ep instanceof GroupEditPart) {
                return UnexecutableCommand.INSTANCE;
            }
            if (!(ep instanceof ConnectionEditPart) && !(ep instanceof ShapeEditPart) && !(ep instanceof ListItemEditPart) || (view = (View)((IGraphicalEditPart)ep).getModel()) == null) continue;
            notationViewsToDuplicate.add(view);
        }
        ClipboardSupportUtil.getCopyElements(notationViewsToDuplicate);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        for (View view : notationViewsToDuplicate) {
            EObject resolvedElement;
            EObject element = view.getElement();
            if (element == null || (resolvedElement = EMFCoreUtil.resolve((TransactionalEditingDomain)editingDomain, (EObject)element)) == null) continue;
            elementsToDuplicate.add(resolvedElement);
        }
        HashSet allInnerEdges = new HashSet();
        Iterator iterator = notationViewsToDuplicate.iterator();
        while (iterator.hasNext()) {
            ViewUtil.getAllRelatedEdgesFromViews((List)((View)iterator.next()).getChildren(), allInnerEdges);
        }
        notationViewsToDuplicate.addAll(allInnerEdges);
        if (!notationViewsToDuplicate.isEmpty()) {
            if (!elementsToDuplicate.isEmpty()) {
                DuplicateElementsRequest duplicateElementsRequest = new DuplicateElementsRequest(editingDomain, new ArrayList(elementsToDuplicate));
                Command duplicateElementsCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)duplicateElementsRequest, request.getExtendedData()));
                if (duplicateElementsCommand != null && duplicateElementsCommand.canExecute()) {
                    CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_Duplicate_Label);
                    cc.compose((IUndoableOperation)new CommandProxy(duplicateElementsCommand));
                    cc.compose((IUndoableOperation)new DuplicateViewsCommand(editingDomain, DiagramUIMessages.Commands_Duplicate_Label, request, notationViewsToDuplicate, duplicateElementsRequest.getAllDuplicatedElementsMap(), this.getDuplicateViewsOffset(request)));
                    return new ICommandProxy((ICommand)cc);
                }
            } else {
                return new ICommandProxy((ICommand)new DuplicateViewsCommand(editingDomain, DiagramUIMessages.Commands_Duplicate_Label, request, notationViewsToDuplicate, this.getDuplicateViewsOffset(request)));
            }
        }
        return null;
    }

    private Point getDuplicateViewsOffset(DuplicateRequest request) {
        if (request.getOffset() != null) {
            return request.getOffset();
        }
        int offset = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)this.getHost()).getFigure()).DPtoLP(10);
        return new Point(offset, offset);
    }

    private Command getSnapCommand(Request request) {
        List editparts = null;
        if (request instanceof GroupRequest) {
            editparts = ((GroupRequest)request).getEditParts();
        } else if (request instanceof ArrangeRequest) {
            editparts = ((ArrangeRequest)request).getPartsToArrange();
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (editparts != null) {
            return new ICommandProxy((ICommand)new SnapCommand(editingDomain, editparts));
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("groupAction".equals(request.getType()) && request instanceof GroupRequest) {
            return this.getGroupCommand((GroupRequest)request);
        }
        if (request instanceof ArrangeRequest) {
            return this.getArrangeCommand((ArrangeRequest)request);
        }
        if ("snap_to_grid".equals(request.getType())) {
            return this.getSnapCommand(request);
        }
        if ("refresh".equals(request.getType())) {
            IGraphicalEditPart containerEP = (IGraphicalEditPart)this.getHost();
            CompositeCommand cc = new CompositeCommand("");
            ListIterator li = containerEP.getChildren().listIterator();
            while (li.hasNext()) {
                cc.compose((IUndoableOperation)new RefreshEditPartCommand((IGraphicalEditPart)li.next(), false));
            }
            cc.compose((IUndoableOperation)new RefreshEditPartCommand((IGraphicalEditPart)this.getHost(), true));
            return new ICommandProxy((ICommand)cc);
        }
        if ("paste".equals(request.getType())) {
            return this.getPasteCommand((PasteViewRequest)request);
        }
        if ("duplicate".equals(request.getType())) {
            return this.getDuplicateCommand((DuplicateRequest)request);
        }
        if ("bringToFrontAction".equals(request.getType())) {
            return this.getBringToFrontCommand((ZOrderRequest)request);
        }
        if ("bringForwardAction".equals(request.getType())) {
            return this.getBringForwardCommand((ZOrderRequest)request);
        }
        if ("sendToBackAction".equals(request.getType())) {
            return this.getSendToBackCommand((ZOrderRequest)request);
        }
        if ("sendBackwardAction".equals(request.getType())) {
            return this.getSendBackwardCommand((ZOrderRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getGroupCommand(GroupRequest request) {
        LinkedList<Object> shapeViews = new LinkedList<Object>();
        IGraphicalEditPart parentEP = null;
        for (Object editpart : request.getEditParts()) {
            if (!(editpart instanceof ShapeEditPart)) continue;
            if (!((IEditableEditPart)editpart).isEditModeEnabled()) {
                return null;
            }
            if (editpart instanceof IBorderItemEditPart) {
                return null;
            }
            if (parentEP != null) {
                if (parentEP != ((ShapeEditPart)editpart).getParent()) {
                    return null;
                }
            } else {
                parentEP = (IGraphicalEditPart)((ShapeEditPart)editpart).getParent();
            }
            if (!(((ShapeEditPart)editpart).getModel() instanceof Node)) continue;
            shapeViews.add(((ShapeEditPart)editpart).getModel());
        }
        if (parentEP == null || !parentEP.isEditModeEnabled()) {
            return null;
        }
        GroupCommand cmd = new GroupCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), shapeViews);
        return new ICommandProxy((ICommand)cmd);
    }

    public EditPart getTargetEditPart(Request request) {
        return this.understandsRequest(request) ? this.getHost() : null;
    }

    public boolean understandsRequest(Request request) {
        return "arrangeAllAction".equals(request.getType()) || "toolbarArrangeAllAction".equals(request.getType()) || "arrangeSelectionAction".equals(request.getType()) || "groupAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType()) || "arrange_radial".equals(request.getType()) || "arrange_deferred".equals(request.getType()) || "refresh".equals(request.getType()) || "paste".equals(request.getType()) || "duplicate".equals(request.getType()) || "snap_to_grid".equals(request.getType()) || "bringToFrontAction".equals(request.getType()) || "bringForwardAction".equals(request.getType()) || "sendToBackAction".equals(request.getType()) || "sendBackwardAction".equals(request.getType());
    }

    private class EditPartComparator
    implements Comparator {
        private EditPartComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            EditPart ep0 = (EditPart)arg0;
            EditPart ep1 = (EditPart)arg1;
            EditPart parent = ep0.getParent();
            int ep0Index = parent.getChildren().indexOf(ep0);
            int ep1Index = parent.getChildren().indexOf(ep1);
            return ep0Index - ep1Index;
        }
    }
}

