/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.contentassist.ContentAssistantHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class TextDirectEditManager
extends DirectEditManager {
    private Color proposalPopupBackgroundColor = null;
    private Color proposalPopupForegroundColor = null;
    private boolean committed = false;
    private boolean listenersAttached = true;
    private StringBuffer initialString = new StringBuffer();
    private List cachedFontDescriptors = new ArrayList();
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private Font zoomLevelFont = null;
    private AncestorListener textFigureListener;
    private Class editorType;

    public TextDirectEditManager(ITextAwareEditPart source) {
        this(source, null, TextDirectEditManager.getTextCellEditorLocator(source));
    }

    public TextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
        this.editorType = editorType;
    }

    public static CellEditorLocator getTextCellEditorLocator(final ITextAwareEditPart source) {
        final ILabelDelegate label = (ILabelDelegate)source.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return new CellEditorLocator(){

                public void relocate(CellEditor celleditor) {
                    org.eclipse.swt.graphics.Rectangle newRect;
                    Text text = (Text)celleditor.getControl();
                    Rectangle rect = label.getTextBounds().getCopy();
                    if (label.getText().length() <= 0) {
                        rect.setSize(new Dimension(text.computeSize(-1, -1)));
                        if (label.isTextWrapOn()) {
                            if (label.getTextJustification() == 4) {
                                rect.translate(-rect.width, 0);
                            } else if (label.getTextJustification() == 2) {
                                rect.translate(-rect.width / 2, 0);
                            }
                        }
                    }
                    if (label.isTextWrapOn()) {
                        if (!text.getFont().isDisposed()) {
                            int charHeight = FigureUtilities.getFontMetrics((Font)text.getFont()).getHeight();
                            rect.resize(0, charHeight / 2);
                        }
                    } else {
                        rect.setSize(new Dimension(text.computeSize(-1, -1)));
                        int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                        rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                    }
                    if (!(newRect = text.computeTrim(rect.x, rect.y, rect.width, rect.height)).equals((Object)text.getBounds())) {
                        text.setBounds(newRect.x, newRect.y, newRect.width, newRect.height);
                    }
                }
            };
        }
        return new CellEditorLocator(){

            public void relocate(CellEditor celleditor) {
                Text text = (Text)celleditor.getControl();
                Rectangle rect = source.getFigure().getBounds().getCopy();
                source.getFigure().translateToAbsolute((Translatable)rect);
                if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                    text.setBounds(rect.x, rect.y, rect.width, rect.height);
                }
            }
        };
    }

    public static Class getTextCellEditorClass(GraphicalEditPart source) {
        IFigure figure = source.getFigure();
        if (figure instanceof WrapLabel && ((WrapLabel)figure).isTextWrapped()) {
            return WrapTextCellEditor.class;
        }
        return TextCellEditorEx.class;
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        if (this.editorType != null) {
            return super.createCellEditorOn(composite);
        }
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && label.isTextWrapOn()) {
            int style = 66;
            switch (label.getTextJustification()) {
                case 1: {
                    style |= 0x4000;
                    break;
                }
                case 4: {
                    style |= 0x20000;
                    break;
                }
                case 2: {
                    style |= 0x1000000;
                    break;
                }
            }
            return new WrapTextCellEditor(composite, style);
        }
        return new TextCellEditorEx(composite);
    }

    protected Font getScaledFont(IFigure label) {
        Font scaledFont = label.getFont();
        FontData data = scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, MapModeUtil.getMapMode((IFigure)label).DPtoLP(data.getHeight()));
        label.translateToAbsolute((Translatable)fontSize);
        if (Math.abs(data.getHeight() - fontSize.height) < 2) {
            fontSize.height = data.getHeight();
        }
        try {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)data);
            this.cachedFontDescriptors.add(fontDescriptor);
            return this.getResourceManager().createFont(fontDescriptor);
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getScaledFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getScaledFont", (Throwable)e);
            return JFaceResources.getDefaultFont();
        }
    }

    protected void initCellEditor() {
        IContentAssistProcessor processor;
        this.committed = false;
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        this.setEditText(textEP.getEditText());
        IFigure label = textEP.getFigure();
        Assert.isNotNull((Object)label);
        Text text = (Text)this.getCellEditor().getControl();
        text.setFont(this.getScaledFont(label));
        this.getCellEditor().setValidator(textEP.getEditTextValidator());
        if (textEP.getParser() != null && (processor = textEP.getCompletionProcessor()) != null) {
            this.proposalPopupBackgroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(254, 241, 233));
            this.proposalPopupForegroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(0, 0, 0));
            ContentAssistantHelper.createTextContentAssistant((Text)text, (Color)this.proposalPopupForegroundColor, (Color)this.proposalPopupBackgroundColor, (IContentAssistProcessor)processor);
        }
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    protected void commit() {
        Control[] children;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell != null && this.getCellEditor().getControl().getShell().equals(activeShell.getParent()) && (children = activeShell.getChildren()).length == 1 && children[0] instanceof Table) {
            this.getCellEditor().getControl().setVisible(true);
            ((TextCellEditorEx)this.getCellEditor()).setDeactivationLock(true);
            return;
        }
        if (this.committed) {
            this.bringDown();
            return;
        }
        this.committed = true;
        super.commit();
    }

    protected void bringDown() {
        if (this.proposalPopupForegroundColor != null) {
            this.proposalPopupForegroundColor.dispose();
            this.proposalPopupForegroundColor = null;
        }
        if (this.proposalPopupBackgroundColor != null) {
            this.proposalPopupBackgroundColor.dispose();
            this.proposalPopupBackgroundColor = null;
        }
        this.eraseFeedback();
        this.initialString = new StringBuffer();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                TextDirectEditManager.super.bringDown();
            }
        });
        Iterator iter = this.cachedFontDescriptors.iterator();
        while (iter.hasNext()) {
            this.getResourceManager().destroyFont((FontDescriptor)iter.next());
        }
        this.cachedFontDescriptors.clear();
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    public void setEditText(String toEdit) {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        Text textControl = (Text)cellEditor.getControl();
        textEP.setLabelText(toEdit);
        if (cellEditor instanceof TextCellEditorEx) {
            ((TextCellEditorEx)cellEditor).setValueAndProcessEditOccured((Object)toEdit);
        } else {
            cellEditor.setValue((Object)toEdit);
        }
        textControl.setSelection(toEdit.length());
    }

    public void show(char initialChar) {
        this.initialString = this.initialString.append(initialChar);
        this.show();
        if (SWT.getPlatform() != "carbon") {
            this.setEditText(this.initialString.toString());
        }
    }

    private Font getZoomLevelFont(Font actualFont, Display display) {
        Object zoom = this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoom != null) {
            double zoomLevel = ((ZoomManager)zoom).getZoom();
            if (zoomLevel == 1.0) {
                return actualFont;
            }
            FontData[] fd = new FontData[actualFont.getFontData().length];
            FontData tempFD = null;
            int i = 0;
            while (i < fd.length) {
                tempFD = actualFont.getFontData()[i];
                fd[i] = new FontData(tempFD.getName(), (int)(zoomLevel * (double)tempFD.getHeight()), tempFD.getStyle());
                ++i;
            }
            try {
                FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData[])fd);
                this.cachedFontDescriptors.add(fontDescriptor);
                return this.getResourceManager().createFont(fontDescriptor);
            }
            catch (DeviceResourceException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getZoomLevelFonts", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getZoomLevelFonts", (Throwable)e);
                return actualFont;
            }
        }
        return actualFont;
    }

    public void show() {
        super.show();
        IFigure fig = this.getEditPart().getFigure();
        Control control = this.getCellEditor().getControl();
        this.zoomLevelFont = this.getZoomLevelFont(fig.getFont(), control.getDisplay());
        control.setFont(this.zoomLevelFont);
        this.getLocator().relocate(this.getCellEditor());
    }

    public void show(Point location) {
        this.show();
        this.sendClickToCellEditor(location);
    }

    private void sendClickToCellEditor(Point location) {
        this.getCellEditor().getControl().setCapture(true);
        if (this.getCellEditor() != null && this.getCellEditor().getControl().getBounds().contains(location)) {
            this.sendMouseClick(location);
        }
    }

    private void sendMouseClick(final Point location) {
        final Display currDisplay = Display.getCurrent();
        new Thread(){
            Event event;

            public void run() {
                this.event = new Event();
                this.event.type = 3;
                this.event.button = 1;
                this.event.x = location.x;
                this.event.y = location.y;
                currDisplay.post(this.event);
                this.event.type = 4;
                currDisplay.post(this.event);
            }
        }.start();
    }

    protected void hookListeners() {
        super.hookListeners();
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && this.getEditPart().getFigure() instanceof WrappingLabel) {
            this.textFigureListener = new AncestorListener.Stub(){

                public void ancestorMoved(IFigure ancestor) {
                    TextDirectEditManager.this.getLocator().relocate(TextDirectEditManager.this.getCellEditor());
                }
            };
            ((IFigure)((WrappingLabel)this.getEditPart().getFigure()).getTextFigure().getChildren().get(0)).addAncestorListener(this.textFigureListener);
        }
    }

    protected void unhookListeners() {
        if (this.listenersAttached) {
            this.listenersAttached = false;
            super.unhookListeners();
            ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
            if (label != null && this.textFigureListener != null) {
                ((IFigure)((WrappingLabel)this.getEditPart().getFigure()).getTextFigure().getChildren().get(0)).removeAncestorListener(this.textFigureListener);
                this.textFigureListener = null;
            }
        }
    }

    protected void setCellEditor(CellEditor editor) {
        super.setCellEditor(editor);
        if (editor != null) {
            this.listenersAttached = true;
        }
    }

    public void showFeedback() {
        try {
            this.getEditPart().getRoot();
            super.showFeedback();
        }
        catch (Exception exception) {}
    }

    protected ResourceManager getResourceManager() {
        return ((DiagramGraphicalViewer)this.getEditPart().getViewer()).getResourceManager();
    }

    private void saveCurrentActions(IActionBars _actionBars) {
        this.copy = _actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = _actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = _actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = _actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = _actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = _actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = _actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = _actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void restoreSavedActions(IActionBars _actionBars) {
        _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }
}

