/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.gmf.internal.common.codegen.OrganizeImportsPostprocessor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizeImportsPostprocessorTest
extends TestCase {
    private static final String nl = System.getProperty("line.separator");

    public void testFullQualifiedFields() throws Exception {
        String className = "TestFullQualifiedFields";
        String[] fieldTypes = new String[]{List.class.getName(), RectangleFigure.class.getName(), this.getInnerClassAwareName(Map.Entry.class), Map.class.getName(), String.valueOf(this.getInnerClassAwareName(Iterator.class)) + "_eINSTANCE"};
        String code = this.generateClassCode(className, null, null, null, fieldTypes, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor(true);
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        final ArrayList fieldList = new ArrayList(fieldTypes.length);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)fieldTypes.length, (int)imports.size());
        fieldList.clear();
        fieldList.addAll(Arrays.asList(fieldTypes));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)fieldList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + fieldList.size() + " more types"), (boolean)fieldList.isEmpty());
        fieldList.clear();
        fieldList.addAll(Arrays.asList(fieldTypes));
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(fieldList));
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + fieldList.size() + " more types"), (boolean)fieldList.isEmpty());
    }

    public void testFullQualifiedMethodParams() throws Exception {
        String className = "TestFullQualifiedMethodParams";
        String[] methodParams = new String[]{List.class.getName(), RectangleFigure.class.getName(), this.getInnerClassAwareName(Map.Entry.class), Map.class.getName()};
        String code = this.generateClassCode(className, null, null, null, null, methodParams, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        final ArrayList methodsList = new ArrayList();
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)methodParams.length, (int)imports.size());
        methodsList.addAll(Arrays.asList(methodParams));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)methodsList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + methodsList.size() + " more types"), (boolean)methodsList.isEmpty());
        methodsList.clear();
        methodsList.addAll(Arrays.asList(methodParams));
        cu.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                for (SingleVariableDeclaration next : node.parameters()) {
                    next.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(methodsList));
                }
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + methodsList.size() + " more types"), (boolean)methodsList.isEmpty());
    }

    public void testFullQualifiedMethodExceptions() throws Exception {
        String className = "TestFullQualifiedMethodExceptions";
        String[] methodExceptions = new String[]{List.class.getName(), RectangleFigure.class.getName(), this.getInnerClassAwareName(Map.Entry.class), Map.class.getName(), "org.eclipse.core.commands.ExecutionException"};
        String code = this.generateClassCode(className, null, null, null, null, null, null, null, methodExceptions);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        final ArrayList exceptionsList = new ArrayList();
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)methodExceptions.length, (int)imports.size());
        exceptionsList.addAll(Arrays.asList(methodExceptions));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)exceptionsList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + exceptionsList.size() + " more types"), (boolean)exceptionsList.isEmpty());
        exceptionsList.clear();
        exceptionsList.addAll(Arrays.asList(methodExceptions));
        cu.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                for (Name next : node.thrownExceptions()) {
                    next.accept((ASTVisitor)new ExpectedSimpleNamesVisitor(exceptionsList));
                }
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + exceptionsList.size() + " more types"), (boolean)exceptionsList.isEmpty());
        exceptionsList.clear();
        exceptionsList.addAll(Arrays.asList(methodExceptions));
        cu.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                node.getBody().accept(new ASTVisitor(){

                    public boolean visit(ThrowStatement node) {
                        node.getExpression().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(exceptionsList));
                        return super.visit(node);
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + exceptionsList.size() + " more types"), (boolean)exceptionsList.isEmpty());
    }

    public void testFullQualifiedLocalVariables() throws Exception {
        String className = "TestFullQualifiedLocalVariables";
        String[] localVars = new String[]{List.class.getName(), RectangleFigure.class.getName(), this.getInnerClassAwareName(Map.Entry.class), Map.class.getName()};
        String code = this.generateClassCode(className, null, null, null, null, null, null, localVars, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        final ArrayList varsList = new ArrayList(localVars.length);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)localVars.length, (int)imports.size());
        varsList.addAll(Arrays.asList(localVars));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)varsList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + varsList.size() + " more types"), (boolean)varsList.isEmpty());
        varsList.clear();
        varsList.addAll(Arrays.asList(localVars));
        cu.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                node.getBody().accept(new ASTVisitor(){

                    public boolean visit(VariableDeclarationStatement node) {
                        node.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(varsList));
                        return super.visit(node);
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + varsList.size() + " more types"), (boolean)varsList.isEmpty());
    }

    public void testFullQualifiedSupers() throws Exception {
        String className = "TestFullQualifiedSupers";
        String superClass = RectangleFigure.class.getName();
        String[] superInterfaces = new String[]{Collection.class.getName(), Iterator.class.getName()};
        String code = this.generateClassCode(className, null, superClass, superInterfaces, null, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        ArrayList<String> supersList = new ArrayList<String>(superInterfaces.length + 1);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)(superInterfaces.length + 1), (int)imports.size());
        supersList.clear();
        supersList.add(superClass);
        supersList.addAll((Collection)Arrays.asList(superInterfaces));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)supersList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + supersList.size() + " more types"), (boolean)supersList.isEmpty());
        supersList.clear();
        supersList.add(superClass);
        supersList.addAll((Collection)Arrays.asList(superInterfaces));
        final ExpectedSimpleNamesVisitor typeVisitor = new ExpectedSimpleNamesVisitor(supersList);
        cu.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                node.getSuperclassType().accept(typeVisitor);
                Iterator it = node.superInterfaceTypes().iterator();
                while (it.hasNext()) {
                    ((Type)it.next()).accept(typeVisitor);
                }
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + supersList.size() + " more types"), (boolean)supersList.isEmpty());
    }

    public void testFieldConflictWithDeclaredType() throws Exception {
        String className = "FieldConflictWithDeclaredType";
        String[] fieldTypes = new String[]{Collection.class.getName()};
        StringBuffer code = new StringBuffer();
        String mainClass = this.generateClassCode(className, null, null, null, fieldTypes, null, null, null, null);
        String innerClass = this.generateClassCode(Collection.class.getSimpleName(), null, null, null, null, null, null, null, null);
        code.append(mainClass).insert(mainClass.length() - 1, innerClass);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code.toString());
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertTrue((String)"Failed not to generate conflicted import statements", (boolean)imports.isEmpty());
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to preserve conflicted types qualified", (String)code.toString(), (String)icu.getBuffer().getContents());
        final ArrayList fieldsList = new ArrayList(fieldTypes.length);
        fieldsList.clear();
        fieldsList.addAll(Arrays.asList(fieldTypes));
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept(new ASTVisitor(){

                    public boolean visit(QualifiedName node) {
                        boolean found = false;
                        Iterator it = fieldsList.iterator();
                        while (it.hasNext()) {
                            String nextFullTypeName = (String)it.next();
                            if (!nextFullTypeName.equals(node.getFullyQualifiedName())) continue;
                            it.remove();
                            found = true;
                            break;
                        }
                        OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected simple type found " + node.getFullyQualifiedName()), (boolean)found);
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + fieldsList.size() + " more types"), (boolean)fieldsList.isEmpty());
    }

    public void testImportConflictWithDeclaredType() throws Exception {
        String className = "ImportConflictWithDeclaredType";
        String[] importedTypes = new String[]{Collection.class.getName()};
        StringBuffer code = new StringBuffer();
        String mainClass = this.generateClassCode(className, importedTypes, null, null, null, null, null, null, null);
        String innerClass = this.generateClassCode(Collection.class.getSimpleName(), null, null, null, null, null, null, null, null);
        code.append(mainClass).insert(mainClass.length() - 1, innerClass);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code.toString());
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        ArrayList importsList = new ArrayList(importedTypes.length);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)importedTypes.length, (int)imports.size());
        importsList.clear();
        importsList.addAll(Arrays.asList(importedTypes));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)importsList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + importsList.size() + " more types"), (boolean)importsList.isEmpty());
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to preserve conflicted types qualified", (String)code.toString(), (String)icu.getBuffer().getContents());
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + importsList.size() + " more types"), (boolean)importsList.isEmpty());
    }

    public void testImportConflictWithQualifiedTypeRef() throws Exception {
        String className = "ImportConflictWithQualifiedTypeRef";
        String[] importedTypes = new String[]{Collection.class.getName()};
        StringBuffer code = new StringBuffer();
        String mainClass = this.generateClassCode(className, importedTypes, null, null, null, null, null, null, null);
        String innerClass = this.generateClassCode(Collection.class.getSimpleName(), null, Collection.class.getName(), null, null, null, null, null, null);
        code.append(mainClass).insert(mainClass.length() - 1, innerClass);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code.toString());
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        ArrayList importsList = new ArrayList(importedTypes.length);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)importedTypes.length, (int)imports.size());
        importsList.clear();
        importsList.addAll(Arrays.asList(importedTypes));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)importsList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + importsList.size() + " more types"), (boolean)importsList.isEmpty());
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + importsList.size() + " more types"), (boolean)importsList.isEmpty());
    }

    public void testImportConflictWithSuperTypeRef() throws Exception {
        String className = "ImportConflictWithSuperTypeRef";
        String[] importedTypes = new String[]{Collection.class.getName()};
        String conflicted = "my.own.Collection";
        String code = this.generateClassCode(className, importedTypes, conflicted, null, null, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        ArrayList importsList = new ArrayList(importedTypes.length);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)importedTypes.length, (int)imports.size());
        importsList.clear();
        importsList.addAll(Arrays.asList(importedTypes));
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)importsList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + importsList.size() + " more types"), (boolean)importsList.isEmpty());
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to preserve conflicted types qualified", (String)code.toString(), (String)icu.getBuffer().getContents());
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + importsList.size() + " more types"), (boolean)importsList.isEmpty());
    }

    public void testLocalVarConflictWithDeclaredType() throws Exception {
        String className = "TestFullQualifiedLocalVariables";
        String[] localVars = new String[]{Collection.class.getName()};
        StringBuffer code = new StringBuffer();
        String mainClass = this.generateClassCode(className, null, null, null, null, null, null, null, null);
        String innerClass = this.generateClassCode(Collection.class.getSimpleName(), null, null, null, null, null, null, localVars, null);
        code.append(mainClass).insert(mainClass.length() - 1, innerClass);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code.toString());
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertTrue((String)"Failed not to generate conflicting imports", (boolean)imports.isEmpty());
        final ArrayList varsList = new ArrayList(Arrays.asList(localVars));
        cu.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                node.getBody().accept(new ASTVisitor(){

                    public boolean visit(VariableDeclarationStatement node) {
                        node.getType().accept(new ASTVisitor(){

                            public boolean visit(QualifiedName node) {
                                boolean found = false;
                                Iterator it = varsList.iterator();
                                while (it.hasNext()) {
                                    String nextFullTypeName = (String)it.next();
                                    if (!nextFullTypeName.equals(node.getFullyQualifiedName())) continue;
                                    it.remove();
                                    found = true;
                                    break;
                                }
                                OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected simple type found " + node.getFullyQualifiedName()), (boolean)found);
                                return false;
                            }
                        });
                        return super.visit(node);
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + varsList.size() + " more types"), (boolean)varsList.isEmpty());
    }

    public void testNotSpoilingExistingImports() throws Exception {
        String className = "NotSpoilingExistingImports";
        String[] existingImports = new String[]{ArrayList.class.getName(), Map.class.getName()};
        String[] fieldTypes = new String[]{List.class.getName(), RectangleFigure.class.getName(), this.getInnerClassAwareName(Map.Entry.class), Map.class.getName(), Map.class.getSimpleName(), ArrayList.class.getSimpleName()};
        String code = this.generateClassCode(className, existingImports, null, null, fieldTypes, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        ArrayList hadImportsList = new ArrayList(Arrays.asList(existingImports));
        final ArrayList<String> uniqueImports = new ArrayList<String>(hadImportsList);
        int i = 0;
        while (i < fieldTypes.length) {
            if (!uniqueImports.contains(fieldTypes[i]) && fieldTypes[i].indexOf(46) != -1) {
                uniqueImports.add(fieldTypes[i]);
            }
            ++i;
        }
        final ArrayList<String> allImports = new ArrayList<String>();
        allImports.addAll(uniqueImports);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)allImports.size(), (int)imports.size());
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)allImports.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + allImports.size() + " more types"), (boolean)allImports.isEmpty());
        allImports.clear();
        allImports.addAll(uniqueImports);
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept(new ASTVisitor(){

                    public boolean visit(QualifiedName node) {
                        OrganizeImportsPostprocessorTest.fail((String)("Unexpected fully qualified field found: " + node.getFullyQualifiedName()));
                        return false;
                    }

                    public boolean visit(SimpleName node) {
                        String name = "." + node.getFullyQualifiedName();
                        boolean found = false;
                        for (String nextFullTypeName : uniqueImports) {
                            if (!nextFullTypeName.endsWith(name)) continue;
                            found = true;
                            break;
                        }
                        OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected simple type found " + name), (boolean)found);
                        Iterator it = allImports.iterator();
                        while (it.hasNext()) {
                            String nextFullTypeName;
                            nextFullTypeName = (String)it.next();
                            if (!nextFullTypeName.endsWith(name)) continue;
                            it.remove();
                            break;
                        }
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + allImports.size() + " more types"), (boolean)allImports.isEmpty());
    }

    public void testNotSpoilingCustomImports() throws Exception {
        String className = "NotSpoilingCustomImports";
        final String conflict = "my.namespace." + ArrayList.class.getSimpleName();
        String[] customImports = new String[]{ArrayList.class.getName()};
        String[] fieldTypes = new String[]{Map.class.getName(), ArrayList.class.getName(), ArrayList.class.getSimpleName(), conflict};
        String code = this.generateClassCode(className, null, null, null, fieldTypes, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, customImports, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        ArrayList hadImportsList = new ArrayList(Arrays.asList(customImports));
        final ArrayList<String> uniqueImports = new ArrayList<String>(hadImportsList);
        int i = 0;
        while (i < fieldTypes.length) {
            if (!conflict.equals(fieldTypes[i]) && !uniqueImports.contains(fieldTypes[i]) && fieldTypes[i].indexOf(46) != -1) {
                uniqueImports.add(fieldTypes[i]);
            }
            ++i;
        }
        final ArrayList<String> allImports = new ArrayList<String>();
        allImports.addAll(uniqueImports);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)allImports.size(), (int)imports.size());
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)allImports.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + allImports.size() + " more types"), (boolean)allImports.isEmpty());
        allImports.clear();
        allImports.addAll(uniqueImports);
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept(new ASTVisitor(){

                    public boolean visit(QualifiedName node) {
                        OrganizeImportsPostprocessorTest.assertEquals((String)("Unexpected fully qualified field found: " + node.getFullyQualifiedName()), (String)conflict, (String)node.getFullyQualifiedName());
                        return false;
                    }

                    public boolean visit(SimpleName node) {
                        String name = "." + node.getFullyQualifiedName();
                        boolean found = false;
                        for (String nextFullTypeName : uniqueImports) {
                            if (!nextFullTypeName.endsWith(name)) continue;
                            found = true;
                            break;
                        }
                        OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected simple type found " + name), (boolean)found);
                        Iterator it = allImports.iterator();
                        while (it.hasNext()) {
                            String nextFullTypeName;
                            nextFullTypeName = (String)it.next();
                            if (!nextFullTypeName.endsWith(name)) continue;
                            it.remove();
                            break;
                        }
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + allImports.size() + " more types"), (boolean)allImports.isEmpty());
    }

    public void testNotToRemoveEvenUnusedImports() throws Exception {
        String className = "TestNotToRemoveEvenUnusedImports";
        String[] existingImports = new String[]{ArrayList.class.getName()};
        String code = this.generateClassCode(className, existingImports, null, null, null, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertFalse((String)"Failed not to remove unused imports", (boolean)imports.isEmpty());
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to preserve everything if there is unused imports", (String)code, (String)icu.getBuffer().getContents());
    }

    public void testNotToImportIfInOnDemandImports() throws Exception {
        String className = "TestNotToImportIfInOnDemandImports";
        String[] existingImports = new String[]{"java.util.*"};
        String[] fieldTypes = new String[]{ArrayList.class.getName()};
        String code = this.generateClassCode(className, existingImports, null, null, fieldTypes, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed not to add extra import if on-demand presents", (int)1, (int)imports.size());
        OrganizeImportsPostprocessorTest.assertTrue((String)"Failed to preserve on-demand imports", (boolean)((ImportDeclaration)imports.get(0)).isOnDemand());
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to preserve right on-demand imports", (String)existingImports[0], (String)(String.valueOf(((ImportDeclaration)imports.get(0)).getName().getFullyQualifiedName()) + ".*"));
        final ArrayList fieldList = new ArrayList();
        fieldList.addAll(Arrays.asList(fieldTypes));
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(fieldList));
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to find references for " + fieldList.size() + " more types"), (boolean)fieldList.isEmpty());
    }

    private String generateClassCode(String className, String[] imports, String extendsType, String[] implementsTypes, String[] fieldTypes, String[] methodParameters, String[] methodReturns, String[] localVariables, String[] methodExceptions) {
        int i;
        StringBuffer buf = new StringBuffer();
        if (imports != null && imports.length > 0) {
            i = 0;
            while (i < imports.length) {
                buf.append("import ").append(imports[i]).append(';').append(nl);
                ++i;
            }
        }
        buf.append(nl);
        buf.append("public class ").append(className);
        if (extendsType != null) {
            buf.append(" extends ").append(extendsType);
        }
        if (implementsTypes != null && implementsTypes.length > 0) {
            buf.append(" implements ");
            i = 0;
            while (i < implementsTypes.length) {
                buf.append(implementsTypes[i]);
                if (i != implementsTypes.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
        }
        buf.append(" {").append(nl);
        buf.append(nl);
        if (fieldTypes != null && fieldTypes.length > 0) {
            i = 0;
            while (i < fieldTypes.length) {
                buf.append("    public ").append(fieldTypes[i]).append(" field").append(i).append(";").append(nl);
                ++i;
            }
        }
        buf.append(nl);
        if (methodParameters != null && methodParameters.length > 0) {
            buf.append("    public void methodWithParams(");
            i = 0;
            while (i < methodParameters.length) {
                buf.append(methodParameters[i]).append(" param").append(i);
                if (i != methodParameters.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append(") {}").append(nl);
        }
        buf.append(nl);
        if (methodReturns != null && methodReturns.length > 0) {
            i = 0;
            while (i < methodReturns.length) {
                buf.append("    public ").append(methodReturns[i]).append(" methodWithReturn").append(i).append("() {").append(nl);
                buf.append("        return null;").append(nl);
                buf.append("    }").append(nl);
                buf.append(nl);
                ++i;
            }
        }
        if (localVariables != null && localVariables.length > 0) {
            buf.append("    public void methodWithLocalVariables() {").append(nl);
            i = 0;
            while (i < localVariables.length) {
                buf.append("        ").append(localVariables[i]).append(" localVar").append(i).append(';').append(nl);
                ++i;
            }
            buf.append("    }").append(nl);
        }
        buf.append(nl);
        if (methodExceptions != null && methodExceptions.length > 0) {
            buf.append("    public Object methodWithExceptions").append("() throws ");
            i = 0;
            while (i < methodExceptions.length) {
                buf.append(methodExceptions[i]);
                if (i != methodExceptions.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append(" {").append(nl);
            buf.append("        return null;").append(nl);
            buf.append("    }").append(nl);
            buf.append(nl);
        }
        buf.append(nl);
        if (methodExceptions != null && methodExceptions.length > 0) {
            buf.append("    public Object methodWithRuntimeExceptions() ");
            buf.append(" {").append(nl);
            i = 0;
            while (i < methodExceptions.length) {
                buf.append("        throw new ").append(methodExceptions[i]).append("();").append(nl);
                ++i;
            }
            buf.append("        return null;").append(nl);
            buf.append("    }").append(nl);
            buf.append(nl);
        }
        buf.append('}');
        return buf.toString();
    }

    public void testFailOnWrongSyntaxInCode() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("public class FailOnWrongSyntaxInCode {").append(nl);
        buf.append(nl);
        buf.append("    private method1() { WRONG-CODE! }").append(nl);
        buf.append(nl);
        buf.append("}").append(nl);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile("FailOnWrongSyntaxInCode.java", buf.toString());
        try {
            new OrganizeImportsPostprocessor().organizeImports(icu, null);
            OrganizeImportsPostprocessorTest.fail((String)"Failed to produce CoreException with code, containing syntax errors");
        }
        catch (CoreException coreException) {
            OrganizeImportsPostprocessorTest.assertTrue((boolean)true);
        }
        icu.save(null, true);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed not to change anything in wrong syntax code", (String)buf.toString(), (String)icu.getBuffer().getContents());
    }

    public void testSimpleAndQualifiedTypesMatch() throws Exception {
        String className = "SimpleAndQualifiedTypesMatch";
        Class[] typeRefs = new Class[]{ArrayList.class};
        String[] fieldTypes = new String[]{typeRefs[0].getName(), typeRefs[0].getSimpleName()};
        String[] existedImports = new String[]{fieldTypes[0]};
        String code = this.generateClassCode(className, existedImports, null, null, fieldTypes, null, null, null, null);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", code);
        OrganizeImportsPostprocessor processor = new OrganizeImportsPostprocessor();
        processor.organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        final ArrayList fieldList = new ArrayList(typeRefs.length);
        fieldList.clear();
        fieldList.addAll(Arrays.asList(existedImports));
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to generate enough import statements", (int)typeRefs.length, (int)imports.size());
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String nextImport = ((ImportDeclaration)it.next()).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected import found: " + nextImport), (boolean)fieldList.remove(nextImport));
        }
        OrganizeImportsPostprocessorTest.assertTrue((String)("Failed to generate import for " + fieldList.size() + " more types"), (boolean)fieldList.isEmpty());
        fieldList.clear();
        fieldList.addAll(Arrays.asList(existedImports));
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(fieldList){

                    public boolean visit(SimpleName node) {
                        String dottedName = "." + node.getFullyQualifiedName();
                        boolean found = false;
                        for (String nextFullTypeName : fieldList) {
                            if (!nextFullTypeName.endsWith(dottedName)) continue;
                            found = true;
                            break;
                        }
                        OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected simple type found " + node.getFullyQualifiedName()), (boolean)found);
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
    }

    public void testQualifiedConstantsInMethodCalls() throws Exception {
        String testClassName = "QualifiedConstantsInMethodCalls";
        final ArrayList typeNameRefs = new ArrayList(Arrays.asList("javax.dummy.Castings", "javax.dummy.Classes", "javax.dummy.Constants", "javax.dummy.Methods"));
        StringBuffer buf = new StringBuffer();
        buf.append("public class ").append(testClassName).append(" {").append(nl);
        buf.append(nl);
        buf.append("    private static int method1(Object[] values) {").append(nl);
        buf.append("        return method2(").append((String)typeNameRefs.get(2)).append(".CONSTANT,").append(nl);
        buf.append("               ").append("(").append((String)typeNameRefs.get(0)).append(") casting,").append(nl);
        buf.append("               ").append((String)typeNameRefs.get(1)).append(".class,").append(nl);
        buf.append("               values.length,").append(nl);
        buf.append("               local.fVar1.fVar2.length,").append(nl);
        buf.append("               localV.fVar1.fVar2.length,").append(nl);
        buf.append("               not.to.replace.pack1.A,").append(nl);
        buf.append("               (not.to.replace.pack2.B) b,").append(nl);
        buf.append("               ").append((String)typeNameRefs.get(3)).append(".method());").append(nl);
        buf.append("    }").append(nl);
        buf.append(nl);
        buf.append("}").append(nl);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(testClassName) + ".java", buf.toString());
        new OrganizeImportsPostprocessor().organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertEquals((String)("Failed to generate enough import statements: " + imports), (int)typeNameRefs.size(), (int)imports.size());
        int i = 0;
        while (i < imports.size()) {
            String nextImport = ((ImportDeclaration)imports.get(i)).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertEquals((String)"Unexpected import found", (String)((String)typeNameRefs.get(i)), (String)nextImport);
            ++i;
        }
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(typeNameRefs){

                    public boolean visit(QualifiedName node) {
                        OrganizeImportsPostprocessorTest.assertFalse((String)"Unexpected full-qualified name found!", (boolean)node.getFullyQualifiedName().startsWith("javax.dummy"));
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
    }

    public void _testQualifiedGenerics() throws Exception {
        String testClassName = "QualifiedGenerics";
        ArrayList collectionTypeNameRefs = new ArrayList(Arrays.asList("java.util.ArrayList", "java.util.Collection"));
        ArrayList genericTypeNameRefs = new ArrayList(Arrays.asList("javax.dummy.Castings", "javax.dummy.Classes", "javax.dummy.Constants", "javax.dummy.Methods"));
        StringBuffer buf = new StringBuffer();
        buf.append("public class ").append(testClassName).append(" {").append(nl);
        buf.append(nl);
        int i = 0;
        while (i < genericTypeNameRefs.size()) {
            buf.append("    private static ").append((String)collectionTypeNameRefs.get(0)).append("<").append((String)genericTypeNameRefs.get(i)).append("> myField").append(i).append(";").append(nl);
            buf.append("    private static ").append((String)collectionTypeNameRefs.get(1)).append(" < ").append((String)genericTypeNameRefs.get(i)).append(" > otherField").append(i).append(";").append(nl);
            ++i;
        }
        buf.append("    private static Map<Class1, Class2> unqualified;").append(nl);
        buf.append(nl);
        i = 0;
        while (i < genericTypeNameRefs.size()) {
            buf.append("    private static int method").append(i).append("(").append((String)collectionTypeNameRefs.get(1)).append("<? extends ").append((String)genericTypeNameRefs.get(0)).append("> values) {").append(nl);
            buf.append("        return method(new ").append((String)collectionTypeNameRefs.get(0)).append("<").append((String)genericTypeNameRefs.get(i)).append(">());").append(nl);
            buf.append("    }").append(nl);
            buf.append(nl);
            buf.append("    private static int method").append(i).append("(").append((String)collectionTypeNameRefs.get(1)).append(" < ? extends ").append((String)genericTypeNameRefs.get(0)).append(" > values ) {").append(nl);
            buf.append("        return method( new  ").append((String)collectionTypeNameRefs.get(0)).append(" < ").append((String)genericTypeNameRefs.get(i)).append(" > () );").append(nl);
            buf.append("    }").append(nl);
            buf.append(nl);
            ++i;
        }
        buf.append("}").append(nl);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(testClassName) + ".java", buf.toString());
        new OrganizeImportsPostprocessor().organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertEquals((String)("Failed to generate enough import statements: " + imports), (int)(genericTypeNameRefs.size() + collectionTypeNameRefs.size()), (int)imports.size());
        int i2 = 0;
        while (i2 < imports.size()) {
            String nextImport = ((ImportDeclaration)imports.get(i2)).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertTrue((String)"Unexpected import found", (genericTypeNameRefs.contains(nextImport) || collectionTypeNameRefs.contains(nextImport) ? 1 : 0) != 0);
            ++i2;
        }
        ArrayList allReferencedTypes = new ArrayList(genericTypeNameRefs.size() + collectionTypeNameRefs.size());
        allReferencedTypes.addAll(genericTypeNameRefs);
        allReferencedTypes.addAll(collectionTypeNameRefs);
        cu.accept((ASTVisitor)new ExpectedSimpleNamesVisitor(allReferencedTypes){

            public boolean visit(ImportDeclaration node) {
                return false;
            }
        });
    }

    public void testFullQualifiedArrays() throws Exception {
        String testClassName = "FullQualifiedArrays";
        List<Class> typeRefs = Arrays.asList(ArrayList.class, List.class, Map.class, Map.Entry.class);
        final String[] conflictedTypeNames = new String[]{"javax.some.Map"};
        final ArrayList<String> typeNameRefs = new ArrayList<String>(typeRefs.size() + conflictedTypeNames.length);
        for (Class next : typeRefs) {
            typeNameRefs.add(this.getInnerClassAwareName(next));
        }
        String localVariable = String.valueOf((String)typeNameRefs.get(2)) + ".SMTH.ourEntries";
        typeNameRefs.add(localVariable);
        typeNameRefs.addAll((Collection)Arrays.asList(conflictedTypeNames));
        StringBuffer buf = new StringBuffer();
        buf.append("import ").append((String)typeNameRefs.get(0)).append(";").append(nl);
        buf.append(nl);
        buf.append("public class ").append(testClassName).append(" {").append(nl);
        buf.append(nl);
        buf.append("    private ").append((String)typeNameRefs.get(1)).append("[] list;").append(nl);
        buf.append("    private ").append((String)typeNameRefs.get(2)).append("[] entry = new ").append((String)typeNameRefs.get(4)).append("[0];").append(nl);
        buf.append("    private ").append((String)typeNameRefs.get(3)).append("[] maps;").append(nl);
        buf.append("    private ").append(typeRefs.get(0).getSimpleName()).append("[] arrayLists;").append(nl);
        buf.append("    private ").append((String)typeNameRefs.get(5)).append(" conflictEntry;").append(nl);
        buf.append("    private int style = setLineStyle(").append(localVariable).append(".LINE_DASH);");
        buf.append(nl);
        buf.append("    private static int setLineStyle(int style) {");
        buf.append("        return 0;");
        buf.append("    }");
        buf.append(nl);
        buf.append("}").append(nl);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(testClassName) + ".java", buf.toString());
        new OrganizeImportsPostprocessor().organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertEquals((String)("Failed to generate enough import statements: " + imports), (int)typeRefs.size(), (int)imports.size());
        int i = 0;
        while (i < imports.size()) {
            String nextImport = ((ImportDeclaration)imports.get(i)).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertEquals((String)"Unexpected import found", (String)((String)typeNameRefs.get(i)), (String)nextImport);
            ++i;
        }
        cu.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                node.getType().accept((ASTVisitor)new ExpectedSimpleNamesVisitor(typeNameRefs){

                    public boolean visit(QualifiedName node) {
                        OrganizeImportsPostprocessorTest.assertEquals((String)"Unexpected full-qualified name found!", (String)conflictedTypeNames[0], (String)node.getFullyQualifiedName());
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to leave unqualified only 1 reference", (int)conflictedTypeNames.length, (int)(typeNameRefs.size() - 1));
    }

    private String getInnerClassAwareName(Class<?> clazz) {
        return clazz.getName();
    }

    public void testCodeFormattingInSomeRealPieceOfCode() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append(nl);
        buf.append("import java.util.ArrayList;").append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append("import org.eclipse.gmf.runtime.common.ui.resources.IMarker;").append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append("public class SomeRealPieceOfCode {").append(nl);
        buf.append(nl);
        buf.append("    private      java.util.List     list;").append(nl);
        buf.append(nl);
        buf.append("    private java.util.Map.Entry[] entries;").append(nl);
        buf.append("    private java.util.Map map;").append(nl);
        buf.append("    private ArrayList arrayList;").append(nl);
        buf.append(nl);
        buf.append("    private void createContents() {").append(nl);
        buf.append("        org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig_0 = ").append(nl);
        buf.append("                new org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel();").append(nl);
        buf.append("        //some new empty line with comment").append(nl);
        buf.append("        org.eclipse.gmf.runtime.draw2d.ui.figures.NamedNodeRectangle fig_0 = new org.eclipse.gmf.runtime.draw2d.ui.figures.NamedNodeRectangle();").append(nl);
        buf.append("        Object layData0 = null;").append(nl);
        buf.append("    }").append(nl);
        buf.append(nl);
        buf.append("    public class NamedNodeRectangle extends org.eclipse.draw2d.RectangleFigure").append(nl);
        buf.append("                                    implements org.eclipse.gmf.runtime.common.ui.resources.IMarker {").append(nl);
        buf.append("    }").append(nl);
        buf.append(nl);
        buf.append("}").append(nl);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile("SomeRealPieceOfCode.java", buf.toString());
        new OrganizeImportsPostprocessor().organizeImports(icu, null);
        icu.save(null, true);
        buf = new StringBuffer();
        buf.append(nl);
        buf.append("import java.util.ArrayList;").append(nl);
        buf.append("import java.util.List;").append(nl);
        buf.append("import java.util.Map;").append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append("import org.eclipse.draw2d.RectangleFigure;").append(nl);
        buf.append("import org.eclipse.gmf.runtime.common.ui.resources.IMarker;").append(nl);
        buf.append("import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;").append(nl);
        buf.append(nl);
        buf.append(nl);
        buf.append("public class SomeRealPieceOfCode {").append(nl);
        buf.append(nl);
        buf.append("    private      List     list;").append(nl);
        buf.append(nl);
        buf.append("    private Map.Entry[] entries;").append(nl);
        buf.append("    private Map map;").append(nl);
        buf.append("    private ArrayList arrayList;").append(nl);
        buf.append(nl);
        buf.append("    private void createContents() {").append(nl);
        buf.append("        WrapLabel fig_0 = ").append(nl);
        buf.append("                new WrapLabel();").append(nl);
        buf.append("        //some new empty line with comment").append(nl);
        buf.append("        org.eclipse.gmf.runtime.draw2d.ui.figures.NamedNodeRectangle fig_0 = new org.eclipse.gmf.runtime.draw2d.ui.figures.NamedNodeRectangle();").append(nl);
        buf.append("        Object layData0 = null;").append(nl);
        buf.append("    }").append(nl);
        buf.append(nl);
        buf.append("    public class NamedNodeRectangle extends RectangleFigure").append(nl);
        buf.append("                                    implements IMarker {").append(nl);
        buf.append("    }").append(nl);
        buf.append(nl);
        buf.append("}").append(nl);
        OrganizeImportsPostprocessorTest.assertEquals((String)"Failed to organize imports", (String)buf.toString(), (String)icu.getBuffer().getContents());
    }

    public void testHardcodedTypenames() throws Exception {
        String className = "TestHardcodedTypenames";
        List<String> typeNameRefs = Arrays.asList(NLS.class.getCanonicalName(), SWT.class.getCanonicalName());
        final ArrayList simpleTypeNameRefs = new ArrayList(Arrays.asList(NLS.class.getSimpleName(), SWT.class.getSimpleName()));
        StringBuffer buf = new StringBuffer();
        buf.append("public class ").append(className).append(" {").append(nl);
        buf.append(nl);
        buf.append("    private static int setLineStyle(int style) {");
        buf.append("        style = ").append(typeNameRefs.get(1)).append(".NONE;");
        buf.append("        ").append(typeNameRefs.get(0)).append(".bind(\"NONE style has {0} code\", style);");
        buf.append("        return style;");
        buf.append("    }");
        buf.append(nl);
        buf.append("}").append(nl);
        ICompilationUnit icu = JavaProjectHelper.createJavaFile(String.valueOf(className) + ".java", buf.toString());
        new OrganizeImportsPostprocessor().organizeImports(icu, null);
        icu.save(null, true);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        OrganizeImportsPostprocessorTest.assertEquals((String)("Failed to generate enough import statements: " + imports), (int)typeNameRefs.size(), (int)imports.size());
        int i = 0;
        while (i < imports.size()) {
            String nextImport = ((ImportDeclaration)imports.get(i)).getName().getFullyQualifiedName();
            OrganizeImportsPostprocessorTest.assertEquals((String)"Unexpected import found", (String)typeNameRefs.get(i), (String)nextImport);
            ++i;
        }
        cu.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                node.getBody().accept(new ASTVisitor(){

                    public boolean visit(QualifiedName node) {
                        OrganizeImportsPostprocessorTest.assertTrue((String)"Unexpected full-qualified name found!", (boolean)simpleTypeNameRefs.remove(node.getQualifier().getFullyQualifiedName()));
                        return false;
                    }

                    public boolean visit(SimpleName node) {
                        simpleTypeNameRefs.remove(node.getFullyQualifiedName());
                        return false;
                    }
                });
                return super.visit(node);
            }
        });
        OrganizeImportsPostprocessorTest.assertTrue((String)"Failed to organize all referenced types", (boolean)simpleTypeNameRefs.isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpectedSimpleNamesVisitor
    extends ASTVisitor {
        private Collection<String> myExpectedFullNames;

        public ExpectedSimpleNamesVisitor(Collection<String> expectedFullNames) {
            this.myExpectedFullNames = expectedFullNames;
        }

        public boolean visit(QualifiedName node) {
            OrganizeImportsPostprocessorTest.fail((String)("Unexpected fully qualified field found: " + node.getFullyQualifiedName()));
            return false;
        }

        public boolean visit(SimpleName node) {
            String dottedName = "." + node.getFullyQualifiedName();
            boolean found = false;
            Iterator<String> it = this.myExpectedFullNames.iterator();
            while (it.hasNext()) {
                String nextFullTypeName = it.next();
                if (!nextFullTypeName.endsWith(dottedName)) continue;
                it.remove();
                found = true;
                break;
            }
            OrganizeImportsPostprocessorTest.assertTrue((String)("Unexpected simple type found " + node.getFullyQualifiedName()), (boolean)found);
            return false;
        }
    }

    public static class JavaProjectHelper {
        private static String myTmpProjectNamePrefix = "imports.tmp";

        public static IProject createTmpProject() throws CoreException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null) {
                IWorkspaceRoot root = workspace.getRoot();
                IProject tmp = root.getProject(myTmpProjectNamePrefix);
                if (!tmp.exists()) {
                    tmp.create(null);
                }
                if (!tmp.isOpen()) {
                    tmp.open(null);
                }
                return tmp;
            }
            return null;
        }

        public static IFile createFile(String tmpFileNamePrefix, String initialContent) throws CoreException {
            IProject project = JavaProjectHelper.createTmpProject();
            if (project != null) {
                IFile tmp = project.getFile(tmpFileNamePrefix);
                if (tmp.exists()) {
                    tmp.delete(true, null);
                }
                ByteArrayInputStream is = new ByteArrayInputStream(initialContent.getBytes());
                tmp.create((InputStream)is, true, null);
                return tmp;
            }
            return null;
        }

        public static ICompilationUnit createJavaFile(String tmpFileNamePrefix, String initialContent) throws CoreException {
            IFile file = JavaProjectHelper.createFile(tmpFileNamePrefix, initialContent);
            IProjectDescription descr = file.getProject().getDescription();
            descr.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            file.getProject().setDescription(descr, null);
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            javaProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)file.getProject().getFullPath()), JavaCore.newLibraryEntry((IPath)JavaCore.getClasspathVariable((String)"JRE_LIB"), null, null)}, null);
            return JavaCore.createCompilationUnitFrom((IFile)file);
        }
    }
}

