/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import org.eclipse.gmf.tests.TestConfiguration;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GenProjectSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.setup.ToolDefSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSetup
implements TestConfiguration {
    private DomainModelSource myDomainModel;
    private DiaGenSource myGenModel;
    private GenProjectSetup myProject;
    private MapDefSource myMapModel;
    private DiaDefSource myGraphDefModel;
    private ToolDefSource myToolDefModel;
    private int myUses;
    protected static boolean factoryClosed = false;
    private final GeneratorConfiguration myGeneratorConfig;

    protected SessionSetup(GeneratorConfiguration generatorConfig) {
        assert (generatorConfig != null);
        this.myGeneratorConfig = generatorConfig;
    }

    public static void disallowSingleTestCaseUse() {
        factoryClosed = true;
    }

    public static SessionSetup newInstance() {
        if (factoryClosed) {
            return null;
        }
        return new SessionSetup(new RuntimeBasedGeneratorConfiguration());
    }

    public DomainModelSource getDomainModel() {
        if (this.myDomainModel == null) {
            this.myDomainModel = this.createDomainModel();
        }
        return this.myDomainModel;
    }

    protected DomainModelSource createDomainModel() {
        return new DomainModelSetup().init();
    }

    public DiaGenSource getGenModel() {
        if (this.myGenModel == null) {
            this.myGenModel = this.createGenModel();
        }
        return this.myGenModel;
    }

    protected DiaGenSource createGenModel() {
        return new DiaGenSetup().init(this.getMapModel());
    }

    protected GenProjectSetup getGenProject() throws Exception {
        if (this.myProject == null) {
            this.myProject = this.createGenProject();
        }
        return this.myProject;
    }

    protected GenProjectSetup createGenProject() throws BundleException {
        return new GenProjectSetup(this.getGeneratorConfiguration()).init(this.getGenModel());
    }

    public GeneratorConfiguration getGeneratorConfiguration() {
        return this.myGeneratorConfig;
    }

    public MapDefSource getMapModel() {
        if (this.myMapModel == null) {
            this.myMapModel = this.createMapModel();
        }
        return this.myMapModel;
    }

    protected MapDefSource createMapModel() {
        return new MapSetup().init(this.getGraphDefModel(), this.getDomainModel(), this.getToolDefModel());
    }

    public DiaDefSource getGraphDefModel() {
        if (this.myGraphDefModel == null) {
            this.myGraphDefModel = this.createGraphDefModel();
        }
        return this.myGraphDefModel;
    }

    protected DiaDefSource createGraphDefModel() {
        return new DiaDefSetup().init();
    }

    public ToolDefSource getToolDefModel() {
        if (this.myToolDefModel == null) {
            this.myToolDefModel = this.createToolDefModel();
        }
        return this.myToolDefModel;
    }

    protected ToolDefSource createToolDefModel() {
        return new ToolDefSetup();
    }

    public void cleanup() throws Exception {
        System.err.println(String.valueOf(this.getClass().getName()) + ":uses:" + this.myUses);
        if (this.myProject != null) {
            this.myProject.uninstall();
        }
    }

    public final Class<?> loadGeneratedClass(String qualifiedClassName) throws Exception {
        return this.getGeneratedPlugin().loadClass(qualifiedClassName);
    }

    public final Bundle getGeneratedPlugin() throws Exception {
        return this.getGenProject().getBundle();
    }

    public void oneUp() {
        ++this.myUses;
    }

    public void oneDown() {
        --this.myUses;
    }
}

