/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;
import org.eclipse.gmf.internal.xpand.ocl.TypeHelper;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.ecore.CollectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandStatement
extends Statement {
    private final boolean isForeach;
    private final ExpressionHelper[] parameters;
    private final ExpressionHelper separator;
    private final ExpressionHelper target;
    private final String definition;

    public ExpandStatement(int start, int end, int line, PathNameCS definition, OCLExpressionCS target, OCLExpressionCS separator, OCLExpressionCS[] parameters, boolean foreach) {
        super(start, end, line);
        this.definition = TypeHelper.toString(definition);
        this.target = target == null ? null : new ExpressionHelper(target, this);
        ExpressionHelper expressionHelper = this.separator = separator == null ? null : new ExpressionHelper(separator, this);
        if (parameters == null) {
            this.parameters = new ExpressionHelper[0];
        } else {
            this.parameters = new ExpressionHelper[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                this.parameters[i] = new ExpressionHelper(parameters[i], this);
                ++i;
            }
        }
        this.isForeach = foreach;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier[] paramTypes = new EClassifier[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            paramTypes[i] = this.parameters[i].analyze(ctx, issues);
            ++i;
        }
        EClassifier targetType = null;
        if (this.isForeach) {
            targetType = this.target.analyze(ctx, issues);
            if (!(targetType instanceof CollectionType)) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Collection type expected!", this.target));
                return;
            }
            targetType = (EClassifier)((CollectionType)targetType).getElementType();
        } else {
            Variable var = ctx.getImplicitVariable();
            if (var == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "No implicite variable 'this/self' could be found!", this.target));
                return;
            }
            targetType = var.getType();
            if (this.target != null) {
                targetType = this.target.analyze(ctx, issues);
            }
        }
        if (targetType == null) return;
        if (Arrays.asList(paramTypes).contains(null)) {
            return;
        }
        try {
            XpandDefinition def = ctx.findDefinition(this.definition, targetType, paramTypes);
            if (def != null) return;
            issues.add(new AnalysationIssue(AnalysationIssue.Type.DEFINITION_NOT_FOUND, "Couldn't find definition " + this.definition + this.getParamTypeString(paramTypes) + " for type " + targetType.getName(), this));
            return;
        }
        catch (AmbiguousDefinitionException e) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.DEFINITION_NOT_FOUND, e.getMessage(), this));
        }
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        Object[] params = new Object[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            params[i] = this.parameters[i].evaluate(ctx);
            ++i;
        }
        String sep = (String)(this.separator != null ? this.separator.evaluate(ctx) : null);
        Object targetObject = null;
        XpandFacade xpandFacade = new XpandFacade(ctx);
        try {
            if (this.isForeach) {
                targetObject = this.target.evaluate(ctx);
                if (!(targetObject instanceof Collection)) {
                    throw new EvaluationException("Collection expected (was: " + targetObject.getClass().getName() + ")!", this.target);
                }
                Collection col = (Collection)targetObject;
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    xpandFacade.evaluate(this.definition, iter.next(), params);
                    if (sep == null || !iter.hasNext()) continue;
                    ctx.getScope().getOutput().write(sep);
                }
            } else {
                if (this.target != null) {
                    targetObject = this.target.evaluate(ctx);
                } else {
                    Variable var = ctx.getImplicitVariable();
                    targetObject = var.getValue();
                }
                if (targetObject != null) {
                    xpandFacade.evaluate(this.definition, targetObject, params);
                }
            }
        }
        catch (AmbiguousDefinitionException e) {
            throw new EvaluationException(e.getMessage(), this);
        }
    }

    private String getParamTypeString(EClassifier[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            EClassifier type = paramTypes[i];
            buff.append(type.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(", ");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    private String getParamString() {
        if (this.parameters.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < this.parameters.length) {
            buff.append(this.parameters[i]);
            if (i + 1 < this.parameters.length) {
                buff.append(", ");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    public String toString() {
        return "EXPAND " + this.definition + this.getParamString() + (this.target != null ? String.valueOf(this.isForeach ? " FOREACH " : " FOR ") + this.target : "") + (this.separator != null ? " SEPARATOR " + this.separator : "");
    }

    ExpressionHelper getTarget() {
        return this.target;
    }

    ExpressionHelper getSeparator() {
        return this.separator;
    }

    ExpressionHelper[] getParameters() {
        return this.parameters;
    }
}

