/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.expressions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;

public abstract class EcoreAbstractExpression {
    private static final boolean DISABLED_NO_IMPL_EXCEPTION_LOG = Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(EcoreDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/disableNoExprImplExceptionLog")));
    private String body;
    private EClassifier context;
    private IStatus status = Status.OK_STATUS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    protected EcoreAbstractExpression(EClassifier context) {
        this.context = context;
    }

    protected EcoreAbstractExpression(String body, EClassifier context, Map env) {
        this.body = body;
        this.context = context;
    }

    protected void setStatus(int severity, String message, Throwable throwable) {
        String pluginID = "org.eclipse.gmf.ecore.editor";
        this.status = new Status(severity, pluginID, -1, message != null ? message : "", throwable);
        if (!this.status.isOK()) {
            EcoreDiagramEditorPlugin.getInstance().logError("Expression problem:" + message + "body:" + this.body, throwable);
        }
    }

    protected abstract Object doEvaluate(Object var1, Map var2);

    public Object evaluate(Object context) {
        return this.evaluate(context, Collections.EMPTY_MAP);
    }

    public Object evaluate(Object context, Map env) {
        if (this.context().isInstance(context)) {
            try {
                return this.doEvaluate(context, env);
            }
            catch (Exception e) {
                if (DISABLED_NO_IMPL_EXCEPTION_LOG && e instanceof NoImplException) {
                    return null;
                }
                EcoreDiagramEditorPlugin.getInstance().logError("Expression evaluation failure: " + this.body, e);
            }
        }
        return null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String body() {
        return this.body;
    }

    public EClassifier context() {
        return this.context;
    }

    public void assignTo(EStructuralFeature feature, EObject target) {
        Object value = this.evaluate(target);
        Object object = value = value != null ? this.performCast(value, (ETypedElement)feature) : null;
        if (feature.isMany()) {
            Collection destCollection = (Collection)target.eGet(feature);
            destCollection.clear();
            if (value instanceof Collection) {
                Collection valueCollection = (Collection)value;
                Iterator it = valueCollection.iterator();
                while (it.hasNext()) {
                    destCollection.add(this.performCast(it.next(), (ETypedElement)feature));
                }
            } else {
                destCollection.add(value);
            }
            return;
        }
        target.eSet(feature, value);
    }

    protected Object performCast(Object value, ETypedElement targetType) {
        if (targetType.getEType() == null || targetType.getEType().getInstanceClass() == null) {
            return value;
        }
        Class targetClass = targetType.getEType().getInstanceClass();
        if (value != null && value instanceof Number) {
            Number num = (Number)value;
            Class<?> valClass = value.getClass();
            Class targetWrapperClass = targetClass;
            if (targetClass.isPrimitive()) {
                targetWrapperClass = EcoreUtil.wrapperClassFor((Class)targetClass);
            }
            if (valClass.equals(targetWrapperClass)) {
                return value;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(targetWrapperClass)) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz2)) {
                    return new Byte(num.byteValue());
                }
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz3)) {
                    return new Integer(num.intValue());
                }
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz4)) {
                    return new Short(num.shortValue());
                }
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz5)) {
                    return new Long(num.longValue());
                }
                Class<?> clazz6 = class$5;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$5 = Class.forName("java.math.BigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz6)) {
                    return BigInteger.valueOf(num.longValue());
                }
                Class<?> clazz7 = class$6;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$6 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz7)) {
                    return new Float(num.floatValue());
                }
                Class<?> clazz8 = class$7;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$7 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz8)) {
                    return new Double(num.doubleValue());
                }
                Class<?> clazz9 = class$8;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$8 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (targetWrapperClass.equals(clazz9)) {
                    return new BigDecimal(num.doubleValue());
                }
            }
        }
        return value;
    }

    public static final EcoreAbstractExpression createNullExpression(EClassifier context) {
        return new EcoreAbstractExpression(context){

            protected Object doEvaluate(Object context, Map env) {
                return null;
            }
        };
    }

    public static class NoImplException
    extends RuntimeException {
        public NoImplException(String message) {
            super(message);
        }
    }
}

