/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Shell;

public final class LayoutService
extends Service
implements ILayoutNodeProvider {
    private static final LayoutService instance = new LayoutService();

    private LayoutService() {
        this.configureProviders(DiagramUIPlugin.getPluginId(), "layoutProviders");
    }

    public static LayoutService getInstance() {
        return instance;
    }

    private Object execute(LayoutNodesOperation operation) {
        List results = this.execute(ExecutionStrategy.FIRST, operation);
        return results.isEmpty() ? null : results.get(0);
    }

    public ILayoutNode getLayoutNode(Node node) {
        if (node == null) {
            throw new NullPointerException("Argument 'node' is null");
        }
        Shell shell = new Shell();
        try {
            Diagram diagram = node.getDiagram();
            DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
            Map registry = diagramEP.getViewer().getEditPartRegistry();
            GraphicalEditPart gep = (GraphicalEditPart)registry.get(node);
            Dimension size = gep.getFigure().getBounds().getSize();
            LayoutNode layoutNode = new LayoutNode(node, size.width, size.height);
            return layoutNode;
        }
        finally {
            shell.dispose();
        }
    }

    private void checkValidLayoutNodes(List nodes) {
        if (nodes == null) {
            throw new NullPointerException("Argument 'nodes' is null");
        }
        if (nodes.size() == 0) {
            throw new IllegalArgumentException("Argument 'nodes' is empty");
        }
        ListIterator li = nodes.listIterator();
        View parent = null;
        while (li.hasNext()) {
            Object next = li.next();
            if (!(next instanceof ILayoutNode)) {
                throw new IllegalArgumentException("Argument 'nodes' contains objects which aren't of type 'ILayoutNode'");
            }
            ILayoutNode node = (ILayoutNode)next;
            if (parent == null) {
                parent = ViewUtil.getContainerView((View)node.getNode());
                continue;
            }
            if (ViewUtil.getContainerView((View)node.getNode()) == parent) continue;
            throw new IllegalArgumentException("Argument 'nodes' contains objects which have a different parent containment");
        }
    }

    private void checkValidNodes(List nodes) {
        if (nodes == null) {
            throw new NullPointerException("Argument 'nodes' is null");
        }
        if (nodes.size() == 0) {
            throw new IllegalArgumentException("Argument 'nodes' is empty");
        }
        ListIterator li = nodes.listIterator();
        View parent = null;
        while (li.hasNext()) {
            Object next = li.next();
            if (!(next instanceof Node)) {
                throw new IllegalArgumentException("Argument 'nodes' contains objects which aren't of type 'Node'");
            }
            Node node = (Node)next;
            if (parent == null) {
                parent = ViewUtil.getContainerView((View)node);
                continue;
            }
            if (ViewUtil.getContainerView((View)node) == parent) continue;
            throw new IllegalArgumentException("Argument 'nodes' contains objects which have a different parent containment");
        }
    }

    public List getLayoutNodes(DiagramEditPart diagramEP, List nodes) {
        this.checkValidNodes(nodes);
        Shell shell = null;
        try {
            if (diagramEP == null) {
                shell = new Shell();
                Diagram diagram = ((Node)nodes.get(0)).getDiagram();
                diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
            }
            Map registry = diagramEP.getViewer().getEditPartRegistry();
            ArrayList<LayoutNode> layoutNodes = new ArrayList<LayoutNode>(nodes.size());
            ListIterator li = nodes.listIterator();
            while (li.hasNext()) {
                Node node = (Node)li.next();
                GraphicalEditPart gep = (GraphicalEditPart)registry.get(node);
                Dimension size = gep.getFigure().getBounds().getSize();
                layoutNodes.add(new LayoutNode(node, size.width, size.height));
            }
            ArrayList<LayoutNode> arrayList = layoutNodes;
            return arrayList;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    public void layout(View container, String hint) {
        if (container == null) {
            throw new NullPointerException("Argument 'view' is null");
        }
        if (hint == null) {
            throw new NullPointerException("Argument 'hint' is null");
        }
        Shell shell = new Shell();
        try {
            Diagram diagram = container.getDiagram();
            DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
            ArrayList<Object> hints = new ArrayList<Object>(2);
            hints.add(hint);
            hints.add(diagramEP);
            ObjectAdapter layoutHint = new ObjectAdapter(hints);
            Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(this.getLayoutNodes(diagramEP, (List)container.getChildren()), false, (IAdaptable)layoutHint);
            layoutRun.run();
        }
        finally {
            shell.dispose();
        }
    }

    public void layoutNodes(List nodes, boolean offsetFromBoundingBox, String hint) {
        this.checkValidNodes(nodes);
        if (hint == null) {
            throw new NullPointerException("Argument 'hint' is null");
        }
        Shell shell = new Shell();
        try {
            Node nodeFirst = (Node)nodes.get(0);
            Diagram diagram = nodeFirst.getDiagram();
            DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
            ArrayList<Object> hints = new ArrayList<Object>(2);
            hints.add(hint);
            hints.add(diagramEP);
            ObjectAdapter layoutHint = new ObjectAdapter(hints);
            Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(this.getLayoutNodes(diagramEP, nodes), true, (IAdaptable)layoutHint);
            layoutRun.run();
        }
        finally {
            shell.dispose();
        }
    }

    public Runnable layoutLayoutNodes(List layoutNodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        if (layoutHint == null) {
            throw new NullPointerException("Argument 'layoutHint' is null");
        }
        this.checkValidLayoutNodes(layoutNodes);
        Assert.isNotNull((Object)layoutNodes);
        Assert.isNotNull((Object)layoutHint);
        return (Runnable)this.execute(new LayoutNodesOperation(layoutNodes, offsetFromBoundingBox, layoutHint));
    }
}

