/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.annotated;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASetup {
    private static boolean SAVE_GENERATED_MODELS = true;

    protected void saveModel(EObject root, String fileExtension) {
        assert (fileExtension != null);
        if (!SAVE_GENERATED_MODELS) {
            return;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        String fileFolder = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String fileName = "gen" + System.currentTimeMillis() + '.' + fileExtension;
        Resource r = rs.createResource(URI.createFileURI((String)(String.valueOf(fileFolder) + '/' + fileName)), "");
        r.getContents().add((Object)root);
        try {
            r.save(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void validate(EObject obj) {
        Assert.assertNotNull((Object)obj);
        Diagnostic diag = Diagnostician.INSTANCE.validate(obj);
        Assert.assertTrue((String)diag.toString(), (diag.getSeverity() == 0 ? 1 : 0) != 0);
    }

    protected String getName(EModelElement element, String name) {
        if (name != null) {
            return name;
        }
        assert (element instanceof ENamedElement) : "Name should be specified for unnamed domain element: " + element;
        return ((ENamedElement)element).getName();
    }

    protected abstract Iterator<EObject> getAllDomainModelContents();

    protected void processDomainModel() {
        Iterator<EObject> contents = this.getAllDomainModelContents();
        while (contents.hasNext()) {
            EObject next = contents.next();
            if (!(next instanceof EModelElement)) continue;
            EModelElement element = (EModelElement)next;
            List<Parameter> params = this.getParameters(element);
            for (Parameter param : params) {
                if ("canvas".equals(param.name)) {
                    this.processCanvas(element, param.value, params);
                    continue;
                }
                if ("node".equals(param.name)) {
                    this.processNode(element, param.value, params);
                    continue;
                }
                if ("compartment".equals(param.name)) {
                    this.processCompartment(element, param.value, params);
                    continue;
                }
                if ("link".equals(param.name)) {
                    this.processLink(element, param.value, params);
                    continue;
                }
                if (!"label".equals(param.name)) continue;
                this.processLabel(element, param.value, params);
            }
        }
    }

    protected void processCanvas(EModelElement element, String name, List<Parameter> params) {
    }

    protected void processNode(EModelElement element, String name, List<Parameter> params) {
    }

    protected void processCompartment(EModelElement element, String name, List<Parameter> params) {
    }

    protected void processLink(EModelElement element, String name, List<Parameter> params) {
    }

    protected void processLabel(EModelElement element, String name, List<Parameter> params) {
    }

    protected EReference findReference(EClass type, String aDetailsName) {
        for (EReference ref : type.getEReferences()) {
            List<Parameter> params = this.getParameters((EModelElement)ref);
            for (Parameter param : params) {
                if (!aDetailsName.equals(param.name)) continue;
                return ref;
            }
        }
        return null;
    }

    protected EReference findReferenceByQName(EPackage ePackage, List<Parameter> params, String name) {
        String qName = null;
        for (Parameter param : params) {
            if (!name.equals(param.name)) continue;
            qName = param.value;
            break;
        }
        if (qName == null) {
            return null;
        }
        int dotix = qName.indexOf(46);
        assert (dotix > 0 && dotix < qName.length() - 1);
        String className = qName.substring(0, dotix);
        String refName = qName.substring(dotix + 1);
        EClass type = (EClass)ePackage.getEClassifier(className);
        return (EReference)type.getEStructuralFeature(refName);
    }

    protected List<Parameter> getParameters(EModelElement element) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (EAnnotation annotation : element.getEAnnotations()) {
            if (!"gmf".equals(annotation.getSource())) continue;
            for (Map.Entry entry : annotation.getDetails()) {
                params.add(new Parameter((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return params;
    }

    protected static class Parameter {
        public String name;
        public String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

