/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.sheet;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.Shape;
import org.eclipse.gmf.graphdef.editor.sheet.AttachAdapter;
import org.eclipse.gmf.graphdef.editor.sheet.ChangeTracker;
import org.eclipse.gmf.graphdef.editor.sheet.FeatureTracker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FigureSection
extends AbstractPropertySection
implements ChangeTracker,
Listener {
    private Adapter[] myModelListeners;
    private boolean myIsCommit;
    private boolean myIsRefresh;
    private Object myInput;
    private Group myStyleRadios;
    private Group myCommonStyle;
    private Group myRoundedRectStyle;
    private Group myForegroundColor;
    private Group myBackgroundColor;
    private Group myFont;
    private Button myR1;
    private Button myR2;
    private Button myR3;
    private Button myR4;
    private Button myR5;
    private Button myR6;
    private Spinner myLineWidth;
    private Button myFill;
    private Button myOutline;
    private Button myFillXor;
    private Button myOutlineXor;
    private Spinner myCornerWidth;
    private Spinner myCornerHeight;
    private Button myForegroundRgbRadio;
    private Button myForegroundPredeinedRadio;
    private Button myForegroundNoValueRadio;
    private Group myForegroundRGBValues;
    private Group myForegroundPredefinedValue;
    private Button myBackgroundRgbRadio;
    private Button myBackgroundPredeinedRadio;
    private Button myBackgroundNoRadio;
    private Group myBackgroundRGBValues;
    private Group myBackgroundPredefinedValue;
    private Button myFontSetFont;
    private Text myFontFaceName;
    private Spinner myFontHeight;
    private Combo myFontStyle;
    private Spinner myForegroundRed;
    private Spinner myForegroundGreen;
    private Spinner myForegroundBlue;
    private Combo myForegroundPredefinedColor;
    private Spinner myBackgroundRed;
    private Spinner myBackgroundGreen;
    private Spinner myBackgroundBlue;
    private Combo myBackgroundPredefinedColor;

    public void createControls(Composite parent, TabbedPropertySheetPage page) {
        super.createControls(parent, page);
        this.getWidgetFactory().paintBordersFor(parent);
        this.myStyleRadios = this.createGroup(parent, "Line Style");
        this.myR1 = this.getWidgetFactory().createButton((Composite)this.myStyleRadios, "Solid", 16);
        this.myR2 = this.getWidgetFactory().createButton((Composite)this.myStyleRadios, "- - -", 16);
        this.myR3 = this.getWidgetFactory().createButton((Composite)this.myStyleRadios, ". . .", 16);
        this.myR4 = this.getWidgetFactory().createButton((Composite)this.myStyleRadios, "- . - .", 16);
        this.myR5 = this.getWidgetFactory().createButton((Composite)this.myStyleRadios, "- . . - . .", 16);
        this.myR6 = this.getWidgetFactory().createButton((Composite)this.myStyleRadios, "Custom", 16);
        this.myStyleRadios.setLayout((Layout)new FillLayout(512));
        this.myCommonStyle = this.createGroup(parent, "Draw");
        this.createLabel((Composite)this.myCommonStyle, "Line width");
        this.myLineWidth = new Spinner((Composite)this.myCommonStyle, 0x800000);
        this.myLineWidth.setMinimum(0);
        this.myLineWidth.setMaximum(100);
        this.myLineWidth.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.myFill = this.getWidgetFactory().createButton((Composite)this.myCommonStyle, "Fill", 32);
        this.myOutline = this.getWidgetFactory().createButton((Composite)this.myCommonStyle, "Outline", 32);
        this.myFillXor = this.getWidgetFactory().createButton((Composite)this.myCommonStyle, "XOR Fill", 32);
        this.myOutlineXor = this.getWidgetFactory().createButton((Composite)this.myCommonStyle, "XOR Outline", 32);
        this.myCommonStyle.setLayout((Layout)new GridLayout(2, true));
        this.myRoundedRectStyle = this.createGroup(parent, "Corners");
        this.createLabel((Composite)this.myRoundedRectStyle, "Width:");
        this.myCornerWidth = new Spinner((Composite)this.myRoundedRectStyle, 0x800000);
        this.myCornerWidth.setMinimum(0);
        this.myCornerWidth.setMaximum(100);
        this.myCornerWidth.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.createLabel((Composite)this.myRoundedRectStyle, "Height:");
        this.myCornerHeight = new Spinner((Composite)this.myRoundedRectStyle, 0x800000);
        this.myCornerHeight.setMinimum(0);
        this.myCornerHeight.setMaximum(100);
        this.myCornerHeight.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.myRoundedRectStyle.setLayout((Layout)new GridLayout(2, true));
        this.myForegroundColor = this.createGroup(parent, "Foreground Color");
        this.myForegroundRgbRadio = this.getWidgetFactory().createButton((Composite)this.myForegroundColor, "RGB", 16);
        this.myForegroundPredeinedRadio = this.getWidgetFactory().createButton((Composite)this.myForegroundColor, "Predefined", 16);
        this.myForegroundNoValueRadio = this.getWidgetFactory().createButton((Composite)this.myForegroundColor, "None", 16);
        this.myForegroundRGBValues = this.createGroup((Composite)this.myForegroundColor, "RGB Values");
        this.createLabel((Composite)this.myForegroundRGBValues, "Red");
        this.myForegroundRed = new Spinner((Composite)this.myForegroundRGBValues, 0x800000);
        this.myForegroundRed.setMinimum(0);
        this.myForegroundRed.setMaximum(255);
        this.myForegroundRed.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.createLabel((Composite)this.myForegroundRGBValues, "Green");
        this.myForegroundGreen = new Spinner((Composite)this.myForegroundRGBValues, 0x800000);
        this.myForegroundGreen.setMinimum(0);
        this.myForegroundGreen.setMaximum(255);
        this.myForegroundGreen.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.createLabel((Composite)this.myForegroundRGBValues, "Blue");
        this.myForegroundBlue = new Spinner((Composite)this.myForegroundRGBValues, 0x800000);
        this.myForegroundBlue.setMinimum(0);
        this.myForegroundBlue.setMaximum(255);
        this.myForegroundBlue.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.myForegroundRGBValues.setLayout((Layout)new GridLayout(2, false));
        this.myForegroundPredefinedValue = this.createGroup((Composite)this.myForegroundColor, "Predefined Colors");
        this.myForegroundPredefinedColor = new Combo((Composite)this.myForegroundPredefinedValue, 0x800008);
        this.myForegroundPredefinedColor.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.getWidgetFactory().adapt((Control)this.myForegroundPredefinedColor, false, false);
        this.myForegroundPredefinedValue.setLayout((Layout)new GridLayout(1, false));
        this.myForegroundColor.setLayout((Layout)new FormLayout());
        FormData myForegroundColorFD = new FormData();
        this.myForegroundRgbRadio.setLayoutData((Object)myForegroundColorFD);
        myForegroundColorFD = new FormData();
        myForegroundColorFD.top = new FormAttachment((Control)this.myForegroundRgbRadio, 5, 1024);
        this.myForegroundPredeinedRadio.setLayoutData((Object)myForegroundColorFD);
        myForegroundColorFD = new FormData();
        myForegroundColorFD.top = new FormAttachment((Control)this.myForegroundPredeinedRadio, 5, 1024);
        this.myForegroundNoValueRadio.setLayoutData((Object)myForegroundColorFD);
        myForegroundColorFD = new FormData();
        myForegroundColorFD.left = new FormAttachment((Control)this.myForegroundPredeinedRadio, 10, 131072);
        this.myForegroundRGBValues.setLayoutData((Object)myForegroundColorFD);
        myForegroundColorFD = new FormData();
        myForegroundColorFD.left = new FormAttachment((Control)this.myForegroundPredeinedRadio, 10, 131072);
        this.myForegroundPredefinedValue.setLayoutData((Object)myForegroundColorFD);
        this.myBackgroundColor = this.createGroup(parent, "Background Color");
        this.myBackgroundRgbRadio = this.getWidgetFactory().createButton((Composite)this.myBackgroundColor, "RGB", 16);
        this.myBackgroundPredeinedRadio = this.getWidgetFactory().createButton((Composite)this.myBackgroundColor, "Predefined", 16);
        this.myBackgroundNoRadio = this.getWidgetFactory().createButton((Composite)this.myBackgroundColor, "None", 16);
        this.myBackgroundRGBValues = this.createGroup((Composite)this.myBackgroundColor, "RGB Values");
        this.createLabel((Composite)this.myBackgroundRGBValues, "Red");
        this.myBackgroundRed = new Spinner((Composite)this.myBackgroundRGBValues, 0x800000);
        this.myBackgroundRed.setMinimum(0);
        this.myBackgroundRed.setMaximum(255);
        this.myBackgroundRed.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.createLabel((Composite)this.myBackgroundRGBValues, "Green");
        this.myBackgroundGreen = new Spinner((Composite)this.myBackgroundRGBValues, 0x800000);
        this.myBackgroundGreen.setMinimum(0);
        this.myBackgroundGreen.setMaximum(255);
        this.myBackgroundGreen.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.createLabel((Composite)this.myBackgroundRGBValues, "Blue");
        this.myBackgroundBlue = new Spinner((Composite)this.myBackgroundRGBValues, 0x800000);
        this.myBackgroundBlue.setMinimum(0);
        this.myBackgroundBlue.setMaximum(255);
        this.myBackgroundBlue.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.myBackgroundRGBValues.setLayout((Layout)new GridLayout(2, false));
        this.myBackgroundPredefinedValue = this.createGroup((Composite)this.myBackgroundColor, "Predefined Colors");
        this.myBackgroundPredefinedColor = new Combo((Composite)this.myBackgroundPredefinedValue, 0x800008);
        this.myBackgroundPredefinedColor.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.getWidgetFactory().adapt((Control)this.myBackgroundPredefinedColor, false, false);
        this.myBackgroundPredefinedValue.setLayout((Layout)new GridLayout(1, false));
        this.myBackgroundColor.setLayout((Layout)new FormLayout());
        FormData myBackgroundColorFD = new FormData();
        this.myBackgroundRgbRadio.setLayoutData((Object)myBackgroundColorFD);
        myBackgroundColorFD = new FormData();
        myBackgroundColorFD.top = new FormAttachment((Control)this.myBackgroundRgbRadio, 5, 1024);
        this.myBackgroundPredeinedRadio.setLayoutData((Object)myBackgroundColorFD);
        myBackgroundColorFD = new FormData();
        myBackgroundColorFD.top = new FormAttachment((Control)this.myBackgroundPredeinedRadio, 5, 1024);
        this.myBackgroundNoRadio.setLayoutData((Object)myBackgroundColorFD);
        myBackgroundColorFD = new FormData();
        myBackgroundColorFD.left = new FormAttachment((Control)this.myBackgroundPredeinedRadio, 10, 131072);
        this.myBackgroundRGBValues.setLayoutData((Object)myBackgroundColorFD);
        myBackgroundColorFD = new FormData();
        myBackgroundColorFD.left = new FormAttachment((Control)this.myBackgroundPredeinedRadio, 10, 131072);
        this.myBackgroundPredefinedValue.setLayoutData((Object)myBackgroundColorFD);
        this.myFont = this.createGroup(parent, "Font");
        this.myFontSetFont = this.getWidgetFactory().createButton((Composite)this.myFont, "Set Font", 32);
        this.createLabel((Composite)this.myFont, "Face Name");
        this.myFontFaceName = this.getWidgetFactory().createText((Composite)this.myFont, null);
        this.createLabel((Composite)this.myFont, "Height");
        this.myFontHeight = new Spinner((Composite)this.myFont, 0x800000);
        this.myFontHeight.setMinimum(0);
        this.myFontHeight.setMaximum(Integer.MAX_VALUE);
        this.myFontHeight.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.createLabel((Composite)this.myFont, "Style");
        this.myFontStyle = new Combo((Composite)this.myFont, 0x800008);
        this.myFontStyle.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.getWidgetFactory().adapt((Control)this.myFontStyle, false, false);
        this.myFont.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.swtDefaults().align(1, 1).span(2, 1).applyTo((Control)this.myFontSetFont);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.myFontFaceName);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.myFontHeight);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.myFontStyle);
        parent.setLayout((Layout)new FormLayout());
        FormData parentFD = new FormData();
        parentFD.left = new FormAttachment(0, 10);
        this.myStyleRadios.setLayoutData((Object)parentFD);
        parentFD = new FormData();
        parentFD.left = new FormAttachment((Control)this.myStyleRadios, 10, 131072);
        this.myCommonStyle.setLayoutData((Object)parentFD);
        parentFD = new FormData();
        parentFD.left = new FormAttachment((Control)this.myStyleRadios, 10, 131072);
        parentFD.top = new FormAttachment((Control)this.myCommonStyle, 5, 1024);
        this.myRoundedRectStyle.setLayoutData((Object)parentFD);
        parentFD = new FormData();
        parentFD.left = new FormAttachment((Control)this.myCommonStyle, 10, 131072);
        this.myForegroundColor.setLayoutData((Object)parentFD);
        parentFD = new FormData();
        parentFD.left = new FormAttachment((Control)this.myCommonStyle, 10, 131072);
        parentFD.top = new FormAttachment((Control)this.myForegroundColor, 5, 1024);
        this.myBackgroundColor.setLayoutData((Object)parentFD);
        parentFD = new FormData();
        parentFD.left = new FormAttachment((Control)this.myForegroundColor, 10, 131072);
        this.myFont.setLayoutData((Object)parentFD);
        for (Enumerator e : FontStyle.VALUES) {
            this.myFontStyle.add(e.getName());
        }
        for (Enumerator e : ColorConstants.VALUES) {
            this.myForegroundPredefinedColor.add(e.getName());
        }
        for (Enumerator e : ColorConstants.VALUES) {
            this.myBackgroundPredefinedColor.add(e.getName());
        }
        Text[] textArray = new Text[]{this.myFontFaceName};
        int n = textArray.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.addListener(24, (Listener)this);
            t.addListener(16, (Listener)this);
            t.addListener(1, (Listener)this);
            ++n2;
        }
        textArray = new Spinner[]{this.myLineWidth, this.myCornerWidth, this.myCornerHeight, this.myFontHeight, this.myForegroundRed, this.myForegroundGreen, this.myForegroundBlue, this.myBackgroundRed, this.myBackgroundGreen, this.myBackgroundBlue};
        n = textArray.length;
        n2 = 0;
        while (n2 < n) {
            Text s = textArray[n2];
            s.addListener(24, (Listener)this);
            s.addListener(16, (Listener)this);
            ++n2;
        }
        textArray = new Widget[]{this.myR1, this.myR2, this.myR3, this.myR4, this.myR5, this.myR6, this.myForegroundRgbRadio, this.myForegroundPredeinedRadio, this.myForegroundNoValueRadio, this.myBackgroundRgbRadio, this.myBackgroundPredeinedRadio, this.myBackgroundNoRadio, this.myFill, this.myOutline, this.myFillXor, this.myOutlineXor, this.myFontSetFont, this.myFontStyle, this.myForegroundPredefinedColor, this.myBackgroundPredefinedColor};
        n = textArray.length;
        n2 = 0;
        while (n2 < n) {
            Text w = textArray[n2];
            w.addListener(13, (Listener)this);
            ++n2;
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object newInput = null;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            newInput = this.unwrap(((IStructuredSelection)selection).getFirstElement());
        }
        if (newInput != this.myInput) {
            if (this.myInput != null) {
                this.detach();
            }
            this.myInput = newInput;
            if (newInput != null) {
                this.attach();
            }
        }
    }

    protected void commit() {
        ((Shape)this.getInput()).setLineWidth(this.myLineWidth.getSelection());
        ((Shape)this.getInput()).setFill(this.myFill.getSelection());
        ((Shape)this.getInput()).setOutline(this.myOutline.getSelection());
        ((Shape)this.getInput()).setXorFill(this.myFillXor.getSelection());
        ((Shape)this.getInput()).setXorOutline(this.myOutlineXor.getSelection());
        if (this.myR1.getSelection()) {
            ((Shape)this.getInput()).setLineKind(LineKind.LINE_SOLID_LITERAL);
        }
        if (this.myR2.getSelection()) {
            ((Shape)this.getInput()).setLineKind(LineKind.LINE_DASH_LITERAL);
        }
        if (this.myR3.getSelection()) {
            ((Shape)this.getInput()).setLineKind(LineKind.LINE_DOT_LITERAL);
        }
        if (this.myR4.getSelection()) {
            ((Shape)this.getInput()).setLineKind(LineKind.LINE_DASHDOT_LITERAL);
        }
        if (this.myR5.getSelection()) {
            ((Shape)this.getInput()).setLineKind(LineKind.LINE_DASHDOTDOT_LITERAL);
        }
        if (this.myR6.getSelection()) {
            ((Shape)this.getInput()).setLineKind(LineKind.LINE_CUSTOM_LITERAL);
        }
        if (this.myRoundedRectStyle.isVisible()) {
            ((RoundedRectangle)this.getInput()).setCornerWidth(this.myCornerWidth.getSelection());
            ((RoundedRectangle)this.getInput()).setCornerHeight(this.myCornerHeight.getSelection());
        }
        if (this.myForegroundRGBValues.isVisible()) {
            this.getInput().setForegroundColor((Color)GMFGraphFactory.eINSTANCE.createRGBColor());
            ((RGBColor)this.getInput().getForegroundColor()).setRed(this.myForegroundRed.getSelection());
            ((RGBColor)this.getInput().getForegroundColor()).setGreen(this.myForegroundGreen.getSelection());
            ((RGBColor)this.getInput().getForegroundColor()).setBlue(this.myForegroundBlue.getSelection());
        }
        if (this.myForegroundPredefinedValue.isVisible()) {
            this.getInput().setForegroundColor((Color)GMFGraphFactory.eINSTANCE.createConstantColor());
            ((ConstantColor)this.getInput().getForegroundColor()).setValue(ColorConstants.get((int)this.myForegroundPredefinedColor.getSelectionIndex()));
        }
        if (this.myForegroundNoValueRadio.getSelection()) {
            this.getInput().setForegroundColor(null);
        }
        if (this.myBackgroundRGBValues.isVisible()) {
            this.getInput().setBackgroundColor((Color)GMFGraphFactory.eINSTANCE.createRGBColor());
            ((RGBColor)this.getInput().getBackgroundColor()).setRed(this.myBackgroundRed.getSelection());
            ((RGBColor)this.getInput().getBackgroundColor()).setGreen(this.myBackgroundGreen.getSelection());
            ((RGBColor)this.getInput().getBackgroundColor()).setBlue(this.myBackgroundBlue.getSelection());
        }
        if (this.myBackgroundPredefinedValue.isVisible()) {
            this.getInput().setBackgroundColor((Color)GMFGraphFactory.eINSTANCE.createConstantColor());
            ((ConstantColor)this.getInput().getBackgroundColor()).setValue(ColorConstants.get((int)this.myBackgroundPredefinedColor.getSelectionIndex()));
        }
        if (this.myBackgroundNoRadio.getSelection()) {
            this.getInput().setBackgroundColor(null);
        }
        if (this.myFontFaceName.isEnabled() && this.myFontHeight.isEnabled() && this.myFontStyle.isEnabled()) {
            this.getInput().setFont((Font)GMFGraphFactory.eINSTANCE.createBasicFont());
            ((BasicFont)this.getInput().getFont()).setFaceName(this.myFontFaceName.getText());
            ((BasicFont)this.getInput().getFont()).setHeight(this.myFontHeight.getSelection());
            ((BasicFont)this.getInput().getFont()).setStyle(FontStyle.get((int)this.myFontStyle.getSelectionIndex()));
        } else {
            this.getInput().setFont(null);
        }
    }

    public void refresh() {
        this.myIsRefresh = true;
        this.myLineWidth.setSelection(((Shape)this.getInput()).getLineWidth());
        this.myFill.setSelection(((Shape)this.getInput()).isFill());
        this.myOutline.setSelection(((Shape)this.getInput()).isOutline());
        this.myFillXor.setSelection(((Shape)this.getInput()).isXorFill());
        this.myOutlineXor.setSelection(((Shape)this.getInput()).isXorOutline());
        if (((Shape)this.getInput()).getLineKind() == LineKind.LINE_SOLID_LITERAL) {
            this.myR1.setSelection(true);
        } else {
            this.myR1.setSelection(false);
        }
        if (((Shape)this.getInput()).getLineKind() == LineKind.LINE_DASH_LITERAL) {
            this.myR2.setSelection(true);
        } else {
            this.myR2.setSelection(false);
        }
        if (((Shape)this.getInput()).getLineKind() == LineKind.LINE_DOT_LITERAL) {
            this.myR3.setSelection(true);
        } else {
            this.myR3.setSelection(false);
        }
        if (((Shape)this.getInput()).getLineKind() == LineKind.LINE_DASHDOT_LITERAL) {
            this.myR4.setSelection(true);
        } else {
            this.myR4.setSelection(false);
        }
        if (((Shape)this.getInput()).getLineKind() == LineKind.LINE_DASHDOTDOT_LITERAL) {
            this.myR5.setSelection(true);
        } else {
            this.myR5.setSelection(false);
        }
        if (((Shape)this.getInput()).getLineKind() == LineKind.LINE_CUSTOM_LITERAL) {
            this.myR6.setSelection(true);
        } else {
            this.myR6.setSelection(false);
        }
        if (this.getInput() instanceof RoundedRectangle) {
            this.myCornerWidth.setSelection(((RoundedRectangle)this.getInput()).getCornerWidth());
            this.myCornerHeight.setSelection(((RoundedRectangle)this.getInput()).getCornerHeight());
            this.myRoundedRectStyle.setVisible(true);
        } else {
            this.myRoundedRectStyle.setVisible(false);
        }
        if (this.getInput().getForegroundColor() instanceof RGBColor) {
            if (this.getInput().getForegroundColor() != null) {
                this.myForegroundRed.setSelection(((RGBColor)this.getInput().getForegroundColor()).getRed());
                this.myForegroundGreen.setSelection(((RGBColor)this.getInput().getForegroundColor()).getGreen());
                this.myForegroundBlue.setSelection(((RGBColor)this.getInput().getForegroundColor()).getBlue());
            }
            this.myForegroundRgbRadio.setSelection(true);
            this.myForegroundRGBValues.setVisible(true);
        } else {
            this.myForegroundRgbRadio.setSelection(false);
            this.myForegroundRGBValues.setVisible(false);
        }
        if (this.getInput().getForegroundColor() instanceof ConstantColor) {
            if (this.getInput().getForegroundColor() != null) {
                this.myForegroundPredefinedColor.select(((ConstantColor)this.getInput().getForegroundColor()).getValue().getValue());
            }
            this.myForegroundPredeinedRadio.setSelection(true);
            this.myForegroundPredefinedValue.setVisible(true);
        } else {
            this.myForegroundPredeinedRadio.setSelection(false);
            this.myForegroundPredefinedValue.setVisible(false);
        }
        if (this.getInput().getForegroundColor() == null) {
            this.myForegroundNoValueRadio.setSelection(true);
        } else {
            this.myForegroundNoValueRadio.setSelection(false);
        }
        if (this.getInput().getBackgroundColor() instanceof RGBColor) {
            if (this.getInput().getBackgroundColor() != null) {
                this.myBackgroundRed.setSelection(((RGBColor)this.getInput().getBackgroundColor()).getRed());
                this.myBackgroundGreen.setSelection(((RGBColor)this.getInput().getBackgroundColor()).getGreen());
                this.myBackgroundBlue.setSelection(((RGBColor)this.getInput().getBackgroundColor()).getBlue());
            }
            this.myBackgroundRgbRadio.setSelection(true);
            this.myBackgroundRGBValues.setVisible(true);
        } else {
            this.myBackgroundRgbRadio.setSelection(false);
            this.myBackgroundRGBValues.setVisible(false);
        }
        if (this.getInput().getBackgroundColor() instanceof ConstantColor) {
            if (this.getInput().getBackgroundColor() != null) {
                this.myBackgroundPredefinedColor.select(((ConstantColor)this.getInput().getBackgroundColor()).getValue().getValue());
            }
            this.myBackgroundPredeinedRadio.setSelection(true);
            this.myBackgroundPredefinedValue.setVisible(true);
        } else {
            this.myBackgroundPredeinedRadio.setSelection(false);
            this.myBackgroundPredefinedValue.setVisible(false);
        }
        if (this.getInput().getBackgroundColor() == null) {
            this.myBackgroundNoRadio.setSelection(true);
        } else {
            this.myBackgroundNoRadio.setSelection(false);
        }
        if (this.getInput().getFont() instanceof BasicFont) {
            if (this.getInput().getFont() != null) {
                this.myFontFaceName.setText(((BasicFont)this.getInput().getFont()).getFaceName());
                this.myFontHeight.setSelection(((BasicFont)this.getInput().getFont()).getHeight());
                this.myFontStyle.select(((BasicFont)this.getInput().getFont()).getStyle().getValue());
            }
            this.myFontSetFont.setSelection(true);
            this.myFontFaceName.setEnabled(true);
            this.myFontHeight.setEnabled(true);
            this.myFontStyle.setEnabled(true);
        } else {
            this.myFontSetFont.setSelection(false);
            this.myFontFaceName.setEnabled(false);
            this.myFontHeight.setEnabled(false);
            this.myFontStyle.setEnabled(false);
        }
        this.myIsRefresh = false;
    }

    public void aboutToBeHidden() {
        if (this.myInput != null) {
            this.detach();
        }
    }

    public void handleEvent(Event event) {
        if (this.myIsRefresh) {
            return;
        }
        if (event.type == 24) {
            this.markDirty();
        } else if (event.type == 16) {
            this.applyChanges();
        } else if (event.type == 1) {
            if (event.keyCode == 27) {
                this.discardChanges();
            } else if (event.keyCode == 13) {
                this.applyChanges();
            }
        }
        if (event.type == 13) {
            if (this.myFill == event.widget) {
                this.applyChanges();
            } else if (this.myOutline == event.widget) {
                this.applyChanges();
            } else if (this.myFillXor == event.widget) {
                this.applyChanges();
            } else if (this.myOutlineXor == event.widget) {
                this.applyChanges();
            }
            if (this.myR1 == event.widget) {
                if (this.myR1.getSelection()) {
                    this.applyChanges();
                }
            } else if (this.myR2 == event.widget) {
                if (this.myR2.getSelection()) {
                    this.applyChanges();
                }
            } else if (this.myR3 == event.widget) {
                if (this.myR3.getSelection()) {
                    this.applyChanges();
                }
            } else if (this.myR4 == event.widget) {
                if (this.myR4.getSelection()) {
                    this.applyChanges();
                }
            } else if (this.myR5 == event.widget) {
                if (this.myR5.getSelection()) {
                    this.applyChanges();
                }
            } else if (this.myR6 == event.widget) {
                if (this.myR6.getSelection()) {
                    this.applyChanges();
                }
            } else if (this.myForegroundRgbRadio == event.widget) {
                if (this.myForegroundRgbRadio.getSelection()) {
                    this.myForegroundRGBValues.setVisible(true);
                    this.myForegroundPredefinedValue.setVisible(false);
                    this.applyChanges();
                    if (this.getInput().getForegroundColor() != null) {
                        this.myForegroundRed.setSelection(((RGBColor)this.getInput().getForegroundColor()).getRed());
                        this.myForegroundGreen.setSelection(((RGBColor)this.getInput().getForegroundColor()).getGreen());
                        this.myForegroundBlue.setSelection(((RGBColor)this.getInput().getForegroundColor()).getBlue());
                    }
                } else {
                    this.myForegroundRGBValues.setVisible(false);
                }
            } else if (this.myForegroundPredeinedRadio == event.widget) {
                if (this.myForegroundPredeinedRadio.getSelection()) {
                    this.myForegroundPredefinedValue.setVisible(true);
                    this.myForegroundRGBValues.setVisible(false);
                    this.applyChanges();
                    if (this.getInput().getForegroundColor() != null) {
                        this.myForegroundPredefinedColor.select(((ConstantColor)this.getInput().getForegroundColor()).getValue().getValue());
                    }
                } else {
                    this.myForegroundPredefinedValue.setVisible(false);
                }
            } else if (this.myForegroundNoValueRadio == event.widget) {
                if (this.myForegroundNoValueRadio.getSelection()) {
                    this.myForegroundRGBValues.setVisible(false);
                    this.myForegroundPredefinedValue.setVisible(false);
                    this.applyChanges();
                }
            } else if (this.myBackgroundRgbRadio == event.widget) {
                if (this.myBackgroundRgbRadio.getSelection()) {
                    this.myBackgroundRGBValues.setVisible(true);
                    this.myBackgroundPredefinedValue.setVisible(false);
                    this.applyChanges();
                    if (this.getInput().getBackgroundColor() != null) {
                        this.myBackgroundRed.setSelection(((RGBColor)this.getInput().getBackgroundColor()).getRed());
                        this.myBackgroundGreen.setSelection(((RGBColor)this.getInput().getBackgroundColor()).getGreen());
                        this.myBackgroundBlue.setSelection(((RGBColor)this.getInput().getBackgroundColor()).getBlue());
                    }
                } else {
                    this.myBackgroundRGBValues.setVisible(false);
                }
            } else if (this.myBackgroundPredeinedRadio == event.widget) {
                if (this.myBackgroundPredeinedRadio.getSelection()) {
                    this.myBackgroundPredefinedValue.setVisible(true);
                    this.myBackgroundRGBValues.setVisible(false);
                    this.applyChanges();
                    if (this.getInput().getBackgroundColor() != null) {
                        this.myBackgroundPredefinedColor.select(((ConstantColor)this.getInput().getBackgroundColor()).getValue().getValue());
                    }
                } else {
                    this.myBackgroundPredefinedValue.setVisible(false);
                }
            } else if (this.myBackgroundNoRadio == event.widget) {
                if (this.myBackgroundNoRadio.getSelection()) {
                    this.myBackgroundRGBValues.setVisible(false);
                    this.myBackgroundPredefinedValue.setVisible(false);
                    this.applyChanges();
                }
            } else if (this.myFontSetFont == event.widget) {
                if (this.myFontSetFont.getSelection()) {
                    this.myFontFaceName.setEnabled(true);
                    this.myFontHeight.setEnabled(true);
                    this.myFontStyle.setEnabled(true);
                    this.myFontFaceName.setEnabled(true);
                    this.myFontHeight.setEnabled(true);
                    this.myFontStyle.setEnabled(true);
                    this.applyChanges();
                    if (this.getInput().getFont() != null) {
                        this.myFontFaceName.setText(((BasicFont)this.getInput().getFont()).getFaceName());
                        this.myFontHeight.setSelection(((BasicFont)this.getInput().getFont()).getHeight());
                        this.myFontStyle.select(((BasicFont)this.getInput().getFont()).getStyle().getValue());
                    }
                } else {
                    this.myFontFaceName.setEnabled(false);
                    this.myFontHeight.setEnabled(false);
                    this.myFontStyle.setEnabled(false);
                    this.applyChanges();
                }
            }
            if (this.myFontStyle == event.widget || this.myForegroundPredefinedColor == event.widget || this.myBackgroundPredefinedColor == event.widget) {
                this.applyChanges();
            }
        }
    }

    public void modelChanged(Notification msg) {
        if (!this.myIsCommit && Display.getCurrent() != null) {
            this.refresh();
        }
    }

    private void markDirty() {
    }

    protected void applyChanges() {
        try {
            this.myIsCommit = true;
            this.commit();
        }
        finally {
            this.myIsCommit = false;
        }
    }

    protected void discardChanges() {
        this.refresh();
    }

    protected Object unwrap(Object element) {
        return element;
    }

    private void attach() {
        this.myModelListeners = new Adapter[]{new FeatureTracker(this, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_LineKind(), GMFGraphPackage.eINSTANCE.getShape_LineWidth(), GMFGraphPackage.eINSTANCE.getShape_Fill(), GMFGraphPackage.eINSTANCE.getShape_Outline(), GMFGraphPackage.eINSTANCE.getShape_XorFill(), GMFGraphPackage.eINSTANCE.getShape_XorOutline(), GMFGraphPackage.eINSTANCE.getRoundedRectangle_CornerWidth(), GMFGraphPackage.eINSTANCE.getRoundedRectangle_CornerHeight()}), new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_ForegroundColor(), new ChangeTracker(){

            public void modelChanged(Notification n) {
            }
        }, new Adapter[]{new FeatureTracker(this, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Red(), GMFGraphPackage.eINSTANCE.getRGBColor_Green(), GMFGraphPackage.eINSTANCE.getRGBColor_Blue(), GMFGraphPackage.eINSTANCE.getConstantColor_Value()})}), new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_BackgroundColor(), new ChangeTracker(){

            public void modelChanged(Notification n) {
            }
        }, new Adapter[]{new FeatureTracker(this, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Red(), GMFGraphPackage.eINSTANCE.getRGBColor_Green(), GMFGraphPackage.eINSTANCE.getRGBColor_Blue(), GMFGraphPackage.eINSTANCE.getConstantColor_Value()})}), new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_Font(), new ChangeTracker(){

            public void modelChanged(Notification n) {
            }
        }, new Adapter[]{new FeatureTracker(this, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_FaceName(), GMFGraphPackage.eINSTANCE.getBasicFont_Height(), GMFGraphPackage.eINSTANCE.getBasicFont_Style()})})};
        this.getInput().eAdapters().addAll((Collection)Arrays.asList(this.myModelListeners));
    }

    private void detach() {
        if (this.myModelListeners != null) {
            this.getInput().eAdapters().removeAll((Collection)Arrays.asList(this.myModelListeners));
            this.myModelListeners = null;
        }
    }

    protected Figure getInput() {
        return (Figure)this.myInput;
    }

    private Label createLabel(Composite parent, String label) {
        Label l = new Label(parent, 0);
        if (label != null) {
            l.setText(label);
        }
        this.getWidgetFactory().adapt((Control)l, false, false);
        return l;
    }

    private Group createGroup(Composite parent, String label) {
        Group g = new Group(parent, 32);
        if (label != null) {
            g.setText(label);
        }
        this.getWidgetFactory().adapt((Control)g, false, false);
        this.getWidgetFactory().paintBordersFor((Composite)g);
        return g;
    }
}

