/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.Draw2dRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.ImageTranscoderEx;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.ImageTranscoderOutput;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SWTImageTranscoder;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;

public class SVGImageConverter {
    public BufferedImage renderSVGToAWTImage(Document document, RenderInfo info) throws Exception {
        ImageTranscoderEx transcoder = new ImageTranscoderEx();
        this.setUpTranscoders(document, (Transcoder)transcoder, info);
        return transcoder.getBufferedImage();
    }

    public Image renderSVGtoSWTImage(Document document, RenderInfo info) throws Exception {
        SWTImageTranscoder transcoder = new SWTImageTranscoder();
        this.setUpTranscoders(document, (Transcoder)transcoder, info);
        return transcoder.getSWTImage();
    }

    public BufferedImage renderSVGToAWTImage(String strFileName, RenderInfo info) throws Exception {
        FileInputStream in = new FileInputStream(strFileName);
        return this.renderSVGToAWTImage(in, info);
    }

    public BufferedImage renderSVGToAWTImage(byte[] buffer, RenderInfo info) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        return this.renderSVGToAWTImage(in, info);
    }

    private void setUpTranscoders(InputStream in, Transcoder transcoder, RenderInfo info) throws Exception {
        this.initializeTranscoderFromInfo(transcoder, info);
        TranscoderInput input = null;
        ImageTranscoderOutput output = null;
        input = new TranscoderInput(in);
        output = new ImageTranscoderOutput();
        transcoder.transcode(input, (TranscoderOutput)output);
    }

    private void setUpTranscoders(Document document, Transcoder transcoder, RenderInfo info) throws Exception {
        this.initializeTranscoderFromInfo(transcoder, info);
        TranscoderInput input = null;
        ImageTranscoderOutput output = null;
        input = new TranscoderInput(document);
        output = new ImageTranscoderOutput();
        transcoder.transcode(input, (TranscoderOutput)output);
    }

    private void initializeTranscoderFromInfo(Transcoder transcoder, RenderInfo info) {
        if (info.getWidth() > 0) {
            transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, (Object)new Float(info.getWidth()));
        }
        if (info.getHeight() > 0) {
            transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, (Object)new Float(info.getHeight()));
        }
        transcoder.addTranscodingHint(ImageTranscoderEx.KEY_MAINTAIN_ASPECT_RATIO, (Object)info.shouldMaintainAspectRatio());
        transcoder.addTranscodingHint(ImageTranscoderEx.KEY_ANTI_ALIASING, (Object)info.shouldAntiAlias());
        if (info.getBackgroundColor() != null) {
            transcoder.addTranscodingHint(ImageTranscoderEx.KEY_FILL_COLOR, (Object)new Color(info.getBackgroundColor().red, info.getBackgroundColor().green, info.getBackgroundColor().blue));
        }
        if (info.getForegroundColor() != null) {
            transcoder.addTranscodingHint(ImageTranscoderEx.KEY_OUTLINE_COLOR, (Object)new Color(info.getForegroundColor().red, info.getForegroundColor().green, info.getForegroundColor().blue));
        }
    }

    public BufferedImage renderSVGToAWTImage(InputStream in, RenderInfo info) throws Exception {
        ImageTranscoderEx transcoder = new ImageTranscoderEx();
        this.setUpTranscoders(in, (Transcoder)transcoder, info);
        return transcoder.getBufferedImage();
    }

    public Image renderSVGtoSWTImage(String strFileName, RenderInfo info) throws Exception {
        FileInputStream in = new FileInputStream(strFileName);
        return this.renderSVGtoSWTImage(in, info);
    }

    public Image renderSVGtoSWTImage(byte[] buffer, RenderInfo info) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        return this.renderSVGtoSWTImage(in, info);
    }

    public Image renderSVGtoSWTImage(InputStream in, RenderInfo info) throws Exception {
        SWTImageTranscoder transcoder = new SWTImageTranscoder();
        this.setUpTranscoders(in, (Transcoder)transcoder, info);
        return transcoder.getSWTImage();
    }

    public static void exportToPDF(SVGImage svgImage, OutputStream fileOutputStream) throws CoreException {
        try {
            TranscoderOutput transcoderOutput = new TranscoderOutput(fileOutputStream);
            TranscoderInput transcoderInput = new TranscoderInput(svgImage.getDocument());
            PDFTranscoder pdfTranscoder = new PDFTranscoder();
            pdfTranscoder.transcode(transcoderInput, transcoderOutput);
        }
        catch (TranscoderException e) {
            Log.error((Plugin)Draw2dRenderPlugin.getInstance(), (int)4, (String)e.getMessage(), (Throwable)e);
            Status status = new Status(4, "exportToPDF", 0, e.getMessage(), null);
            throw new CoreException((IStatus)status);
        }
    }
}

