/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.render.util;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;

public class CopyToImageUtilTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;

    public CopyToImageUtilTests(String arg0) {
        super(arg0);
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.render.util.CopyToImageUtilTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testCopyToImageUtilTest_BMP() throws Exception {
        this.copyToImageTestForFormat(".bmp", ImageFileFormat.BMP);
    }

    public void testCopyToImageUtilTest_GIF() throws Exception {
        this.copyToImageTestForFormat(".gif", ImageFileFormat.GIF);
    }

    public void testCopyToImageUtilTest_JPEG() throws Exception {
        this.copyToImageTestForFormat(".jpeg", ImageFileFormat.JPEG);
    }

    public void testCopyToImageUtilTest_JPG() throws Exception {
        this.copyToImageTestForFormat(".jpg", ImageFileFormat.JPG);
    }

    public void testCopyToImageUtilTest_PNG() throws Exception {
        this.copyToImageTestForFormat(".png", ImageFileFormat.PNG);
    }

    public void testCopyToImageOffscreenUtilTest_BMP() throws Exception {
        this.copyToImageOffscreenTestForFormat(".bmp", ImageFileFormat.BMP);
    }

    public void testCopyToImageOffscreenUtilTest_GIF() throws Exception {
        this.copyToImageOffscreenTestForFormat(".gif", ImageFileFormat.GIF);
    }

    public void testCopyToImageOffscreenUtilTest_JPEG() throws Exception {
        this.copyToImageOffscreenTestForFormat(".jpeg", ImageFileFormat.JPEG);
    }

    public void testCopyToImageOffscreenUtilTest_JPG() throws Exception {
        this.copyToImageOffscreenTestForFormat(".jpg", ImageFileFormat.JPG);
    }

    public void testCopyToImageOffscreenUtilTest_PNG() throws Exception {
        this.copyToImageOffscreenTestForFormat(".png", ImageFileFormat.PNG);
    }

    private void copyToImageTestForFormat(String suffix, ImageFileFormat type) throws IOException, CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        File file = File.createTempFile("test", suffix);
        Path tmpDest = new Path(file.getPath());
        new CopyToImageUtil().copyToImage(this.getDiagramEditPart(), (IPath)tmpDest, type, (IProgressMonitor)monitor);
        RenderedImage ri = RenderedImageFactory.getInstance((String)tmpDest.toString());
        CopyToImageUtilTests.assertTrue((String)"RenderedImage is null", (ri != null ? 1 : 0) != 0);
        CopyToImageUtilTests.assertTrue((String)"SWTImage is null", (ri.getSWTImage() != null ? 1 : 0) != 0);
        file.delete();
    }

    private void copyToImageOffscreenTestForFormat(String suffix, ImageFileFormat type) throws IOException, CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        File file = File.createTempFile("test", suffix);
        Path tmpDest = new Path(file.getPath());
        new CopyToImageUtil().copyToImage(this.getDiagramEditPart().getDiagramView(), (IPath)tmpDest, type, (IProgressMonitor)monitor, this.getDiagramEditPart().getDiagramPreferencesHint());
        RenderedImage ri = RenderedImageFactory.getInstance((String)tmpDest.toString());
        CopyToImageUtilTests.assertTrue((String)"RenderedImage is null", (ri != null ? 1 : 0) != 0);
        CopyToImageUtilTests.assertTrue((String)"SWTImage is null", (ri.getSWTImage() != null ? 1 : 0) != 0);
        file.delete();
    }
}

