/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestCommandCallback;

public abstract class AbstractConnectionTests
extends AbstractTestBase {
    public static final Point ptStart = new Point(100, 100);
    public static final Point ptEnd = new Point(300, 300);
    public static final Point ptMiddle = new Point(200, 200);

    public AbstractConnectionTests(String arg0) {
        super(arg0);
    }

    public void testDeleteConnection() throws Exception {
        final Object[] diagramValues = new Object[2];
        this.getTestFixture().getEditingDomain().runExclusive(new Runnable(){

            public void run() {
                Diagram dgrm2 = AbstractConnectionTests.this.getTestFixture().getConnectorView().getDiagram();
                diagramValues[0] = dgrm2;
                diagramValues[1] = new Integer(dgrm2.getEdges().size());
            }
        });
        final Diagram dgrm = (Diagram)diagramValues[0];
        final int dgrmSize = (Integer)diagramValues[1];
        DeleteCommand delete = new DeleteCommand(this.getTestFixture().getEditingDomain(), (View)this.getTestFixture().getConnectorView());
        this.testCommand((ICommand)delete, new ITestCommandCallback(){

            public void onCommandExecution() {
                AbstractConnectionTests.assertTrue((dgrm.getEdges().size() == dgrmSize - 1 ? 1 : 0) != 0);
            }
        });
    }

    public void testAddBendpoints() throws Exception {
        final Edge connectorView = this.getTestFixture().getConnectorView();
        RelativeBendpoints pbs = (RelativeBendpoints)connectorView.getBendpoints();
        AbstractConnectionTests.assertTrue((pbs.getPoints().size() == 2 ? 1 : 0) != 0);
        PointList newpts = new PointList(3);
        newpts.addPoint(new Point(ptStart));
        newpts.addPoint(new Point(ptMiddle));
        newpts.addPoint(new Point(ptEnd));
        Point r1 = new Point(ptStart);
        Point r2 = new Point(ptEnd);
        SetConnectionBendpointsCommand bendpointsChanged = new SetConnectionBendpointsCommand(this.getTestFixture().getEditingDomain());
        bendpointsChanged.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)connectorView));
        bendpointsChanged.setNewPointList(newpts, r1, r2);
        this.testCommand((ICommand)bendpointsChanged, new ITestCommandCallback(){

            public void onCommandExecution() {
                RelativeBendpoints bendpoints = (RelativeBendpoints)connectorView.getBendpoints();
                AbstractConnectionTests.assertTrue((bendpoints.getPoints().size() == 3 ? 1 : 0) != 0);
            }
        });
        this.flushEventQueue();
        final Smoothness s1 = Smoothness.NORMAL_LITERAL;
        SetPropertyCommand c = new SetPropertyCommand(this.getTestFixture().getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)connectorView), Properties.ID_SMOOTHNESS, "", (Object)s1);
        this.testCommand((ICommand)c, new ITestCommandCallback(){

            public void onCommandExecution() {
                Object s2 = ViewUtil.getStructuralFeatureValue((View)connectorView, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Smoothness());
                AbstractConnectionTests.assertTrue((boolean)s1.equals(s2));
            }
        });
        newpts.removeAllPoints();
        newpts.addPoint(new Point(ptStart));
        newpts.addPoint(new Point(ptMiddle));
        newpts.addPoint(new Point(this.getDiagramEditPart().getFigure().getBounds().getBottomRight()));
        newpts.addPoint(new Point(ptEnd));
        bendpointsChanged = new SetConnectionBendpointsCommand(this.getTestFixture().getEditingDomain());
        bendpointsChanged.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)connectorView));
        bendpointsChanged.setNewPointList(newpts, r1, r2);
        this.testCommand((ICommand)bendpointsChanged, new ITestCommandCallback(){

            public void onCommandExecution() {
                RelativeBendpoints bendpoints = (RelativeBendpoints)connectorView.getBendpoints();
                AbstractConnectionTests.assertTrue((bendpoints.getPoints().size() == 4 ? 1 : 0) != 0);
            }
        });
        this.flushEventQueue();
    }

    public void testConnectionProperties() throws Exception {
        Edge connectorView = this.getTestFixture().getConnectorView();
        this.testProperty((View)connectorView, Properties.ID_JUMPLINKS_STATUS, JumpLinkStatus.ABOVE_LITERAL);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_JUMPLINKS_TYPE, JumpLinkType.SEMICIRCLE_LITERAL);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_JUMPLINKS_REVERSE, Boolean.TRUE);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_CLOSESTDISTANCE, Boolean.TRUE);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_AVOIDOBSTRUCTIONS, Boolean.TRUE);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_SMOOTHNESS, Smoothness.NORMAL_LITERAL);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_ROUTING, Routing.RECTILINEAR_LITERAL);
        this.flushEventQueue();
        this.testProperty((View)connectorView, Properties.ID_ROUTING, Routing.MANUAL_LITERAL);
        this.flushEventQueue();
    }
}

