/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.expression;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;

public class PolymorphismTest
extends TestCase {
    private static final String TYPE1_STRING_OBJECT = "Type1::String::Object";
    private static final String TYPE1_OBJECT_OBJECT = "Type1::Object::Object";
    private static final String TYPE2_STRING_OBJECT = "Type2::String::Object";
    private static final String TYPE2_STRING_STRING = "Type2::String::String";
    private EClass type1Class;
    private EClass type2Class;
    private EPackage ePackage;

    protected void setUp() throws Exception {
        this.type1Class = EcoreFactory.eINSTANCE.createEClass();
        this.type1Class.setName("Type1");
        this.type2Class = EcoreFactory.eINSTANCE.createEClass();
        this.type2Class.setName("Type2");
        this.type2Class.getESuperTypes().add((Object)this.type1Class);
        this.ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.ePackage.getEClassifiers().add((Object)this.type1Class);
        this.ePackage.getEClassifiers().add((Object)this.type2Class);
        EOperation type1SO = PolymorphismTest.createMyOp(PolymorphismTest.createStringParam(), PolymorphismTest.createObjectParam());
        EOperation type1OO = PolymorphismTest.createMyOp(PolymorphismTest.createObjectParam(), PolymorphismTest.createObjectParam());
        this.type1Class.getEOperations().add((Object)type1SO);
        this.type1Class.getEOperations().add((Object)type1OO);
        EOperation type2SO = PolymorphismTest.createMyOp(PolymorphismTest.createStringParam(), PolymorphismTest.createObjectParam());
        EOperation type2SS = PolymorphismTest.createMyOp(PolymorphismTest.createStringParam(), PolymorphismTest.createStringParam());
        this.type2Class.getEOperations().add((Object)type2SO);
        this.type2Class.getEOperations().add((Object)type2SS);
        BuiltinMetaModel.registerOperationImpl((EOperation)type1SO, (Method)PolymorphismTest.class.getMethod("type1SO", String.class, Object.class));
        BuiltinMetaModel.registerOperationImpl((EOperation)type1OO, (Method)PolymorphismTest.class.getMethod("type1OO", Object.class, Object.class));
        BuiltinMetaModel.registerOperationImpl((EOperation)type2SO, (Method)PolymorphismTest.class.getMethod("type2SO", String.class, Object.class));
        BuiltinMetaModel.registerOperationImpl((EOperation)type2SS, (Method)PolymorphismTest.class.getMethod("type2SS", String.class, String.class));
    }

    public static String type1SO(String str, Object obj) {
        return TYPE1_STRING_OBJECT;
    }

    public static String type1OO(Object o1, Object o2) {
        return TYPE1_OBJECT_OBJECT;
    }

    public static String type2SO(String str, Object obj) {
        return TYPE2_STRING_OBJECT;
    }

    public static String type2SS(String s1, String s2) {
        return TYPE2_STRING_STRING;
    }

    private static EOperation createMyOp(EParameter p1, EParameter p2) {
        EOperation op = EcoreFactory.eINSTANCE.createEOperation();
        op.setName("myOp");
        op.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        op.getEParameters().add((Object)p1);
        op.getEParameters().add((Object)p2);
        return op;
    }

    private static EParameter createStringParam() {
        EParameter p = EcoreFactory.eINSTANCE.createEParameter();
        p.setName("str");
        p.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        return p;
    }

    private static EParameter createObjectParam() {
        EParameter p = EcoreFactory.eINSTANCE.createEParameter();
        p.setName("obj");
        p.setEType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        return p;
    }

    public final void testStuff() {
        EObject type2 = this.ePackage.getEFactoryInstance().create(this.type2Class);
        EObject type1 = this.ePackage.getEFactoryInstance().create(this.type1Class);
        Object obj = new Object();
        Integer other = new Integer(2);
        PolymorphismTest.assertEquals((Object)TYPE1_OBJECT_OBJECT, (Object)this.executeOperation("myOp", type2, new Object[]{obj, "test"}));
        PolymorphismTest.assertEquals((Object)TYPE2_STRING_STRING, (Object)this.executeOperation("myOp", type2, new Object[]{"test", "test"}));
        PolymorphismTest.assertEquals((Object)TYPE2_STRING_OBJECT, (Object)this.executeOperation("myOp", type2, new Object[]{"test", other}));
        PolymorphismTest.assertEquals((Object)TYPE1_STRING_OBJECT, (Object)this.executeOperation("myOp", type1, new Object[]{"test", other}));
    }

    public Object executeOperation(String name, Object target, Object[] params) {
        BuiltinMetaModel.Operation op = BuiltinMetaModel.executableOperation((String)name, (Object[])params, (Object)target);
        PolymorphismTest.assertNotNull((Object)op);
        return op.evaluate();
    }
}

