/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.tests.validate.AnnotationUtil;
import org.eclipse.gmf.tests.validate.DynamicModelHelper;
import org.eclipse.gmf.validate.GMFValidator;

public abstract class MetaExpressionDefTestBase
extends TestCase {
    protected EClass constraintMetaClass;
    protected EStructuralFeature languageAttr;
    protected EStructuralFeature bodyAttr;
    protected EReference contraintRefFeatureCtx;
    protected EReference contraintRefWithOCLCtx;
    protected EClass containerClass;
    protected EStructuralFeature ctxClassRef;
    protected EStructuralFeature ctxTypeRef;

    MetaExpressionDefTestBase(String name) {
        super(name);
    }

    protected abstract String getMetaDefinitionAnnotationKey();

    protected void setUp() throws Exception {
        super.setUp();
        EPackage model = DynamicModelHelper.createMetaModel();
        this.containerClass = DynamicModelHelper.createMetaClass(model);
        this.ctxClassRef = DynamicModelHelper.createFeature(this.containerClass, (EClassifier)EcorePackage.eINSTANCE.getEClass());
        this.ctxTypeRef = DynamicModelHelper.createFeature(this.containerClass, (EClassifier)EcorePackage.eINSTANCE.getEDataType());
        this.constraintMetaClass = DynamicModelHelper.createMetaClass(model);
        this.languageAttr = DynamicModelHelper.createFeature(this.constraintMetaClass, (EClassifier)EcorePackage.eINSTANCE.getEString());
        this.bodyAttr = DynamicModelHelper.createFeature(this.constraintMetaClass, (EClassifier)EcorePackage.eINSTANCE.getEString());
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation((EModelElement)this.constraintMetaClass, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)this.getMetaDefinitionAnnotationKey());
        AnnotationUtil.addLanguageDefAnnotation(this.languageAttr);
        AnnotationUtil.addBodyDefAnnotation(this.bodyAttr);
        this.contraintRefFeatureCtx = (EReference)DynamicModelHelper.createFeature(this.containerClass, (EClassifier)this.constraintMetaClass);
        this.contraintRefFeatureCtx.setContainment(true);
        AnnotationUtil.addContextDefAnnotation((EModelElement)this.contraintRefFeatureCtx, this.ctxClassRef.getName());
        this.contraintRefWithOCLCtx = (EReference)DynamicModelHelper.createFeature(this.containerClass, (EClassifier)this.constraintMetaClass);
        this.contraintRefWithOCLCtx.setContainment(true);
        AnnotationUtil.addContextDefAnnotation((EModelElement)this.contraintRefWithOCLCtx, this.ctxTypeRef.getName());
    }

    public void testValidOCLConstraint() throws Exception {
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"eParameters->size() > 0");
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testNoContextAvailable() throws Exception {
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true");
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE);
    }

    public void testInvalidBody() throws Exception {
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true...");
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_EXPRESSION);
    }

    public void testWrongContextTypeDef() throws Exception {
        this.ctxClassRef.setEType((EClassifier)this.containerClass);
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true");
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE);
    }

    public void testRegExpLikeConstraint() throws Exception {
        this._testValidRegExpConstraint("regexp");
        this._testValidRegExpConstraint("nregexp");
    }

    private void _testValidRegExpConstraint(String regexpLang) throws Exception {
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)regexpLang);
        constraintInstance.eSet(this.bodyAttr, (Object)"[.]");
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_EXPRESSION);
        EObject containerInstance = DynamicModelHelper.createInstance(this.containerClass);
        containerInstance.eSet(this.ctxTypeRef, (Object)EcorePackage.eINSTANCE.getEString());
        containerInstance.eSet((EStructuralFeature)this.contraintRefWithOCLCtx, (Object)constraintInstance);
        status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testDefinitionInheritance() throws Exception {
        EClass intermConstraintSubClass = DynamicModelHelper.createMetaClass(this.constraintMetaClass.getEPackage());
        intermConstraintSubClass.getESuperTypes().add((Object)this.constraintMetaClass);
        EClass finalConstraintSubClass = DynamicModelHelper.createMetaClass(this.constraintMetaClass.getEPackage());
        finalConstraintSubClass.getESuperTypes().add((Object)intermConstraintSubClass);
        EObject constraintInstance = DynamicModelHelper.createInstance(finalConstraintSubClass);
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true...");
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_EXPRESSION);
        constraintInstance.eSet(this.bodyAttr, (Object)"true");
        status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testMissingBodyAnnotation() throws Exception {
        this.bodyAttr.getEAnnotations().clear();
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.MISSING_VALUESPEC_BODY_ANNOTATION);
    }

    protected void bindToEClassContext(EObject constraintInstance, EClass context) {
        EObject containerInstance = DynamicModelHelper.createInstance(this.containerClass);
        containerInstance.eSet(this.ctxClassRef, (Object)EcorePackage.eINSTANCE.getEOperation());
        containerInstance.eSet((EStructuralFeature)this.contraintRefFeatureCtx, (Object)constraintInstance);
    }
}

