/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.migration.JavaExtensionDescriptor;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.JavaExtensionStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallTrace
extends ExpressionAnalyzeTrace {
    private Type type;
    private EOperation operation;
    private EClassifier targetType;
    private List<EClassifier> paramTypes;
    private String nativeLibraryName;
    private boolean staticQvtoCall = true;

    public static boolean isStaticQvtoCall(ExecutionContext ctx, Extension extension) {
        if (extension.getFormalParameters().size() < 1) {
            return true;
        }
        HashSet<Extension> allExtensions = new HashSet<Extension>(ctx.getAllExtensions());
        Iterator it = allExtensions.iterator();
        while (it.hasNext()) {
            Extension nextExtension = (Extension)it.next();
            if (extension.getFileName().equals(nextExtension.getFileName()) && extension.getName().equals(nextExtension.getName()) && extension.getParameterTypes().size() == nextExtension.getParameterTypes().size() && !(extension.isPrivate() ^ nextExtension.isPrivate())) continue;
            it.remove();
        }
        return allExtensions.size() == 1;
    }

    public static String getNativeLibraryName(Extension extension) {
        if (extension instanceof JavaExtensionStatement) {
            return JavaExtensionDescriptor.getNativeLibraryName((JavaExtensionStatement)extension);
        }
        return null;
    }

    public static List<EClassifier> getParamTypes(EOperation op) {
        EList parameters = op.getEParameters();
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        int i = 0;
        while (i < parameters.size()) {
            result.add(BuiltinMetaModel.getTypedElementType((ETypedElement)parameters.get(i)));
            ++i;
        }
        return result;
    }

    public static List<EClassifier> getParamTypes(Extension f, ExecutionContext ctx) {
        List<DeclaredParameter> formalParameters = f.getFormalParameters();
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        int i = 0;
        while (i < formalParameters.size()) {
            result.add(ctx.getTypeForName(formalParameters.get(i).getType().getValue()));
            ++i;
        }
        return result;
    }

    public OperationCallTrace(Type type) {
        this(null, null, null, type);
    }

    public OperationCallTrace(EClassifier result, List<EClassifier> paramTypes, String nativeLibraryName, Type type, boolean isStaticQvtoCall) {
        this(result, paramTypes, nativeLibraryName, type);
        this.staticQvtoCall = isStaticQvtoCall;
    }

    public OperationCallTrace(EClass result, List<EClassifier> paramTypes, EClassifier targetType, String nativeLibraryName, boolean isStaticQvtoCall) {
        this((EClassifier)result, paramTypes, nativeLibraryName, Type.IMPLICIT_COLLECT_EXTENSION_REF, isStaticQvtoCall);
        this.targetType = targetType;
    }

    public OperationCallTrace(EClassifier result, List<EClassifier> paramTypes, EClassifier targetType, EOperation operation, Type type) {
        this(result, paramTypes, null, type);
        this.targetType = targetType;
        this.operation = operation;
    }

    public OperationCallTrace(EClassifier result, List<EClassifier> paramTypes, EClassifier targetType, EOperation operation) {
        this(result, paramTypes, targetType, operation, Type.OPERATION_REF);
        this.paramTypes = paramTypes;
    }

    private OperationCallTrace(EClassifier result, List<EClassifier> paramTypes, String nativeLibraryName, Type type) {
        super(result);
        this.paramTypes = paramTypes;
        this.type = type;
        this.nativeLibraryName = nativeLibraryName;
    }

    public Type getType() {
        return this.type;
    }

    public EOperation getEOperation() {
        return this.operation;
    }

    public EClassifier getTargetType() {
        return this.targetType;
    }

    public List<EClassifier> getParamTypes() {
        return this.paramTypes;
    }

    public String getNativeLibraryName() {
        return this.nativeLibraryName;
    }

    public boolean isStaticQvtoCall() {
        return this.staticQvtoCall;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNDESOLVED_PARAMETER_TYPE,
        UNDESOLVED_TARGET_TYPE,
        STATIC_EXTENSION_REF,
        OPERATION_REF,
        EXTENSION_REF,
        IMPLICIT_COLLECT_OPERATION_REF,
        IMPLICIT_COLLECT_EXTENSION_REF;

    }
}

