/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.core;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.IListenerContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.ITransferDragSourceListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.ITransferDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDPlugin;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.GetTransferAdapterOperation;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.ITransferAdapterProvider;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.ListenerOperation;

public class TransferAdapterService
extends Service
implements ITransferAdapterProvider {
    private static final TransferAdapterService instance = new TransferAdapterService();

    static {
        instance.configureProviders(CommonUIServicesDNDPlugin.getPluginId(), "transferAdapterProviders");
    }

    public static TransferAdapterService getInstance() {
        return instance;
    }

    protected TransferAdapterService() {
        super(false);
    }

    private Object execute(ListenerOperation operation) {
        List results = this.execute(ExecutionStrategy.FIRST, operation);
        return results.isEmpty() ? null : results.get(0);
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element, this.getTransferAdapterProviderInfo(element));
    }

    private Hashtable getTransferAdapterProviderInfo(IConfigurationElement element) {
        Hashtable providerInfo = new Hashtable();
        IConfigurationElement[] adapterTypeChildren = element.getChildren("AdapterType");
        int i = 0;
        while (i < adapterTypeChildren.length) {
            IConfigurationElement adapterTypeConfig = adapterTypeChildren[i];
            String operationType = adapterTypeConfig.getAttribute("operation");
            Vector<Integer> listOftransferIds = new Vector<Integer>();
            IConfigurationElement[] transferChildren = adapterTypeConfig.getChildren();
            int j = 0;
            while (j < transferChildren.length) {
                IConfigurationElement transferConfig = transferChildren[j];
                String id = transferConfig.getAttribute("id");
                listOftransferIds.addElement(id.hashCode());
                ++j;
            }
            providerInfo.put(operationType.hashCode(), listOftransferIds);
            ++i;
        }
        return providerInfo;
    }

    public ITransferDragSourceListener getTransferDragSourceAdapter(String transferId) {
        assert (transferId != null) : "transferId cannot be null";
        final String id = transferId;
        return (ITransferDragSourceListener)this.execute(new GetTransferAdapterOperation(new IListenerContext(){

            public String getOperationType() {
                return "drag";
            }

            public String getTransferId() {
                return id;
            }
        }));
    }

    public ITransferDropTargetListener getTransferDropTargetAdapter(String transferId) {
        assert (transferId != null) : "transferId cannot be null";
        final String id = transferId;
        return (ITransferDropTargetListener)this.execute(new GetTransferAdapterOperation(new IListenerContext(){

            public String getOperationType() {
                return "drop";
            }

            public String getTransferId() {
                return id;
            }
        }));
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private Hashtable adapterInfo = null;

        protected ProviderDescriptor(IConfigurationElement element, Hashtable anAdapterInfo) {
            super(element);
            assert (anAdapterInfo != null) : "anAdapterInfo cannot be null";
            this.adapterInfo = anAdapterInfo;
        }

        public boolean provides(IOperation operation) {
            List transferIdList;
            if (!(operation instanceof GetTransferAdapterOperation)) {
                return false;
            }
            String operationType = ((GetTransferAdapterOperation)operation).getContext().getOperationType();
            String transferId = ((GetTransferAdapterOperation)operation).getContext().getTransferId();
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("TAS:provides::Operation Type is " + operationType));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("TAS:provides::Transfer id is " + transferId));
            }
            if ((transferIdList = (List)this.getAdapterInfo().get(operationType.hashCode())) == null) {
                return false;
            }
            return transferIdList.contains(transferId.hashCode());
        }

        private Hashtable getAdapterInfo() {
            return this.adapterInfo;
        }
    }
}

