/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.internal;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.printing.IPrintHelper;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupPageType;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.PageData;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.util.PrintHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.diagram.ui.util.DiagramEditorUtil;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics.GraphicsToGraphics2DAdaptor;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedScaledGraphics;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JPSDiagramPrinter
extends DiagramPrinter
implements Printable {
    private static double AWT_DPI_CONST = 72.0;
    private PrintService printService;
    private PageData[] pages;
    private IPrintHelper printHelper;

    public JPSDiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        super(preferencesHint, mm);
        this.preferencesHint = preferencesHint;
        this.mapMode = mm;
    }

    public JPSDiagramPrinter(PreferencesHint preferencesHint) {
        this(preferencesHint, MapModeUtil.getMapMode());
    }

    public void setPrintHelper(IPrintHelper helper) {
        this.printHelper = helper;
    }

    public void setPrinter(String printerName) {
        HashPrintServiceAttributeSet attributes = new HashPrintServiceAttributeSet(new PrinterName(printerName, Locale.getDefault()));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, attributes);
        this.printService = services[0];
    }

    public void run() {
        Iterator it = this.diagrams.iterator();
        Shell shell = new Shell();
        try {
            while (it.hasNext()) {
                IPreferenceStore preferenceStore;
                Diagram diagram = (Diagram)it.next();
                DiagramEditor openedDiagramEditor = DiagramEditorUtil.findOpenedDiagramEditorForID((String)ViewUtil.getIdStr((View)diagram));
                DiagramEditPart dgrmEP = openedDiagramEditor == null ? PrintHelperUtil.createDiagramEditPart((Diagram)diagram, (PreferencesHint)this.preferencesHint, (Shell)shell) : openedDiagramEditor.getDiagramEditPart();
                boolean loadedPreferences = openedDiagramEditor != null || PrintHelperUtil.initializePreferences((DiagramEditPart)dgrmEP, (PreferencesHint)this.preferencesHint);
                RootEditPart rep = dgrmEP.getRoot();
                if (rep instanceof DiagramRootEditPart) {
                    this.mapMode = ((DiagramRootEditPart)rep).getMapMode();
                }
                if ((preferenceStore = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore()).getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
                    preferenceStore = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
                }
                this.doPrintDiagram(this.printService.createPrintJob(), dgrmEP, loadedPreferences, preferenceStore);
            }
        }
        finally {
            this.dispose();
            shell.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void printToScale(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        figureBounds = PrintHelperUtil.getPageBreakBounds((DiagramEditPart)dgrmEP, (boolean)loadedPreferences);
        pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-figureBounds.x) * this.userScale), (int)((float)(-figureBounds.y) * this.userScale));
        numRows = 0;
        numCols = 0;
        margins = this.adjustMarginsToScale(PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode()));
        fontData = JFaceResources.getDefaultFont().getFontData()[0];
        pageCount = this.getPageCount(dgrmEP, figureBounds, pageBounds, true);
        numCols = pageCount.x;
        numRows = pageCount.y;
        row = 1;
        col = 1;
        finalRow = 0;
        finalColumn = 0;
        pageList = new ArrayList<PageData>();
        if (!this.printRangePageSelection) ** GOTO lbl31
        row = this.calculateRowFromPage(this.pageFrom, numCols);
        col = this.calculateColumnFromPage(this.pageFrom, numCols, row);
        finalRow = this.calculateRowFromPage(this.pageTo, numCols);
        finalColumn = this.calculateColumnFromPage(this.pageTo, numCols, finalRow);
        ** GOTO lbl31
        {
            pageList.add(new PageData(pageList.size(), row, col, dgrmEP, figureBounds, margins, fontData, fPreferences));
            if (row == finalRow && col == finalColumn && this.printRangePageSelection) ** GOTO lbl28
            ++col;
            do {
                if (col <= numCols) continue block0;
lbl28:
                // 2 sources

                if (row == finalRow && col == finalColumn && this.printRangePageSelection) break block0;
                col = 1;
                ++row;
lbl31:
                // 3 sources

            } while (row <= numRows);
        }
        this.pages = pageList.toArray(new PageData[pageList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected void printToPages(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        figureBounds = PrintHelperUtil.getPageBreakBounds((DiagramEditPart)dgrmEP, (boolean)loadedPreferences);
        pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        pageCount = this.getPageCount(dgrmEP, figureBounds, pageBounds, false);
        numCols = pageCount.x;
        numRows = pageCount.y;
        actualWidth = 0.0f;
        actualHeight = 0.0f;
        if (this.rows == 1 && this.columns == 1 && this.fitToPage) {
            figureBounds = dgrmEP.getChildrenBounds();
            actualWidth = figureBounds.width;
            actualHeight = figureBounds.height;
        } else {
            actualWidth = numCols * pageBounds.x;
            actualHeight = numRows * pageBounds.y;
        }
        totalHeight = this.rows * pageBounds.y;
        totalWidth = this.columns * pageBounds.x;
        vScale = (float)totalHeight / actualHeight;
        hScale = (float)totalWidth / actualWidth;
        this.userScale = Math.min(hScale, vScale);
        margins = this.adjustMarginsToScale(PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode()));
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-figureBounds.x) * this.userScale), (int)((float)(-figureBounds.y) * this.userScale));
        fontData = JFaceResources.getDefaultFont().getFontData()[0];
        row = 1;
        col = 1;
        finalRow = 0;
        finalColumn = 0;
        pageList = new ArrayList<PageData>();
        if (!this.printRangePageSelection) ** GOTO lbl43
        row = this.calculateRowFromPage(this.pageFrom, this.columns);
        col = this.calculateColumnFromPage(this.pageFrom, this.columns, row);
        finalRow = this.calculateRowFromPage(this.pageTo, this.columns);
        finalColumn = this.calculateColumnFromPage(this.pageTo, this.columns, finalRow);
        ** GOTO lbl43
        {
            pageList.add(new PageData(pageList.size(), row, col, dgrmEP, figureBounds, margins, fontData, fPreferences));
            if (row == finalRow && col == finalColumn && this.printRangePageSelection) ** GOTO lbl40
            ++col;
            do {
                if (col <= this.columns) continue block0;
lbl40:
                // 2 sources

                if (row == finalRow && col == finalColumn && this.printRangePageSelection) break block0;
                col = 1;
                ++row;
lbl43:
                // 3 sources

            } while (row <= this.rows);
        }
        this.pages = pageList.toArray(new PageData[pageList.size()]);
    }

    @Override
    public int print(java.awt.Graphics printGraphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pages.length) {
            return 1;
        }
        try {
            printGraphics.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            this.swtGraphics = new PrinterGraphicsToGraphics2DAdapter((Graphics2D)printGraphics, new Rectangle(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight()));
            this.graphics = this.createMapModeGraphics((Graphics)this.createPrinterGraphics(this.swtGraphics));
            this.graphics.scale(AWT_DPI_CONST / (double)this.display_dpi.x);
            this.drawPage(this.pages[pageIndex]);
        }
        finally {
            this.dispose();
        }
        return 0;
    }

    protected MapModeGraphics createMapModeGraphics(Graphics theGraphics) {
        return new RenderedMapModeGraphics(theGraphics, this.getMapMode());
    }

    protected ScaledGraphics createPrinterGraphics(Graphics theGraphics) {
        return new RenderedScaledGraphics(theGraphics);
    }

    protected PrintRequestAttributeSet initializePrintOptions(DocPrintJob printJob, String jobName, IPreferenceStore fPreferences) {
        PrintOptions advancedOptions = ((PrintHelper)this.printHelper).getPrintOptions();
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (fPreferences.getBoolean("print.usePortrait")) {
            printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        } else {
            printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        }
        String pageSize = fPreferences.getString("print.page.size");
        if (pageSize.compareToIgnoreCase(PageSetupPageType.LETTER.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.NA_LETTER);
        } else if (pageSize.compareToIgnoreCase(PageSetupPageType.LEGAL.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.NA_LEGAL);
        } else if (pageSize.compareToIgnoreCase(PageSetupPageType.EXECUTIVE.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.EXECUTIVE);
        } else if (pageSize.compareToIgnoreCase(PageSetupPageType.A3.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.ISO_A3);
        } else if (pageSize.compareToIgnoreCase(PageSetupPageType.A4.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        } else if (pageSize.compareToIgnoreCase(PageSetupPageType.B4.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.ISO_B4);
        } else if (pageSize.compareToIgnoreCase(PageSetupPageType.B5.getName()) == 0) {
            printRequestAttributeSet.add(MediaSizeName.ISO_B5);
        }
        if (advancedOptions.isQualityLow()) {
            printRequestAttributeSet.add(PrintQuality.DRAFT);
        } else if (advancedOptions.isQualityMed()) {
            printRequestAttributeSet.add(PrintQuality.NORMAL);
        } else if (advancedOptions.isQualityHigh()) {
            printRequestAttributeSet.add(PrintQuality.HIGH);
        }
        if (advancedOptions.isSideDuplex()) {
            printRequestAttributeSet.add(Sides.DUPLEX);
        } else if (advancedOptions.isSideOneSided()) {
            printRequestAttributeSet.add(Sides.ONE_SIDED);
        } else if (advancedOptions.isSideTumble()) {
            printRequestAttributeSet.add(Sides.TUMBLE);
        }
        if (advancedOptions.isChromaticityColor()) {
            printRequestAttributeSet.add(Chromaticity.COLOR);
        } else {
            printRequestAttributeSet.add(Chromaticity.MONOCHROME);
        }
        MediaSize mediaSize = this.getMediaSize(pageSize, printRequestAttributeSet, fPreferences);
        printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(25400), mediaSize.getY(25400), 25400));
        printRequestAttributeSet.add(new Copies(this.printHelper.getDlgNumberOfCopies()));
        if (this.printHelper.getDlgCollate()) {
            printRequestAttributeSet.add(SheetCollate.COLLATED);
        } else {
            printRequestAttributeSet.add(SheetCollate.UNCOLLATED);
        }
        String userJobName = advancedOptions.getJobName();
        if (userJobName != null && userJobName.length() > 0) {
            jobName = userJobName;
        }
        printRequestAttributeSet.add(new JobName(jobName, Locale.getDefault()));
        return printRequestAttributeSet;
    }

    private MediaSize getMediaSize(String pageSize, PrintRequestAttributeSet printRequestAttributeSet, IPreferenceStore fPreferences) {
        MediaSize mediaSize;
        if (pageSize.compareToIgnoreCase(PageSetupPageType.USER_DEFINED.getName()) == 0) {
            float width = (float)fPreferences.getDouble("print.page.width");
            float height = (float)fPreferences.getDouble("print.page.height");
            int units = fPreferences.getBoolean("print.useInches") ? 25400 : 1000;
            mediaSize = new MediaSize(width, height, units);
        } else {
            MediaSizeName media = (MediaSizeName)printRequestAttributeSet.get(Media.class);
            mediaSize = MediaSize.getMediaSizeForName(media);
        }
        if (mediaSize == null) {
            mediaSize = MediaSize.ISO.A4;
        }
        return mediaSize;
    }

    protected void doPrintDiagram(DocPrintJob printJob, DiagramEditPart diagramEditPart, boolean loadedPreferences, IPreferenceStore fPreferences) {
        PrintRequestAttributeSet printRequestAttributeSet = this.initializePrintOptions(printJob, diagramEditPart.getDiagramView().getName(), fPreferences);
        if (this.isScaledPercent) {
            this.printToScale(diagramEditPart, loadedPreferences, fPreferences);
        } else {
            this.printToPages(diagramEditPart, loadedPreferences, fPreferences);
        }
        SimpleDoc doc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashDocAttributeSet());
        try {
            printJob.print(doc, printRequestAttributeSet);
        }
        catch (PrintException e) {
            Trace.catching((Plugin)DiagramPrintingPlugin.getInstance(), (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, DiagramPrinterUtil.class, (String)e.getMessage(), (Throwable)e);
            Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)5, (String)e.getMessage(), (Throwable)e);
            Display display = diagramEditPart.getViewer().getControl().getDisplay();
            if (display == null) {
                display = DisplayUtils.getDisplay();
            }
            MessageDialog.openError((Shell)display.getActiveShell(), (String)DiagramUIPrintingMessages.JPSDiagramPrinterUtil_ErrorTitle, (String)DiagramUIPrintingMessages.JPSDiagramPrinterUtil_ErrorMessage);
        }
    }

    protected void drawPage(PageData page) {
        boolean rtlEnabled;
        this.graphics.pushState();
        Display display = DisplayUtils.getDisplay();
        int shellStyle = display.getActiveShell().getStyle();
        boolean bl = rtlEnabled = (shellStyle & 0x8000000) != 0;
        if (rtlEnabled) {
            Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)page.preferences, (boolean)false, (IMapMode)this.getMapMode());
            Image image = new Image((Device)display, this.getMapMode().LPtoDP(pageSize.x), this.getMapMode().LPtoDP(pageSize.y));
            GC imgGC = new GC((Drawable)image, 0x4000000);
            SWTGraphics tempSWTGraphic = new SWTGraphics(imgGC);
            RenderedScaledGraphics tempScaledGraphic = new RenderedScaledGraphics((Graphics)tempSWTGraphic);
            MapModeGraphics tempMapModeGraphic = this.createMapModeGraphics((Graphics)tempScaledGraphic);
            imgGC.setFont(tempMapModeGraphic.getFont());
            this.internalDrawPage(page.diagram, page.bounds, page.preferences, page.margins, (Graphics)tempMapModeGraphic, page.row, page.column, true);
            this.graphics.drawImage(image, 0, 0);
            tempMapModeGraphic.dispose();
            tempScaledGraphic.dispose();
            tempSWTGraphic.dispose();
            imgGC.dispose();
            image.dispose();
        } else {
            this.internalDrawPage(page.diagram, page.bounds, page.preferences, page.margins, this.graphics, page.row, page.column, false);
        }
        this.graphics.popState();
    }

    protected void internalDrawPage(DiagramEditPart dgrmEP, Rectangle figureBounds, IPreferenceStore fPreferences, PageInfoHelper.PageMargins margins, Graphics g, int rowIndex, int colIndex, boolean RTL_ENABLED) {
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        int width = pageSize.x;
        int height = pageSize.y;
        g.pushState();
        g.translate(this.translated.x, this.translated.y);
        g.scale((double)this.userScale);
        int translateX = -(width * (colIndex - 1));
        int translateY = -(height * (rowIndex - 1));
        int scaledTranslateX = (int)((float)translateX / this.userScale);
        int scaledTranslateY = (int)((float)translateY / this.userScale);
        int scaledWidth = (int)((float)width / this.userScale);
        int scaledHeight = (int)((float)height / this.userScale);
        if (RTL_ENABLED) {
            scaledTranslateX += margins.left * (colIndex - 1) + margins.right * colIndex;
            scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1);
        } else {
            scaledTranslateX += margins.left * colIndex + margins.right * (colIndex - 1);
            scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1);
        }
        g.translate(scaledTranslateX, scaledTranslateY);
        Rectangle clip = new Rectangle((scaledWidth - margins.left - margins.right) * (colIndex - 1) + figureBounds.x, (scaledHeight - margins.bottom - margins.top) * (rowIndex - 1) + figureBounds.y, scaledWidth - margins.right - margins.left, scaledHeight - margins.top - margins.bottom);
        g.clipRect(clip);
        dgrmEP.getLayer((Object)"Printable Layers").paint(g);
        g.popState();
    }

    private PageInfoHelper.PageMargins adjustMarginsToScale(PageInfoHelper.PageMargins margins) {
        margins.left = (int)((float)margins.left / this.userScale);
        margins.top = (int)((float)margins.top / this.userScale);
        margins.bottom = (int)((float)margins.bottom / this.userScale);
        margins.right = (int)((float)margins.right / this.userScale);
        return margins;
    }

    private class PrinterGraphicsToGraphics2DAdapter
    extends GraphicsToGraphics2DAdaptor {
        public PrinterGraphicsToGraphics2DAdapter(Graphics2D graphics, Rectangle viewPort) {
            super(graphics, viewPort);
        }

        public void setLineWidth(int width) {
            super.setLineWidth(width);
            BasicStroke scaledStroke = this.getStroke();
            scaledStroke = new BasicStroke((float)((double)width * AWT_DPI_CONST / 100.0), scaledStroke.getEndCap(), scaledStroke.getLineJoin(), scaledStroke.getMiterLimit(), scaledStroke.getDashArray(), 0.0f);
            this.getGraphics2D().setStroke(scaledStroke);
        }

        public void fillGradient(int x, int y, int w, int h, boolean vertical) {
            Image tempImage = new Image((Device)DisplayUtils.getDisplay(), new org.eclipse.swt.graphics.Rectangle(x, y, w, h));
            GC gc = new GC((Drawable)tempImage);
            SWTGraphics tempGraphics = new SWTGraphics(gc);
            tempGraphics.setForegroundColor(JPSDiagramPrinter.this.swtGraphics.getForegroundColor());
            tempGraphics.setBackgroundColor(JPSDiagramPrinter.this.swtGraphics.getBackgroundColor());
            tempGraphics.fillGradient(new Rectangle(0, 0, w, h), vertical);
            this.drawImage(tempImage, 0, 0, w, h, x, y, w, h);
            tempGraphics.dispose();
            gc.dispose();
            tempImage.dispose();
        }
    }
}

