/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.ecore.edit.parts.EAnnotation2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EAnnotationDetailsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EAnnotationEditPart;
import org.eclipse.gmf.ecore.edit.parts.EAnnotationReferencesEditPart;
import org.eclipse.gmf.ecore.edit.parts.EAnnotationSourceEditPart;
import org.eclipse.gmf.ecore.edit.parts.EAttributeEditPart;
import org.eclipse.gmf.ecore.edit.parts.EClass2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EClassAttributesEditPart;
import org.eclipse.gmf.ecore.edit.parts.EClassClassAnnotationsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EClassESuperTypesEditPart;
import org.eclipse.gmf.ecore.edit.parts.EClassEditPart;
import org.eclipse.gmf.ecore.edit.parts.EClassNameEditPart;
import org.eclipse.gmf.ecore.edit.parts.EClassOperationsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EDataType2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EDataTypeDataTypeAnnotationsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EDataTypeEditPart;
import org.eclipse.gmf.ecore.edit.parts.EDataTypeNameEditPart;
import org.eclipse.gmf.ecore.edit.parts.EEnum2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EEnumEditPart;
import org.eclipse.gmf.ecore.edit.parts.EEnumEnumAnnotationsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EEnumLiteralEditPart;
import org.eclipse.gmf.ecore.edit.parts.EEnumLiteralsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EEnumNameEditPart;
import org.eclipse.gmf.ecore.edit.parts.EOperationEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackage2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackage3EditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackageClassesEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackageDataTypesEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackageEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackageEnumsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackageNameEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackagePackageAnnotationsEditPart;
import org.eclipse.gmf.ecore.edit.parts.EPackagePackagesEditPart;
import org.eclipse.gmf.ecore.edit.parts.EReference2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EReferenceEditPart;
import org.eclipse.gmf.ecore.edit.parts.EReferenceLowerBoundUpperBound2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EReferenceLowerBoundUpperBoundEditPart;
import org.eclipse.gmf.ecore.edit.parts.EReferenceName2EditPart;
import org.eclipse.gmf.ecore.edit.parts.EReferenceNameEditPart;
import org.eclipse.gmf.ecore.edit.parts.EStringToStringMapEntryEditPart;
import org.eclipse.gmf.ecore.part.EcoreVisualIDRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class EcoreEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (EcoreVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new EPackageEditPart(view);
                }
                case 2001: {
                    return new EClassEditPart(view);
                }
                case 5001: {
                    return new EClassNameEditPart(view);
                }
                case 2002: {
                    return new EPackage2EditPart(view);
                }
                case 5002: {
                    return new EPackageNameEditPart(view);
                }
                case 2003: {
                    return new EAnnotation2EditPart(view);
                }
                case 5003: {
                    return new EAnnotationSourceEditPart(view);
                }
                case 2004: {
                    return new EDataType2EditPart(view);
                }
                case 5004: {
                    return new EDataTypeNameEditPart(view);
                }
                case 2005: {
                    return new EEnum2EditPart(view);
                }
                case 5005: {
                    return new EEnumNameEditPart(view);
                }
                case 3001: {
                    return new EAttributeEditPart(view);
                }
                case 3002: {
                    return new EOperationEditPart(view);
                }
                case 3003: {
                    return new EAnnotationEditPart(view);
                }
                case 3004: {
                    return new EClass2EditPart(view);
                }
                case 3005: {
                    return new EPackage3EditPart(view);
                }
                case 3006: {
                    return new EDataTypeEditPart(view);
                }
                case 3007: {
                    return new EEnumEditPart(view);
                }
                case 3008: {
                    return new EStringToStringMapEntryEditPart(view);
                }
                case 3009: {
                    return new EEnumLiteralEditPart(view);
                }
                case 7001: {
                    return new EClassAttributesEditPart(view);
                }
                case 7002: {
                    return new EClassOperationsEditPart(view);
                }
                case 7003: {
                    return new EClassClassAnnotationsEditPart(view);
                }
                case 7004: {
                    return new EPackageClassesEditPart(view);
                }
                case 7005: {
                    return new EPackagePackagesEditPart(view);
                }
                case 7006: {
                    return new EPackageDataTypesEditPart(view);
                }
                case 7007: {
                    return new EPackageEnumsEditPart(view);
                }
                case 7008: {
                    return new EPackagePackageAnnotationsEditPart(view);
                }
                case 7009: {
                    return new EAnnotationDetailsEditPart(view);
                }
                case 7010: {
                    return new EDataTypeDataTypeAnnotationsEditPart(view);
                }
                case 7011: {
                    return new EEnumLiteralsEditPart(view);
                }
                case 7012: {
                    return new EEnumEnumAnnotationsEditPart(view);
                }
                case 4001: {
                    return new EAnnotationReferencesEditPart(view);
                }
                case 4002: {
                    return new EReferenceEditPart(view);
                }
                case 6001: {
                    return new EReferenceNameEditPart(view);
                }
                case 6003: {
                    return new EReferenceLowerBoundUpperBoundEditPart(view);
                }
                case 4003: {
                    return new EReference2EditPart(view);
                }
                case 6002: {
                    return new EReferenceName2EditPart(view);
                }
                case 6004: {
                    return new EReferenceLowerBoundUpperBound2EditPart(view);
                }
                case 4004: {
                    return new EClassESuperTypesEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrapLabel) {
            return new TextCellEditorLocator((WrapLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

