/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.map.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.common.migrate.MigrationDelegateImpl;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.MappingEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MigrationDelegate
extends MigrationDelegateImpl {
    private Map<LabelMapping, FeatureLabelMapping> myLabelMappingMigrations;
    private EAttribute myLabelMapping_ViewPattern;
    private EAttribute myLabelMapping_EditPattern;
    private EReference myLabelMapping_Features;

    MigrationDelegate() {
    }

    void init() {
        this.registerNarrowedAbstractType("FeatureInitializer", GMFMapPackage.eINSTANCE.getFeatureValueSpec());
        this.myLabelMapping_Features = (EReference)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_Features());
        this.myLabelMapping_ViewPattern = (EAttribute)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_ViewPattern());
        this.myLabelMapping_EditPattern = (EAttribute)EcoreUtil.copy((EObject)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_EditPattern());
        HashMap<String, Object> renamings = new HashMap<String, Object>();
        renamings.put(this.myLabelMapping_ViewPattern.getName(), this.myLabelMapping_ViewPattern);
        renamings.put(this.myLabelMapping_EditPattern.getName(), this.myLabelMapping_EditPattern);
        renamings.put(this.myLabelMapping_Features.getName(), this.myLabelMapping_Features);
        this.registerRenamedAttributes(GMFMapPackage.eINSTANCE.getLabelMapping(), renamings);
        this.myLabelMappingMigrations = null;
    }

    public boolean setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (this.myLabelMapping_ViewPattern.equals(feature)) {
            LabelMapping mapping = (LabelMapping)object;
            String viewPattern = (String)value;
            FeatureLabelMapping migratedMapping = this.saveFeatureLabelMappingFor(mapping);
            migratedMapping.setViewPattern(viewPattern);
            this.fireMigrationApplied(true);
        } else if (this.myLabelMapping_EditPattern.equals(feature)) {
            LabelMapping mapping = (LabelMapping)object;
            String editPattern = (String)value;
            FeatureLabelMapping migratedMapping = this.saveFeatureLabelMappingFor(mapping);
            migratedMapping.setViewPattern(editPattern);
            this.fireMigrationApplied(true);
        } else if (this.myLabelMapping_Features.equals(feature)) {
            LabelMapping mapping = (LabelMapping)object;
            EAttribute attribute = (EAttribute)value;
            FeatureLabelMapping migratedMapping = this.saveFeatureLabelMappingFor(mapping);
            migratedMapping.getFeatures().add((Object)attribute);
            this.fireMigrationApplied(true);
        } else {
            return super.setValue(object, feature, value, position);
        }
        return true;
    }

    private FeatureLabelMapping saveFeatureLabelMappingFor(LabelMapping labelMapping) {
        FeatureLabelMapping migrated;
        if (this.myLabelMappingMigrations == null) {
            this.myLabelMappingMigrations = new HashMap<LabelMapping, FeatureLabelMapping>();
        }
        if ((migrated = this.myLabelMappingMigrations.get(labelMapping)) == null) {
            migrated = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
            this.myLabelMappingMigrations.put(labelMapping, migrated);
        }
        return migrated;
    }

    private Map<LabelMapping, FeatureLabelMapping> getSavedLabelMappingMigrations() {
        return this.myLabelMappingMigrations;
    }

    public void preResolve() {
        if (this.getSavedLabelMappingMigrations() == null) {
            return;
        }
        for (LabelMapping mapping : this.getSavedLabelMappingMigrations().keySet()) {
            MappingEntry entry;
            EList<LabelMapping> labelMappings;
            int originalIndex;
            FeatureLabelMapping migrated = this.getSavedLabelMappingMigrations().get(mapping);
            if (migrated.getFeatures().isEmpty() || (originalIndex = (labelMappings = (entry = mapping.getMapEntry()).getLabelMappings()).indexOf((Object)mapping)) == -1) continue;
            migrated.setDiagramLabel(mapping.getDiagramLabel());
            if (mapping.isReadOnly()) {
                migrated.setReadOnly(true);
            }
            labelMappings.set(originalIndex, (Object)migrated);
        }
    }
}

