/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramContextMenuProvider
extends ContextMenuProvider {
    private IWorkbenchPart part;
    private Set exclusionSet = new HashSet();
    private String[] defaultExclusionList = new String[]{"replaceWithMenu", "compareWithMenu", "ValidationAction", "team.main", "org.eclipse.jst.ws.atk.ui.webservice.category.popupMenu", "org.eclipse.tptp.platform.analysis.core.ui.internal.actions.MultiAnalysisActionDelegate", "org.eclipse.debug.ui.contextualLaunch.run.submenu", "org.eclipse.debug.ui.contextualLaunch.debug.submenu", "org.eclipse.debug.ui.contextualLaunch.profile.submenu"};

    public DiagramContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
        super(viewer);
        this.part = part;
        this.addDefaultExclusions();
    }

    public ActionRegistry getActionRegistry() {
        return (ActionRegistry)this.part.getAdapter(ActionRegistry.class);
    }

    public void buildContextMenu(IMenuManager menu) {
        this.getViewer().flush();
        try {
            TransactionUtil.getEditingDomain((EObject)((EObject)this.getViewer().getContents().getModel())).runExclusive(new Runnable(){

                public void run() {
                    ContributionItemService.getInstance().contributeToPopupMenu((IMenuManager)DiagramContextMenuProvider.this, DiagramContextMenuProvider.this.part);
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"buildContextMenu()", (Throwable)e);
        }
    }

    public Set getExclusionSet() {
        return this.exclusionSet;
    }

    public void setExclusionSet(Set exclusionSet) {
        this.exclusionSet = exclusionSet;
    }

    protected boolean allowItem(IContributionItem itemToAdd) {
        if (itemToAdd.getId() != null && this.exclusionSet.contains(itemToAdd.getId())) {
            itemToAdd.setVisible(false);
        }
        return super.allowItem(itemToAdd);
    }

    protected void addDefaultExclusions() {
        int i = 0;
        while (i < this.defaultExclusionList.length) {
            this.exclusionSet.add(this.defaultExclusionList[i]);
            ++i;
        }
    }
}

