/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelAccess;

public class BasicGenModelAccess
implements GenModelAccess {
    private final EPackage model;
    private GenModel genModel;
    private final List locations = new LinkedList();
    private boolean needUnload;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.genmodel.BasicGenModelAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BasicGenModelAccess(EPackage aModel) {
        this.model = aModel;
    }

    public void initDefault() {
        this.registerLocation(this.constructDefaultFromModel());
        this.registerLocation(this.fromExtpoint());
    }

    protected final URI fromExtpoint() {
        return this.fromExtpoint(this.model.getNsURI());
    }

    protected final URI fromExtpoint(String nsURI) {
        return (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(nsURI);
    }

    protected final URI constructDefaultFromModel() {
        if (this.model.eResource() == null || this.model.getNsURI() == null) {
            return null;
        }
        URI domainModelURI = this.model.eResource().getURI();
        if (this.model.getNsURI().equals(domainModelURI.toString())) {
            return null;
        }
        URI genModelURI = domainModelURI.trimFileExtension().appendFileExtension("genmodel");
        if (genModelURI.equals((Object)domainModelURI)) {
            return null;
        }
        return genModelURI;
    }

    protected final EPackage original() {
        return this.model;
    }

    public GenModel model() {
        return this.genModel;
    }

    public IStatus ensure() {
        IStatus loadStatus = this.load();
        if (loadStatus.isOK()) {
            return loadStatus;
        }
        return this.createDummy();
    }

    public IStatus load() {
        ResourceSetImpl rs = this.model.eResource() == null || this.model.eResource().getResourceSet() == null ? new ResourceSetImpl() : this.model.eResource().getResourceSet();
        return this.load((ResourceSet)rs);
    }

    public IStatus load(ResourceSet rs) {
        if (!$assertionsDisabled && this.locations.isEmpty()) {
            throw new AssertionError();
        }
        Iterator it = this.locations.iterator();
        while (it.hasNext()) {
            try {
                URI uri = (URI)it.next();
                Resource r = rs.getResource(uri, false);
                this.needUnload = r == null || !r.isLoaded();
                r = rs.getResource(uri, true);
                if (r == null) continue;
                this.genModel = (GenModel)r.getContents().get(0);
                return Status.OK_STATUS;
            }
            catch (WrappedException ex) {
                System.err.println(ex.getMessage());
            }
        }
        this.needUnload = false;
        return Status.CANCEL_STATUS;
    }

    public void unload() {
        if (this.needUnload && this.genModel != null) {
            this.genModel.eResource().unload();
            this.genModel = null;
        }
        this.needUnload = false;
    }

    public IStatus createDummy() {
        return this.createDummy(false, Collections.EMPTY_LIST);
    }

    public IStatus createDummy(boolean includeAllReferencedPackages, Collection additionalPackages) {
        String pluginID = "org.sample." + this.model.getName();
        this.genModel = GenModelFactory.eINSTANCE.createGenModel();
        if (includeAllReferencedPackages) {
            HashSet<EPackage> allPacks = new HashSet<EPackage>();
            allPacks.add(this.model);
            allPacks.addAll(additionalPackages);
            Map m = EcoreUtil.ExternalCrossReferencer.find((EObject)this.model);
            Iterator it = m.keySet().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof EClass)) continue;
                allPacks.add(((EClass)next).getEPackage());
            }
            this.genModel.initialize(allPacks);
        } else {
            this.genModel.initialize(Collections.singleton(this.model));
        }
        this.genModel.setModelName(String.valueOf(this.model.getName()) + "Gen");
        this.genModel.setModelPluginID(pluginID);
        this.genModel.setModelDirectory("/" + pluginID + "/src/");
        this.genModel.setEditDirectory(this.genModel.getModelDirectory());
        Resource r = new ResourceSetImpl().createResource(URI.createGenericURI((String)"uri", (String)pluginID, null));
        r.getContents().add((Object)this.genModel);
        Iterator it = this.genModel.getGenPackages().iterator();
        while (it.hasNext()) {
            GenPackage genPackage = (GenPackage)it.next();
            genPackage.setPrefix(String.valueOf(genPackage.getEcorePackage().getName()) + "Gen");
        }
        return Status.OK_STATUS;
    }

    public boolean hasLocations() {
        return this.locations != null && !this.locations.isEmpty();
    }

    protected void registerLocation(URI location) {
        if (location != null) {
            this.locations.add(location);
        }
    }

    protected void unregsiterLocation(URI location) {
        this.locations.remove(location);
    }
}

