/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorProvider {
    private static final String HIGHLIGHT_KEYWORDS = "hl_keywords";
    private static final String HIGHLIGHT_TERMINALS = "hl_terminals";
    private static final String HIGHLIGHT_DEFINE = "hl_define";
    private static final String HIGHLIGHT_STRING = "hl_string";
    private static final String HIGHLIGHT_TEXT = "hl_text";
    private static final String HIGHLIGHT_COMMENT = "hl_comment";
    private static final String HIGHLIGHT_OTHER = "hl_other";
    private final Map<RGB, Color> ivColorTable = new HashMap<RGB, Color>();
    private final IPreferenceStore preferenceStore;

    public ColorProvider(IPreferenceStore preferenceStore) {
        assert (preferenceStore != null);
        this.preferenceStore = preferenceStore;
    }

    public void initializeDefaults() {
        ColorProvider.initializeDefaultValues(this.preferenceStore);
    }

    public void dispose() {
        for (Color c : this.ivColorTable.values()) {
            c.dispose();
        }
    }

    protected Color getColor(RGB aRgb) {
        Color color = this.ivColorTable.get(aRgb);
        if (color == null) {
            color = this.createColor(aRgb);
            this.ivColorTable.put(aRgb, color);
        }
        return color;
    }

    protected Color createColor(RGB aColor) {
        return new Color((Device)Display.getCurrent(), aColor);
    }

    public Color getKeywordsColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_KEYWORDS));
    }

    public Color getTerminalsColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_TERMINALS));
    }

    public Color getDefineColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_DEFINE));
    }

    public Color getStringColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_STRING));
    }

    public Color getCommentColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_COMMENT));
    }

    public Color getOtherColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_OTHER));
    }

    public Color getTextColor() {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)HIGHLIGHT_TEXT));
    }

    public static final void initializeDefaultValues(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_KEYWORDS, (RGB)new RGB(127, 0, 85));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_TERMINALS, (RGB)new RGB(100, 100, 100));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_DEFINE, (RGB)new RGB(127, 0, 85));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_STRING, (RGB)new RGB(42, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_COMMENT, (RGB)new RGB(63, 127, 95));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_OTHER, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)HIGHLIGHT_TEXT, (RGB)new RGB(42, 0, 255));
    }
}

