/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.printpreview;

import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.HeaderAndFooterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.DiagramMapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PrintPreviewHelper {
    protected IPrintActionHelper printActionHelper;
    protected int userX = 0;
    protected int userY = 0;
    protected int numberOfRowsToDisplay = 2;
    protected int numberOfColumnsToDisplay = 2;
    protected DiagramEditPart diagramEditPart;
    protected Rectangle pageBreakBounds;
    protected Composite body;
    protected Composite composite;
    protected int buttonBarHeight;
    protected Shell shell;
    private Shell tempShell;
    protected ToolItem printTool;
    protected boolean enablePrinting = true;
    protected ToolItem pagesTool;
    protected ToolItem leftTool;
    protected ToolItem rightTool;
    protected ToolItem upTool;
    protected ToolItem downTool;
    protected ToolItem closeTool;
    private List imageList = new ArrayList();
    protected static final int BORDER_SIZE = 20;
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 124, 124, 124);
    protected Image printImage;
    protected Image disabledPrintImage;
    protected Image pageImage;
    protected Image leftImage;
    protected Image disabledLeftImage;
    protected Image rightImage;
    protected Image disabledRightImage;
    protected Image upImage;
    protected Image disabledUpImage;
    protected Image downImage;
    protected Image disabledDownImage;
    protected Image closeImage;
    protected double userScale = 1.0;
    private boolean fitToPage = false;
    private int[] zoomLevels = new int[]{25, 50, 75, 100, 150, 200, 250, 300, 400};
    private static final String FIT_TO_PAGES = DiagramUIPrintingMessages.PrintPreview_FitToPage_ButtonText;
    private static int MINIMUM_SCALE_FACTOR = 5;
    private IMapMode mm;

    protected void initializeToolbarImages() {
        this.printImage = DiagramUIPrintingPluginImages.DESC_PRINT.createImage();
        this.disabledPrintImage = DiagramUIPrintingPluginImages.DESC_PRINT_DISABLED.createImage();
        this.pageImage = DiagramUIPrintingPluginImages.DESC_PAGE.createImage();
        this.leftImage = DiagramUIPrintingPluginImages.DESC_LEFT.createImage();
        this.disabledLeftImage = DiagramUIPrintingPluginImages.DESC_LEFT_DISABLED.createImage();
        this.rightImage = DiagramUIPrintingPluginImages.DESC_RIGHT.createImage();
        this.disabledRightImage = DiagramUIPrintingPluginImages.DESC_RIGHT_DISABLED.createImage();
        this.upImage = DiagramUIPrintingPluginImages.DESC_UP.createImage();
        this.disabledUpImage = DiagramUIPrintingPluginImages.DESC_UP_DISABLED.createImage();
        this.downImage = DiagramUIPrintingPluginImages.DESC_DOWN.createImage();
        this.disabledDownImage = DiagramUIPrintingPluginImages.DESC_DOWN_DISABLED.createImage();
        this.closeImage = DiagramUIPrintingPluginImages.DESC_CLOSE.createImage();
    }

    public void enablePrinting(boolean enablePrinting) {
        this.enablePrinting = enablePrinting;
    }

    public void doPrintPreview(IPrintActionHelper prActionHelper) {
        this.printActionHelper = prActionHelper;
        if (!this.fitToPage) {
            this.setUserScale(PrintHelperUtil.getScale());
        }
        if (this.getDiagramEditorPart() == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DiagramUIPrintingMessages.PrintPreview_Title, (String)DiagramUIPrintingMessages.PrintPreview_NotEnabled);
            return;
        }
        if (!this.isPrinterInstalled()) {
            WindowUtil.doMessageBox((String)DiagramUIPrintingMessages.PrintPreview_NoPrinterInstalled, (String)DiagramUIPrintingMessages.PrintPreview_Title, (int)1, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            return;
        }
        this.initializeToolbarImages();
        this.initializeMapMode();
        this.diagramEditPart = null;
        this.pageBreakBounds = null;
        this.userX = 0;
        this.userY = 0;
        if (this.getTotalNumberOfRows() == 1 && this.getTotalNumberOfColumns() == 1) {
            this.numberOfRowsToDisplay = 1;
            this.numberOfColumnsToDisplay = 1;
        } else if (this.getTotalNumberOfRows() == 1) {
            this.numberOfRowsToDisplay = 1;
            this.numberOfColumnsToDisplay = 2;
        } else {
            this.numberOfRowsToDisplay = 2;
            this.numberOfColumnsToDisplay = 2;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
        this.shell = (style & 0x8000000) != 0 ? new Shell(display, 67176544) : new Shell(display, 67680);
        this.shell.setSize(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getSize());
        this.shell.setText(DiagramUIPrintingMessages.PrintPreview_Title);
        this.shell.setLocation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getLocation());
        this.shell.setLayout((Layout)new GridLayout(1, true));
        ToolBar bar = new ToolBar((Composite)this.shell, 0x800100);
        this.printTool = new ToolItem(bar, 0);
        this.printTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_PrintToolItem);
        this.printTool.setImage(this.printImage);
        this.printTool.setDisabledImage(this.disabledPrintImage);
        this.printTool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Assert.isNotNull((Object)PrintPreviewHelper.this.printActionHelper);
                PrintPreviewHelper.this.printActionHelper.doPrint(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
                PrintPreviewHelper.this.shell.setActive();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.printActionHelper == null || !this.enablePrinting) {
            this.printTool.setEnabled(false);
        }
        new ToolItem(bar, 2);
        this.pagesTool = new ToolItem(bar, 4);
        this.pagesTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_PagesToolItem);
        this.pagesTool.setImage(this.pageImage);
        this.pagesTool.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Menu menu = null;

            private void updatePreview(int newNumberOfColumnsToDisplay, int newNumberOfRowsToDisplay) {
                PrintPreviewHelper.this.numberOfRowsToDisplay = newNumberOfRowsToDisplay;
                PrintPreviewHelper.this.numberOfColumnsToDisplay = newNumberOfColumnsToDisplay;
                if (PrintPreviewHelper.this.userX + PrintPreviewHelper.this.numberOfColumnsToDisplay > PrintPreviewHelper.this.getTotalNumberOfColumns()) {
                    PrintPreviewHelper.this.userX = PrintPreviewHelper.this.getTotalNumberOfColumns() - PrintPreviewHelper.this.numberOfColumnsToDisplay;
                    if (PrintPreviewHelper.this.userX < 0) {
                        PrintPreviewHelper.this.userX = 0;
                    }
                }
                if (PrintPreviewHelper.this.userY + PrintPreviewHelper.this.numberOfRowsToDisplay > PrintPreviewHelper.this.getTotalNumberOfRows()) {
                    PrintPreviewHelper.this.userY = PrintPreviewHelper.this.getTotalNumberOfRows() - PrintPreviewHelper.this.numberOfRowsToDisplay;
                    if (PrintPreviewHelper.this.userY < 0) {
                        PrintPreviewHelper.this.userY = 0;
                    }
                }
                PrintPreviewHelper.this.refreshComposite();
            }

            public void widgetSelected(SelectionEvent event) {
                if (this.menu == null) {
                    this.menu = new Menu((Control)PrintPreviewHelper.this.shell);
                    MenuItem menuItem = new MenuItem(this.menu, 0);
                    menuItem.setText(DiagramUIPrintingMessages.PrintPreview_1Up);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            this.updatePreview(1, 1);
                        }
                    });
                    menuItem = new MenuItem(this.menu, 0);
                    menuItem.setText(DiagramUIPrintingMessages.PrintPreview_2Up);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            this.updatePreview(2, 1);
                        }
                    });
                    menuItem = new MenuItem(this.menu, 0);
                    menuItem.setText(DiagramUIPrintingMessages.PrintPreview_4Up);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            this.updatePreview(2, 2);
                        }
                    });
                }
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar toolBar = toolItem.getParent();
                org.eclipse.swt.graphics.Rectangle toolItemBounds = toolItem.getBounds();
                org.eclipse.swt.graphics.Point point = toolBar.toDisplay(new org.eclipse.swt.graphics.Point(toolItemBounds.x, toolItemBounds.y));
                this.menu.setLocation(point.x, point.y + toolItemBounds.height);
                this.setMenuVisible(true);
            }

            private void setMenuVisible(boolean visible) {
                this.menu.setVisible(visible);
            }
        });
        new ToolItem(bar, 2);
        this.leftTool = new ToolItem(bar, 0);
        if ((style & 0x8000000) != 0) {
            this.leftTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_RightToolItem);
            this.leftTool.setImage(this.rightImage);
            this.leftTool.setDisabledImage(this.disabledRightImage);
        } else {
            this.leftTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_LeftToolItem);
            this.leftTool.setImage(this.leftImage);
            this.leftTool.setDisabledImage(this.disabledLeftImage);
        }
        this.leftTool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PrintPreviewHelper.this.userX > 0) {
                    --PrintPreviewHelper.this.userX;
                    PrintPreviewHelper.this.refreshComposite();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.rightTool = new ToolItem(bar, 0);
        if ((style & 0x8000000) != 0) {
            this.rightTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_LeftToolItem);
            this.rightTool.setImage(this.leftImage);
            this.rightTool.setDisabledImage(this.disabledLeftImage);
        } else {
            this.rightTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_RightToolItem);
            this.rightTool.setImage(this.rightImage);
            this.rightTool.setDisabledImage(this.disabledRightImage);
        }
        this.rightTool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PrintPreviewHelper.this.userX + PrintPreviewHelper.this.numberOfColumnsToDisplay + 1 <= PrintPreviewHelper.this.getTotalNumberOfColumns()) {
                    ++PrintPreviewHelper.this.userX;
                    PrintPreviewHelper.this.refreshComposite();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.upTool = new ToolItem(bar, 0);
        this.upTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_UpToolItem);
        this.upTool.setImage(this.upImage);
        this.upTool.setDisabledImage(this.disabledUpImage);
        this.upTool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PrintPreviewHelper.this.userY > 0) {
                    --PrintPreviewHelper.this.userY;
                    PrintPreviewHelper.this.refreshComposite();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.downTool = new ToolItem(bar, 0);
        this.downTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_DownToolItem);
        this.downTool.setImage(this.downImage);
        this.downTool.setDisabledImage(this.disabledDownImage);
        this.downTool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PrintPreviewHelper.this.userY + PrintPreviewHelper.this.numberOfRowsToDisplay + 1 <= PrintPreviewHelper.this.getTotalNumberOfRows()) {
                    ++PrintPreviewHelper.this.userY;
                    PrintPreviewHelper.this.refreshComposite();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new ToolItem(bar, 2);
        ToolItem separator = new ToolItem(bar, 2);
        Combo zoomCombo = new Combo((Composite)bar, 4);
        zoomCombo.add(FIT_TO_PAGES);
        int i = 0;
        while (i < this.zoomLevels.length) {
            zoomCombo.add(this.getDisplayScale(this.zoomLevels[i]));
            ++i;
        }
        if (this.fitToPage) {
            zoomCombo.setText(FIT_TO_PAGES);
            zoomCombo.select(0);
        } else {
            zoomCombo.setText(this.getDisplayScale(PrintHelperUtil.getScale()));
        }
        zoomCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void doZoom(Combo combo) {
                String scaleFactor = combo.getText();
                int percentageIndex = scaleFactor.indexOf("%");
                if (percentageIndex > 0) {
                    scaleFactor = scaleFactor.substring(0, percentageIndex);
                }
                int scalePercentage = PrintHelperUtil.getScale();
                try {
                    scalePercentage = Integer.parseInt(scaleFactor);
                }
                catch (NumberFormatException numberFormatException) {}
                if (scalePercentage < MINIMUM_SCALE_FACTOR) {
                    scalePercentage = MINIMUM_SCALE_FACTOR;
                }
                PrintPreviewHelper.this.setPercentScaling(scalePercentage);
                PrintPreviewHelper.this.refreshComposite();
                combo.setText(PrintPreviewHelper.this.getDisplayScale(scalePercentage));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.doZoom((Combo)e.getSource());
            }

            public void widgetSelected(SelectionEvent e) {
                String selectedString = ((Combo)e.getSource()).getText();
                if (FIT_TO_PAGES.compareToIgnoreCase(selectedString) == 0) {
                    FitToPagesDialog fitToPages = new FitToPagesDialog(PrintPreviewHelper.this.shell);
                    if (fitToPages.open() == 0) {
                        int pagesWide = fitToPages.getPagesWide();
                        int pagesTall = fitToPages.getPagesTall();
                        PrintHelperUtil.setScaleToWidth(pagesWide);
                        PrintHelperUtil.setScaleToHeight(pagesTall);
                        PrintPreviewHelper.this.setFitToPage(pagesWide, pagesTall);
                        PrintPreviewHelper.this.refreshComposite();
                    }
                } else {
                    this.doZoom((Combo)e.getSource());
                }
            }
        });
        zoomCombo.pack();
        separator.setWidth(zoomCombo.getSize().x);
        separator.setControl((Control)zoomCombo);
        new ToolItem(bar, 2);
        this.closeTool = new ToolItem(bar, 0);
        this.closeTool.setToolTipText(DiagramUIPrintingMessages.PrintPreview_CloseToolItem);
        this.closeTool.setImage(this.closeImage);
        this.closeTool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrintPreviewHelper.this.dispose();
                PrintPreviewHelper.this.shell.close();
                PrintPreviewHelper.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonBarHeight = bar.getBounds().height - bar.getBounds().y;
        bar.setBounds(0, 0, this.shell.getSize().x, this.buttonBarHeight);
        this.body = new Composite((Composite)this.shell, 0);
        this.body.setLayout((Layout)new GridLayout(1, true));
        this.body.setLayoutData((Object)new GridData(1808));
        this.body.setBackground(BACKGROUND_COLOR);
        this.composite = new Composite(this.body, 0);
        this.composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.refreshComposite();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.dispose();
        this.shell.dispose();
    }

    protected IMapMode getMapMode() {
        return this.mm;
    }

    private void initializeMapMode() {
        RootEditPart rootEP;
        DiagramEditor diagramEditor = this.getDiagramEditorPart();
        assert (diagramEditor != null);
        IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
        if (viewer != null && (rootEP = viewer.getRootEditPart()) instanceof DiagramRootEditPart) {
            this.mm = ((DiagramRootEditPart)rootEP).getMapMode();
            return;
        }
        this.mm = MapModeUtil.getMapMode();
    }

    private int getTotalNumberOfRows() {
        float numRows = (float)((double)this.getBounds().height * this.userScale) / (float)PageInfoHelper.getPageSize((IPreferenceStore)this.getPreferenceStore(), (boolean)true, (IMapMode)this.getMapMode()).y;
        return Math.max(1, (int)Math.ceil(numRows));
    }

    private DiagramEditor getDiagramEditorPart() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        DiagramEditor diagramEditorPart = (DiagramEditor)editorPart;
        return diagramEditorPart;
    }

    protected Rectangle getDiagramBounds() {
        return PageInfoHelper.getChildrenBounds((DiagramEditPart)this.getDiagramEditPart(), null);
    }

    protected Rectangle getPageBreakBounds() {
        if (this.pageBreakBounds == null) {
            this.pageBreakBounds = PrintHelperUtil.getPageBreakBounds(this.getDiagramEditPart(), true).getCopy();
        }
        return this.pageBreakBounds;
    }

    protected Rectangle getBounds() {
        return this.getPageBreakBounds() == null ? this.getDiagramBounds() : this.getPageBreakBounds();
    }

    protected DiagramEditPart getDiagramEditPart() {
        if (this.diagramEditPart == null) {
            this.diagramEditPart = this.getDiagramEditorPart().getDiagramEditPart();
        }
        if (this.diagramEditPart == null) {
            Diagram diagram = this.getDiagramEditorPart().getDiagram();
            PreferencesHint preferencesHint = this.getPreferencesHint((IEditorPart)this.getDiagramEditorPart());
            this.diagramEditPart = PrintHelperUtil.createDiagramEditPart(diagram, preferencesHint, this.getTempShell());
            PrintHelperUtil.initializePreferences(this.diagramEditPart, preferencesHint);
        }
        return this.diagramEditPart;
    }

    private Shell getTempShell() {
        if (this.tempShell == null) {
            this.tempShell = new Shell();
        }
        return this.tempShell;
    }

    protected PreferencesHint getPreferencesHint(IEditorPart editorPart) {
        RootEditPart rootEP;
        if (editorPart instanceof IDiagramWorkbenchPart && (rootEP = ((IDiagramWorkbenchPart)editorPart).getDiagramGraphicalViewer().getRootEditPart()) instanceof IDiagramPreferenceSupport) {
            return ((IDiagramPreferenceSupport)rootEP).getPreferencesHint();
        }
        return PreferencesHint.USE_DEFAULTS;
    }

    private int getTotalNumberOfColumns() {
        float numCols = (float)((double)this.getBounds().width * this.userScale) / (float)PageInfoHelper.getPageSize((IPreferenceStore)this.getPreferenceStore(), (boolean)true, (IMapMode)this.getMapMode()).x;
        return Math.max(1, (int)Math.ceil(numCols));
    }

    protected boolean isPrinterInstalled() {
        try {
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
            return printServices.length > 0;
        }
        catch (SWTError e) {
            Trace.catching((Plugin)DiagramPrintingPlugin.getInstance(), (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, PrintPreviewHelper.class, (String)"isPrinterInstalled", (Throwable)e);
            if (e.code == 2) {
                return false;
            }
            Log.error((Plugin)DiagramPrintingPlugin.getInstance(), (int)6, (String)"Failed to make instance of Printer object", (Throwable)e);
            Trace.throwing((Plugin)DiagramPrintingPlugin.getInstance(), (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, PrintPreviewHelper.class, (String)"isPrinterInstalled", (Throwable)e);
            throw e;
        }
    }

    private void disposeImages() {
        while (this.imageList.size() > 0) {
            Assert.isTrue((boolean)(this.imageList.get(0) instanceof Image));
            if (!((Image)this.imageList.get(0)).isDisposed()) {
                ((Image)this.imageList.get(0)).dispose();
            }
            this.imageList.remove(0);
        }
    }

    private void refreshComposite() {
        this.updateCompositeForNumberOfColumns(this.numberOfRowsToDisplay, this.numberOfColumnsToDisplay);
        this.updateLeftRightUpDownButtonsForToolbar();
    }

    private void updateCompositeForNumberOfColumns(int numberOfRows, int numberOfColumns) {
        Assert.isNotNull((Object)this.shell);
        Assert.isNotNull((Object)this.composite);
        WindowUtil.disposeChildren((Composite)this.composite);
        this.disposeImages();
        this.composite.setLayout(null);
        this.composite.pack();
        this.composite.setLayout((Layout)new GridLayout(numberOfColumns, true));
        int imageHeight = (this.shell.getSize().y - this.buttonBarHeight - 20 - 20 - 20 - (numberOfRows - 1) * 20) / numberOfRows;
        int imageWidth = (this.shell.getSize().x - 20 - 20 - (numberOfColumns - 1) * 20) / numberOfColumns;
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)this.getPreferenceStore(), (boolean)false, (IMapMode)this.getMapMode());
        Assert.isNotNull((Object)pageSize);
        float printerRatio = (float)pageSize.x / (float)pageSize.y;
        if ((float)imageHeight * printerRatio < (float)imageWidth) {
            imageWidth = (int)((float)imageHeight * printerRatio);
        } else if ((float)imageWidth * (1.0f / printerRatio) < (float)imageHeight) {
            imageHeight = (int)((float)imageWidth * (1.0f / printerRatio));
        }
        PageInfoHelper.PageMargins margins = PageInfoHelper.getPageMargins((IPreferenceStore)this.getPreferenceStore(), (IMapMode)this.getMapMode());
        if (imageHeight > 4 && imageWidth > 4) {
            float scale = (float)imageHeight / (float)pageSize.y / (float)DiagramMapModeUtil.getScale((IMapMode)this.getMapMode());
            scale = (float)((double)scale * this.userScale);
            margins.left = (int)((double)margins.left / this.userScale);
            margins.right = (int)((double)margins.right / this.userScale);
            margins.bottom = (int)((double)margins.bottom / this.userScale);
            margins.top = (int)((double)margins.top / this.userScale);
            int i = 0;
            while (i < numberOfRows) {
                int j = 0;
                while (j < numberOfColumns) {
                    Label label = new Label(this.composite, 0);
                    Image pageImg = this.makeImage(imageWidth, imageHeight, i, j, scale, margins);
                    label.setImage(pageImg);
                    this.imageList.add(pageImg);
                    ++j;
                }
                ++i;
            }
        }
        this.composite.pack();
        org.eclipse.swt.graphics.Rectangle compositeBounds = this.composite.getBounds();
        compositeBounds.x = (this.shell.getSize().x - 20 - compositeBounds.width) / 2;
        compositeBounds.y = (this.shell.getSize().y - this.buttonBarHeight - 20 - 20 - 20 - compositeBounds.height) / 2;
        this.composite.setBounds(compositeBounds);
    }

    protected void updateLeftRightUpDownButtonsForToolbar() {
        if (this.userX == 0) {
            this.leftTool.setEnabled(false);
        } else {
            this.leftTool.setEnabled(true);
        }
        if (this.userX + this.numberOfColumnsToDisplay + 1 > this.getTotalNumberOfColumns()) {
            this.rightTool.setEnabled(false);
        } else {
            this.rightTool.setEnabled(true);
        }
        if (this.userY == 0) {
            this.upTool.setEnabled(false);
        } else {
            this.upTool.setEnabled(true);
        }
        if (this.userY + this.numberOfRowsToDisplay + 1 > this.getTotalNumberOfRows()) {
            this.downTool.setEnabled(false);
        } else {
            this.downTool.setEnabled(true);
        }
    }

    protected Image makeImage(int imageWidth, int imageHeight, int row, int col, float scale, PageInfoHelper.PageMargins margins) {
        Image image = new Image((Device)this.shell.getDisplay(), imageWidth, imageHeight);
        GC gc = null;
        gc = (this.shell.getStyle() & 0x8000000) != 0 ? new GC((Drawable)image, 0x4000000) : new GC((Drawable)image);
        SWTGraphics sg = new SWTGraphics(gc);
        ScaledGraphics g1 = new ScaledGraphics((Graphics)sg);
        MapModeGraphics mmg = this.createMapModeGraphics(g1);
        gc.setFont(mmg.getFont());
        this.drawPage((Graphics)mmg, gc, scale, row, col, margins);
        gc.dispose();
        return image;
    }

    protected void drawPage(Graphics g, GC gc, float scale, int row, int col, PageInfoHelper.PageMargins margins) {
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)this.getPreferenceStore(), (boolean)false, (IMapMode)this.getMapMode());
        g.pushState();
        Rectangle bounds = this.getBounds();
        if (PrintHelperUtil.getScaleToWidth() == 1 && PrintHelperUtil.getScaleToHeight() == 1 && this.fitToPage) {
            bounds = this.getDiagramEditPart().getChildrenBounds();
        }
        int scaledPageSizeWidth = (int)((double)pageSize.x / this.userScale);
        int scaledPageSizeHeight = (int)((double)pageSize.y / this.userScale);
        int translateX = -bounds.x - scaledPageSizeWidth * (col + this.userX) + margins.left * (col + this.userX + 1) + margins.right * (col + this.userX);
        int translateY = -bounds.y - scaledPageSizeHeight * (row + this.userY) + margins.top * (row + this.userY + 1) + margins.bottom * (row + this.userY);
        if (this.doesPageExist(1 + this.userX + col, 1 + this.userY + row)) {
            g.pushState();
            g.scale((double)scale);
            String headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("header", 1 + this.userY + row, 1 + this.userX + col, this.getDiagramEditPart());
            g.drawText(headerOrFooter, (pageSize.x - this.getMapMode().DPtoLP(gc.textExtent((String)headerOrFooter).x)) / 2, this.getMapMode().DPtoLP(5));
            headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("footer", 1 + this.userY + row, 1 + this.userX + col, this.getDiagramEditPart());
            g.drawText(headerOrFooter, (pageSize.x - this.getMapMode().DPtoLP(gc.textExtent((String)headerOrFooter).x)) / 2, pageSize.y - this.getMapMode().DPtoLP(20));
            g.popState();
        }
        g.scale((double)scale);
        g.translate(translateX, translateY);
        Rectangle clip = new Rectangle((scaledPageSizeWidth - margins.left - margins.right) * (col + this.userX) + bounds.x, (scaledPageSizeHeight - margins.top - margins.bottom) * (row + this.userY) + bounds.y, scaledPageSizeWidth - margins.left - margins.right, scaledPageSizeHeight - margins.top - margins.bottom);
        g.clipRect(clip);
        this.getDiagramEditPart().getLayer((Object)"Printable Layers").paint(g);
        g.popState();
    }

    private boolean doesPageExist(int x, int y) {
        return x > 0 && y > 0 && x <= this.getTotalNumberOfColumns() && y <= this.getTotalNumberOfRows();
    }

    private void safeDisposeImage(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    protected void dispose() {
        this.disposeImages();
        this.safeDisposeImage(this.printImage);
        this.safeDisposeImage(this.disabledPrintImage);
        this.safeDisposeImage(this.pageImage);
        this.safeDisposeImage(this.leftImage);
        this.safeDisposeImage(this.disabledLeftImage);
        this.safeDisposeImage(this.rightImage);
        this.safeDisposeImage(this.disabledRightImage);
        this.safeDisposeImage(this.upImage);
        this.safeDisposeImage(this.disabledUpImage);
        this.safeDisposeImage(this.downImage);
        this.safeDisposeImage(this.disabledDownImage);
        this.safeDisposeImage(this.closeImage);
        if (this.tempShell != null) {
            this.tempShell.dispose();
            this.tempShell = null;
        }
    }

    private IPreferenceStore getWorkspaceViewerPreferenceStore() {
        assert (this.getDiagramEditPart().getViewer() instanceof DiagramGraphicalViewer);
        return ((DiagramGraphicalViewer)this.getDiagramEditPart().getViewer()).getWorkspaceViewerPreferenceStore();
    }

    private IPreferenceStore getGlobalPreferenceStore() {
        return (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
    }

    private IPreferenceStore getPreferenceStore() {
        if (this.getWorkspaceViewerPreferenceStore().getBoolean("print.useWorkspaceSettings")) {
            return this.getGlobalPreferenceStore();
        }
        return this.getWorkspaceViewerPreferenceStore();
    }

    protected MapModeGraphics createMapModeGraphics(ScaledGraphics scaledGraphics) {
        return new MapModeGraphics((Graphics)scaledGraphics, this.getMapMode());
    }

    private void setUserScale(int scale) {
        this.userScale = (float)scale / 100.0f;
        PrintHelperUtil.setScale(scale);
    }

    private String getDisplayScale(int scale) {
        return String.valueOf(String.valueOf(scale)) + "%";
    }

    protected Point getPageCount(DiagramEditPart dgrmEP, Rectangle figureBounds, Point pageSize, boolean applyUserScale) {
        RootEditPart rootEditPart = dgrmEP.getRoot();
        if (rootEditPart instanceof DiagramRootEditPart) {
            DiagramRootEditPart diagramRootEditPart = (DiagramRootEditPart)rootEditPart;
            PageBreakEditPart pageBreakEditPart = diagramRootEditPart.getPageBreakEditPart();
            double fNumCols = (double)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().y * (applyUserScale ? this.userScale : 1.0);
            double fNumRows = (double)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().x * (applyUserScale ? this.userScale : 1.0);
            int numCols = (int)Math.ceil(fNumCols);
            int numRows = (int)Math.ceil(fNumRows);
            return new Point(numCols, numRows);
        }
        double fNumRows = (double)figureBounds.height * (applyUserScale ? this.userScale : 1.0) / (double)pageSize.y;
        int numRows = (int)Math.ceil(fNumRows);
        double fNumCols = (double)figureBounds.width * (applyUserScale ? this.userScale : 1.0) / (double)pageSize.x;
        int numCols = (int)Math.ceil(fNumCols);
        return new Point(numCols, numRows);
    }

    public void setPercentScaling(int userScale) {
        this.fitToPage = false;
        this.setUserScale(userScale);
    }

    public void setFitToPage(int width, int height) {
        this.fitToPage = true;
        this.initializeMapMode();
        Rectangle figureBounds = PrintHelperUtil.getPageBreakBounds(this.getDiagramEditPart(), true);
        Point pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)this.getPreferenceStore(), (IMapMode)this.getMapMode());
        Point pageCount = this.getPageCount(this.getDiagramEditPart(), figureBounds, pageBounds, false);
        int numCols = pageCount.x;
        int numRows = pageCount.y;
        float actualWidth = 0.0f;
        float actualHeight = 0.0f;
        if (height == 1 && width == 1) {
            figureBounds = this.getDiagramEditPart().getChildrenBounds();
            actualWidth = figureBounds.width;
            actualHeight = figureBounds.height;
        } else {
            actualWidth = numCols * pageBounds.x;
            actualHeight = numRows * pageBounds.y;
        }
        int totalHeight = height * pageBounds.y;
        int totalWidth = width * pageBounds.x;
        int vScale = (int)((float)(totalHeight * 100) / actualHeight);
        int hScale = (int)((float)(totalWidth * 100) / actualWidth);
        this.userScale = (float)Math.min(hScale, vScale) / 100.0f;
    }

    private class FitToPagesDialog
    extends Dialog {
        private Text textWide;
        private Text textTall;
        private int pagesWide;
        private int pagesTall;

        public FitToPagesDialog(Shell parent) {
            super(parent);
            this.pagesWide = PrintHelperUtil.getScaleToWidth();
            this.pagesTall = PrintHelperUtil.getScaleToHeight();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(DiagramUIPrintingMessages.PrintPreview_FitToPage_DialogTitle);
        }

        Label label(Composite parent, String text) {
            Label result = new Label(parent, 0);
            result.setText(text);
            return result;
        }

        GridData getLayoutData(Control control) {
            GridData result = (GridData)control.getLayoutData();
            if (result == null) {
                result = new GridData();
                control.setLayoutData((Object)result);
            }
            return result;
        }

        Control layoutHorizontalIndent(Control control, int inset) {
            GridData data = this.getLayoutData(control);
            data.horizontalIndent = inset;
            return control;
        }

        Control layoutAlignRight(Control control) {
            GridData data = this.getLayoutData(control);
            data.horizontalAlignment = 0x1000008;
            data.grabExcessHorizontalSpace = false;
            return control;
        }

        Control layoutWidth(Control control, int dlus) {
            if (dlus > 0) {
                GridData data = this.getLayoutData(control);
                data.widthHint = this.convertHorizontalDLUsToPixels(dlus);
            }
            return control;
        }

        Control layoutFillHorizontal(Control control, boolean grab) {
            GridData data = this.getLayoutData(control);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = grab;
            return control;
        }

        Text text(Composite parent, int width) {
            Text result = new Text(parent, 2052);
            this.layoutFillHorizontal((Control)result, false);
            this.layoutWidth((Control)result, width);
            return result;
        }

        Control layoutFillBoth(Control control) {
            GridData data = this.getLayoutData(control);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            return control;
        }

        Group group(Composite parent, String text) {
            Group result = new Group(parent, 0);
            result.setText(text);
            this.layoutFillBoth((Control)result);
            return result;
        }

        Composite layout(Composite composite, int columns) {
            GridLayout g = new GridLayout(columns, false);
            g.marginLeft = 6;
            g.marginRight = 6;
            g.marginTop = 6;
            g.marginBottom = 3;
            composite.setLayout((Layout)g);
            return composite;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.layout(composite, 1);
            Group scaleGroup = this.group(composite, DiagramUIPrintingMessages.JPSPrintDialog_Scaling);
            this.layout((Composite)scaleGroup, 5);
            this.layoutHorizontalIndent(this.layoutAlignRight((Control)this.label((Composite)scaleGroup, DiagramUIPrintingMessages.JPSPrintDialog_PagesWide)), 15);
            this.textWide = this.text((Composite)scaleGroup, 20);
            this.textWide.setText(String.valueOf(PrintHelperUtil.getScaleToWidth()));
            this.layoutHorizontalIndent(this.layoutAlignRight((Control)this.label((Composite)scaleGroup, DiagramUIPrintingMessages.JPSPrintDialog_PagesTall)), 15);
            this.textTall = this.text((Composite)scaleGroup, 20);
            this.textTall.setText(String.valueOf(PrintHelperUtil.getScaleToHeight()));
            return composite;
        }

        public int getPagesWide() {
            return this.pagesWide;
        }

        public int getPagesTall() {
            return this.pagesTall;
        }

        protected void okPressed() {
            try {
                this.pagesWide = Integer.parseInt(this.textWide.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pagesWide < 1) {
                this.pagesWide = 1;
            }
            try {
                this.pagesTall = Integer.parseInt(this.textTall.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pagesTall < 1) {
                this.pagesTall = 1;
            }
            super.okPressed();
        }
    }
}

