/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class NoteFigure
extends DefaultSizeNodeFigure
implements IPolygonAnchorableFigure {
    private boolean diagrsamLinkMode = false;
    private boolean withDanglingCorner = true;
    public static final int CLIP_HEIGHT_DP = 12;
    public static final int MARGIN_DP = 5;
    public static final int CLIP_MARGIN_DP = 14;

    public NoteFigure(int width, int height, Insets insets) {
        super(width, height);
        this.setBorder((Border)new MarginBorder(insets.top, insets.left, insets.bottom, insets.right));
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
        layout.setMinorAlignment(1);
        layout.setSpacing(insets.top);
        this.setLayoutManager((LayoutManager)layout);
    }

    private int getClipHeight() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(12);
    }

    private int getClipWidth() {
        return this.getClipHeight() + MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
    }

    protected PointList getPointList(Rectangle r) {
        PointList p = new PointList();
        p.addPoint(r.x, r.y);
        if (!this.isDiagramLinkMode()) {
            p.addPoint(r.x + r.width - this.getClipWidth(), r.y);
            p.addPoint(r.x + r.width - 1, r.y + this.getClipHeight());
        } else {
            p.addPoint(r.x + r.width - 1, r.y);
        }
        p.addPoint(r.x + r.width - 1, r.y + r.height - 1);
        p.addPoint(r.x, r.y + r.height - 1);
        p.addPoint(r.x, r.y);
        return p;
    }

    protected void paintBorder(Graphics g) {
        if (!this.isDiagramLinkMode()) {
            Rectangle r = this.getBounds().getCopy();
            r.shrink(this.getLineWidth() / 2, this.getLineWidth() / 2);
            PointList p = this.getPointList(r);
            g.setLineWidth(this.getLineWidth());
            g.setLineStyle(this.getLineStyle());
            g.drawPolyline(p);
            if (this.withDanglingCorner) {
                PointList corner = new PointList();
                corner.addPoint(r.x + r.width - this.getClipWidth(), r.y);
                corner.addPoint(r.x + r.width - this.getClipWidth(), r.y + this.getClipHeight());
                corner.addPoint(r.x + r.width, r.y + this.getClipHeight());
                g.drawPolyline(corner);
            }
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = this.getBounds();
        PointList p = this.getPointList(r);
        g.fillPolygon(p);
    }

    public boolean setDiagramLinkMode(boolean diagramLinkMode) {
        boolean bOldDiagramLinkMode = this.diagrsamLinkMode;
        ConstrainedToolbarLayout layout = (ConstrainedToolbarLayout)this.getLayoutManager();
        if (diagramLinkMode) {
            layout.setMinorAlignment(0);
        } else {
            layout.setMinorAlignment(1);
        }
        this.diagrsamLinkMode = diagramLinkMode;
        return bOldDiagramLinkMode;
    }

    public boolean isDiagramLinkMode() {
        return this.diagrsamLinkMode;
    }

    public PointList getPolygonPoints() {
        return this.getPointList(this.getBounds());
    }
}

