/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;

class DumpEvaluationListener
extends EvaluationListener {
    private final StringBuilder sb = new StringBuilder(100);
    private int stmtCount = 0;

    DumpEvaluationListener() {
    }

    public void enter(Statement stmt, ExecutionContext context) {
        this.print(stmt.getClass().getSimpleName(), this.stmtCount++, stmt.getLine());
        this.sb.append(' ');
    }

    public void leave(Statement stmt, ExecutionContext context) {
        this.sb.setLength(this.sb.length() - 1);
        this.print(stmt.getClass().getSimpleName(), --this.stmtCount, stmt.getLine());
    }

    private void print(String x, int i, int line) {
        System.err.println(String.valueOf(this.sb.toString()) + x + i + ':' + line);
    }
}

