/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.gmf.internal.xpand.codeassist.ProposalFactoryImpl;
import org.eclipse.gmf.internal.xpand.codeassist.StatementProposalComputer;
import org.eclipse.gmf.internal.xpand.editor.Activator;
import org.eclipse.gmf.internal.xpand.editor.EditorImages;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementProposalComputerTest
extends TestCase {
    private ProposalFactoryImpl f;
    private StatementProposalComputer kpc;

    protected void setUp() throws Exception {
        if (Activator.getDefault() == null) {
            new Activator();
        }
        this.f = new ProposalFactoryImpl(100, 0, new EditorImages(){

            protected Image imageFromPath(String path) {
                return null;
            }
        });
        this.kpc = new StatementProposalComputer((ProposalFactory)this.f);
        super.setUp();
    }

    public final void testComputeProposals1() {
        String txt = String.valueOf(StatementProposalComputerTest.tag("DEFINE test FOR this")) + "  ";
        List p = this.kpc.computeProposals(txt, null);
        StatementProposalComputerTest.assertTrue((boolean)((ICompletionProposal)p.get(0)).getDisplayString().startsWith("ENDDEFINE"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "ELSE"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "ELSEIF"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "FILE"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "PROTECT"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "IF"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "LET"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "FOREACH"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "EXPAND"));
    }

    public final void testComputeProposals2() {
        String txt = String.valueOf(StatementProposalComputerTest.tag("DEFINE test FOR this")) + "  " + StatementProposalComputerTest.tag("FILE test") + StatementProposalComputerTest.tag("IF x");
        List p = this.kpc.computeProposals(txt, null);
        StatementProposalComputerTest.assertTrue((boolean)((ICompletionProposal)p.get(0)).getDisplayString().startsWith("ENDIF"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "ELSE"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "ELSEIF"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "FILE"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "PROTECT"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "IF"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "LET"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "FOREACH"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "EXPAND"));
    }

    public final void testComputeProposals3() {
        String txt = String.valueOf(StatementProposalComputerTest.tag("DEFINE test FOR this")) + "  " + StatementProposalComputerTest.tag("FILE test") + StatementProposalComputerTest.tag("IF x") + StatementProposalComputerTest.tag("ENDIF") + StatementProposalComputerTest.tag("ENDFILE") + StatementProposalComputerTest.tag("PROTECT CSTART x CEND y ENABLED");
        List p = this.kpc.computeProposals(txt, null);
        StatementProposalComputerTest.assertTrue((boolean)((ICompletionProposal)p.get(0)).getDisplayString().startsWith("ENDPROTECT"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "ELSE"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "ELSEIF"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "FILE"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "PROTECT"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "IF"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "LET"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "FOREACH"));
        StatementProposalComputerTest.assertTrue((boolean)StatementProposalComputerTest.contains(p, "EXPAND"));
    }

    public final void testComputeProposals4() {
        String txt = String.valueOf(StatementProposalComputerTest.tag("IMPORT xyz")) + "  ";
        List p = this.kpc.computeProposals(txt, null);
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "DEFINE"));
        StatementProposalComputerTest.assertFalse((boolean)StatementProposalComputerTest.contains(p, "AROUND"));
        StatementProposalComputerTest.assertEquals((int)4, (int)p.size());
    }

    private static boolean contains(List<ICompletionProposal> proposals, String keyword) {
        for (ICompletionProposal element : proposals) {
            if (!element.getDisplayString().startsWith(keyword)) continue;
            return true;
        }
        return false;
    }

    private static String tag(String txt) {
        return "\u00ab" + txt + "\u00bb";
    }
}

