/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.internal.bridge.transform.GenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.common.URIUtil;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.ToolDefSource;

public class TransformToGenModelOperationTest
extends ConfiguredTestCase {
    private static String FOLDER_MODELS = "models";
    private static String FILE_BASE = "test";
    private static String FILE_EXT_ECORE = "ecore";
    private static String FILE_EXT_GMFGEN = "gmfgen";
    private static String FILE_EXT_GMFGRAPH = "gmfgraph";
    private static String FILE_EXT_GMFMAP = "gmfmap";
    private static String FILE_EXT_GMFTOOL = "gmftool";
    private IProject myProject;
    private TransformToGenModelOperation myOperation;

    public TransformToGenModelOperationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myOperation = new TransformToGenModelOperation((ResourceSet)new ResourceSetImpl());
        this.myProject = this.createProject();
        IFolder models = this.myProject.getFolder(FOLDER_MODELS);
        models.create(true, false, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.deleteProject();
        this.myProject = null;
        this.myOperation = null;
        super.tearDown();
    }

    public void testErrorArguments() {
        ResourceSetImpl rs = new ResourceSetImpl();
        URI toolURI = this.prepareResource((ResourceSet)rs, FILE_EXT_GMFTOOL, (EObject)this.getSetup().getToolDefModel().getRegistry());
        this.prepareResource((ResourceSet)rs, FILE_EXT_GMFMAP, (EObject)this.getSetup().getMapModel().getMapping());
        try {
            this.myOperation.loadMappingModel(toolURI, null);
            TransformToGenModelOperationTest.fail((String)"Invalid MappingModel should not be accepted");
        }
        catch (CoreException coreException) {
            Diagnostic validationResult = this.myOperation.getMapmodelValidationResult();
            TransformToGenModelOperationTest.assertNotNull((String)"MappingModel validation result should be set", (Object)validationResult);
            TransformToGenModelOperationTest.assertFalse((String)"Load MappingModel status should differ from OK value", (validationResult.getSeverity() == 0 ? 1 : 0) != 0);
            TransformToGenModelOperationTest.assertNull((String)"GenModelDetector should be reset", (Object)this.myOperation.getGenModelDetector());
            TransformToGenModelOperationTest.assertNull((String)"GenModel should be reset", (Object)this.myOperation.getGenModel());
        }
        try {
            this.myOperation.loadMappingModel(null, null);
            TransformToGenModelOperationTest.fail((String)"null gmfmap URI should not be accepted");
        }
        catch (CoreException e) {
            this.assertIllegalArgument(e);
        }
    }

    public void testErrorState() {
        IStatus s = this.myOperation.executeTransformation(null);
        TransformToGenModelOperationTest.assertFalse((String)"Target gmfgen URI should be specified", (boolean)s.isOK());
        this.myOperation.setGenURI(this.createURI(FILE_EXT_GMFGEN));
        s = this.myOperation.executeTransformation(null);
        TransformToGenModelOperationTest.assertFalse((String)"Mapping model should be loaded before calling executeTransformation()", (boolean)s.isOK());
        try {
            this.myOperation.loadGenModel(null, null);
            TransformToGenModelOperationTest.fail((String)"MappingModel should be loaded before calling loadGenModel()");
        }
        catch (CoreException e) {
            this.assertIllegalState(e);
        }
        try {
            this.myOperation.findGenmodel();
            TransformToGenModelOperationTest.fail((String)"MappingModel should be loaded before calling findGenmodel()");
        }
        catch (CoreException e) {
            this.assertIllegalState(e);
        }
    }

    public void testTransformMappingModel() {
        URI mapURI = this.prepareResources();
        this.loadMappingModel(mapURI);
        this.findAbsentGenmodel();
        URI genmodelURI = this.createDefaultGenModel(mapURI);
        GenModel genModel = null;
        try {
            genModel = this.myOperation.loadGenModel(genmodelURI, null);
            TransformToGenModelOperationTest.assertNotNull((String)"Failed to load GenModel", (Object)genModel);
        }
        catch (CoreException coreException) {
            TransformToGenModelOperationTest.assertNotNull((String)"Failed to load GenModel", genModel);
        }
        this.myOperation.setGenURI(this.createURI(FILE_EXT_GMFGEN));
        IStatus status = this.myOperation.executeTransformation(null);
        TransformToGenModelOperationTest.assertTrue((boolean)status.isOK());
    }

    public void testTransfromDesignMapping() {
        URI mapURI = this.prepareDesignResources();
        this.loadMappingModel(mapURI);
        this.myOperation.setGenURI(this.createURI(FILE_EXT_GMFGEN));
        IStatus status = this.myOperation.executeTransformation(null);
        TransformToGenModelOperationTest.assertTrue((boolean)status.isOK());
    }

    private void loadMappingModel(URI mapURI) {
        Mapping mapping = null;
        try {
            mapping = this.myOperation.loadMappingModel(mapURI, null);
            TransformToGenModelOperationTest.assertNotNull((String)"Mapping should be resolved", (Object)mapping);
            Diagnostic validationResult = this.myOperation.getMapmodelValidationResult();
            TransformToGenModelOperationTest.assertNotNull((String)"MappingModel validation result should be set", (Object)validationResult);
            TransformToGenModelOperationTest.assertFalse((String)"MappingModel validation result should differ from CANCEL value", (8 == validationResult.getSeverity() ? 1 : 0) != 0);
            TransformToGenModelOperationTest.assertFalse((String)"MappingModel validation result should differ from ERROR value", (4 == validationResult.getSeverity() ? 1 : 0) != 0);
            TransformToGenModelOperationTest.assertNotNull((String)"GenModelDetector should be initialized", (Object)this.myOperation.getGenModelDetector());
            TransformToGenModelOperationTest.assertNull((String)"GenModel should be reset", (Object)this.myOperation.getGenModel());
        }
        catch (CoreException e) {
            TransformToGenModelOperationTest.fail((String)e.getStatus().getMessage());
        }
    }

    private void findAbsentGenmodel() {
        try {
            this.myOperation.findGenmodel();
            TransformToGenModelOperationTest.fail((String)"GenModel should not be found");
        }
        catch (CoreException coreException) {
            TransformToGenModelOperationTest.assertNull((String)"GenModel should not be found", (Object)this.myOperation.getGenModel());
        }
    }

    private URI createDefaultGenModel(URI mapURI) {
        URI genmodelURI = null;
        try {
            GenModelDetector gmd = this.myOperation.getGenModelDetector();
            TransformToGenModelOperationTest.assertNotNull((String)"GenModelDetector should be initialized", (Object)gmd);
            genmodelURI = gmd.createDefault(this.getProject().getName(), URIUtil.getFile((URI)mapURI));
            TransformToGenModelOperationTest.assertNotNull((String)"GenModel URI should be created", (Object)genmodelURI);
            IFile file = URIUtil.getFile((URI)mapURI);
            TransformToGenModelOperationTest.assertNotNull((String)"GenModel file should be created", (Object)file);
            TransformToGenModelOperationTest.assertTrue((String)"GenModel file should exists", (boolean)file.exists());
        }
        catch (CoreException e) {
            TransformToGenModelOperationTest.fail((String)("Failed to create default GenModel: " + e.getMessage()));
        }
        return genmodelURI;
    }

    protected IProject createProject() {
        String projectName = "TransformToGenModelOperationTest_" + String.valueOf(System.currentTimeMillis());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        TransformToGenModelOperationTest.assertFalse((String)("Project with this name already present in the workspace: " + projectName), (boolean)project.exists());
        try {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            TransformToGenModelOperationTest.fail((String)e.getMessage());
        }
        TransformToGenModelOperationTest.assertTrue((String)("Project was not created: " + projectName), (boolean)project.exists());
        return project;
    }

    protected void deleteProject() throws CoreException {
        if (this.getProject() != null) {
            if (this.getProject().isOpen()) {
                this.getProject().close((IProgressMonitor)new NullProgressMonitor());
            }
            if (this.getProject().exists()) {
                this.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected IProject getProject() {
        return this.myProject;
    }

    private URI prepareResources() {
        ResourceSetImpl rs = new ResourceSetImpl();
        this.prepareResource((ResourceSet)rs, FILE_EXT_ECORE, (EObject)this.getSetup().getDomainModel().getModel());
        this.prepareResource((ResourceSet)rs, FILE_EXT_GMFGRAPH, (EObject)this.getSetup().getGraphDefModel().getCanvasDef());
        this.prepareResource((ResourceSet)rs, FILE_EXT_GMFTOOL, (EObject)this.getSetup().getToolDefModel().getRegistry());
        URI mapURI = this.prepareResource((ResourceSet)rs, FILE_EXT_GMFMAP, (EObject)this.getSetup().getMapModel().getMapping());
        return mapURI;
    }

    private URI prepareDesignResources() {
        ResourceSetImpl rs = new ResourceSetImpl();
        DiaDefSource ddSource = this.getSetup().getGraphDefModel();
        this.prepareResource((ResourceSet)rs, FILE_EXT_GMFGRAPH, (EObject)ddSource.getCanvasDef());
        ToolDefSource toolDef = this.getSetup().getToolDefModel();
        this.prepareResource((ResourceSet)rs, FILE_EXT_GMFTOOL, (EObject)toolDef.getRegistry());
        URI mapURI = this.prepareResource((ResourceSet)rs, FILE_EXT_GMFMAP, (EObject)new DesignMapDefSource().init(ddSource, toolDef).getMapping());
        return mapURI;
    }

    private URI prepareResource(ResourceSet rs, String extension, EObject root) {
        URI uri = this.createURI(extension);
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)root);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            TransformToGenModelOperationTest.fail((String)("Failed to save " + uri.toFileString() + " :" + e.getMessage()));
        }
        return uri;
    }

    private URI createURI(String extension) {
        String pathName = String.valueOf(this.getProject().getName()) + '/' + FOLDER_MODELS + '/' + FILE_BASE + "." + extension;
        URI uri = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        return uri;
    }

    private void assertIllegalArgument(CoreException e) {
        Throwable cause = e.getStatus().getException();
        if (!(cause instanceof IllegalArgumentException)) {
            TransformToGenModelOperationTest.fail((String)e.getMessage());
        }
    }

    private void assertIllegalState(CoreException e) {
        Throwable cause = e.getStatus().getException();
        if (!(cause instanceof IllegalStateException)) {
            TransformToGenModelOperationTest.fail((String)e.getMessage());
        }
    }

    private class DesignMapDefSource
    implements MapDefSource {
        private Mapping myMap;
        private NodeMapping myNodeA;
        private NodeMapping myNodeB;
        private LinkMapping myClassLink;
        private LinkMapping myRefLink;

        public DesignMapDefSource init(DiaDefSource ddSource, ToolDefSource toolDef) {
            this.initCanvasMapping(ddSource.getCanvasDef());
            if (toolDef.getMainMenu() != null) {
                this.myMap.getDiagram().getMenuContributions().add((Object)toolDef.getMainMenu());
            }
            this.myMap.getDiagram().setPalette(toolDef.getPalette());
            this.initCommonMapping(ddSource, toolDef);
            return this;
        }

        private void initCanvasMapping(Canvas canvas) {
            Mapping m = GMFMapFactory.eINSTANCE.createMapping();
            CanvasMapping cme = GMFMapFactory.eINSTANCE.createCanvasMapping();
            cme.setDiagramCanvas(canvas);
            m.setDiagram(cme);
            this.myMap = m;
        }

        private void initCommonMapping(DiaDefSource ddSource, ToolDefSource toolDef) {
            this.myNodeA = this.createNodeMapping(ddSource.getNodeDef(), ddSource.getLabelDef(), true);
            this.myNodeA.setContextMenu(toolDef.getNodeContextMenu());
            this.myNodeA.setTool(toolDef.getNodeCreationTool());
            DiaDefSetup ddSetup = ddSource instanceof DiaDefSetup ? (DiaDefSetup)ddSource : null;
            Node graphNode = ddSetup != null ? ddSetup.getColoredNodeDef() : ddSource.getNodeDef();
            DiagramLabel graphLabel = ddSetup != null ? ddSetup.getDecoratedLabelDef() : ddSource.getLabelDef();
            this.myNodeB = this.createNodeMapping(graphNode, graphLabel, true);
            this.myClassLink = this.createLinkMapping(ddSource.getLinkDef());
            this.myClassLink.setTool(toolDef.getLinkCreationTool());
            this.myRefLink = this.createLinkMapping(ddSetup != null ? ddSetup.getColoredLinkDef() : ddSource.getLinkDef());
        }

        private final NodeMapping createNodeMapping(Node nodeDef, DiagramLabel labelDef, boolean addTopNodeReference) {
            NodeMapping nme = GMFMapFactory.eINSTANCE.createNodeMapping();
            nme.setDiagramNode(nodeDef);
            if (addTopNodeReference) {
                TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
                tnr.setOwnedChild(nme);
                this.myMap.getNodes().add((Object)tnr);
            }
            return nme;
        }

        private LinkMapping createLinkMapping(Connection link) {
            LinkMapping lme = GMFMapFactory.eINSTANCE.createLinkMapping();
            lme.setDiagramLink(link);
            this.myMap.getLinks().add((Object)lme);
            return lme;
        }

        public final Mapping getMapping() {
            return this.myMap;
        }

        public NodeMapping getNodeA() {
            return this.myNodeA;
        }

        public NodeMapping getNodeB() {
            return this.myNodeB;
        }

        public LinkMapping getClassLink() {
            return this.myClassLink;
        }

        public LinkMapping getReferenceLink() {
            return this.myRefLink;
        }
    }
}

