/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.figures;

import junit.framework.Assert;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.Polygon;
import org.eclipse.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.tests.TestConfiguration;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFigureGeneratorSetup
implements TestConfiguration {
    private FigureGallery myFigureGallery;
    private FigureGeneratorUtil.GeneratedClassData[] myClassDatas;
    private PolylineConnection myEcoreContainmentRef;
    private RealFigure myCustomFigure;
    private RealFigure mySimpleShape;
    private RealFigure myComplexShape;
    private StandaloneGenerator.Config myConfig;

    protected abstract void addFigures(FigureGallery var1);

    public Class<?> getFigureClass(Figure f) {
        FigureGeneratorUtil.GeneratedClassData[] classDatas = this.getClassData();
        int i = 0;
        while (i < classDatas.length) {
            Figure toCheck = classDatas[i].getFigureDef().getActualFigure();
            if (toCheck instanceof FigureRef) {
                toCheck = ((FigureRef)toCheck).getFigure();
            }
            if (toCheck == f) {
                return classDatas[i].getLoadedClass();
            }
            ++i;
        }
        Assert.fail((String)("Class was not found in generated plugin: " + this.getConfig().getPluginID() + "|" + this.getConfig().getMainPackageName() + "|" + ((RealFigure)f).getName()));
        return null;
    }

    private FigureGeneratorUtil.GeneratedClassData[] getClassData() {
        if (this.myClassDatas == null) {
            this.myClassDatas = FigureGeneratorUtil.generateAndCompile(this.getFigureGallery(), this.getConfig());
        }
        return this.myClassDatas;
    }

    protected StandaloneGenerator.Config getConfig() {
        if (this.myConfig == null) {
            this.myConfig = FigureGeneratorUtil.createStandaloneGeneratorConfig();
        }
        return this.myConfig;
    }

    private FigureGallery getFigureGallery() {
        if (this.myFigureGallery == null) {
            this.myFigureGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
            this.myFigureGallery.setName("bb");
            this.addFigures(this.myFigureGallery);
            Assert.assertFalse((String)"No figures was added to the gallery by subclasses", (this.myFigureGallery.getFigures().isEmpty() && this.myFigureGallery.getDescriptors().isEmpty() ? 1 : 0) != 0);
        }
        return this.myFigureGallery;
    }

    public PolylineConnection getEcoreContainmentRef() {
        if (this.myEcoreContainmentRef == null) {
            this.myEcoreContainmentRef = GMFGraphFactory.eINSTANCE.createPolylineConnection();
            this.myEcoreContainmentRef.setName("ContainmentRef");
            PolygonDecoration df = this.createBlueRhomb();
            df.setFill(true);
            this.myEcoreContainmentRef.setSourceDecoration((DecorationFigure)df);
        }
        return this.myEcoreContainmentRef;
    }

    private PolygonDecoration createBlueRhomb() {
        PolygonDecoration df = GMFGraphFactory.eINSTANCE.createPolygonDecoration();
        df.setName("BlueRhombDecoration");
        df.getTemplate().add((Object)FigureGeneratorUtil.createPoint(-1, 1));
        df.getTemplate().add((Object)FigureGeneratorUtil.createPoint(0, 0));
        df.getTemplate().add((Object)FigureGeneratorUtil.createPoint(-1, -1));
        df.getTemplate().add((Object)FigureGeneratorUtil.createPoint(-2, 0));
        df.setBackgroundColor((Color)FigureGeneratorUtil.createConstantColor(ColorConstants.BLUE_LITERAL));
        df.setForegroundColor((Color)FigureGeneratorUtil.createRGBColor(0, 0, 255));
        return df;
    }

    public final RealFigure getCustomFigure() {
        if (this.myCustomFigure == null) {
            this.myCustomFigure = AbstractFigureGeneratorSetup.createFigure1();
        }
        return this.myCustomFigure;
    }

    public final RealFigure getSimpleShape() {
        if (this.mySimpleShape == null) {
            this.mySimpleShape = AbstractFigureGeneratorSetup.createFigure2();
        }
        return this.mySimpleShape;
    }

    public final RealFigure getComplexShape() {
        if (this.myComplexShape == null) {
            this.myComplexShape = AbstractFigureGeneratorSetup.createFigure3();
        }
        return this.myComplexShape;
    }

    protected static RealFigure createFigure1() {
        CustomFigure cf = GMFGraphFactory.eINSTANCE.createCustomFigure();
        cf.setName("MyRRectangleAsCustom");
        cf.setQualifiedClassName(org.eclipse.draw2d.RoundedRectangle.class.getName());
        Point p = GMFGraphFactory.eINSTANCE.createPoint();
        p.setX(1023);
        p.setY(33);
        cf.setSize(p);
        cf.getChildren().add((Object)AbstractFigureGeneratorSetup.createFigure2());
        Ellipse e = GMFGraphFactory.eINSTANCE.createEllipse();
        e.setName("Elli");
        e.setFill(true);
        cf.getChildren().add((Object)e);
        return cf;
    }

    protected static RealFigure createFigure2() {
        Rectangle r = GMFGraphFactory.eINSTANCE.createRectangle();
        r.setName("MyRect");
        r.setFill(true);
        r.setLineWidth(3);
        r.setLineKind(LineKind.LINE_DASHDOT_LITERAL);
        Label l1 = GMFGraphFactory.eINSTANCE.createLabel();
        l1.setText("aaaaa");
        l1.setName("L1");
        l1.setFont(FigureGeneratorUtil.createBasicFont("Arial", 9, FontStyle.ITALIC_LITERAL));
        l1.setForegroundColor((Color)FigureGeneratorUtil.createConstantColor(ColorConstants.CYAN_LITERAL));
        Label l2 = GMFGraphFactory.eINSTANCE.createLabel();
        l2.setText("bbbbb");
        l2.setName("L2");
        l2.setFont(FigureGeneratorUtil.createBasicFont("Helvetica", 12, FontStyle.BOLD_LITERAL));
        r.getChildren().add((Object)l1);
        r.getChildren().add((Object)l2);
        return r;
    }

    private static RealFigure createFigure3() {
        RoundedRectangle myFigure3 = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        myFigure3.setName("Rounded1");
        Polygon pg = GMFGraphFactory.eINSTANCE.createPolygon();
        pg.setName("Polygon1");
        pg.getTemplate().add((Object)FigureGeneratorUtil.createPoint(1, 2));
        pg.getTemplate().add((Object)FigureGeneratorUtil.createPoint(0, 3));
        pg.getTemplate().add((Object)FigureGeneratorUtil.createPoint(-2, -1));
        myFigure3.getChildren().add((Object)pg);
        myFigure3.getChildren().add((Object)AbstractFigureGeneratorSetup.createFigure1());
        return myFigure3;
    }
}

