/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.common.reconcile.Matcher;

public class ReflectiveMatcher
implements Matcher {
    private EClass myOwner;
    private Reflector myReflector;

    public ReflectiveMatcher(EStructuralFeature feature) {
        this(feature.getEContainingClass(), new StructuralFeatureReflector(feature));
    }

    public ReflectiveMatcher(EClass reflectorOwner, Reflector reflector) {
        this.myOwner = reflectorOwner;
        this.myReflector = reflector;
    }

    public final boolean match(EObject current, EObject old) {
        this.assertCompatible(current, old);
        this.checkReflector(current.eClass());
        Object currentValue = this.myReflector.reflect(current);
        return currentValue != null && currentValue.equals(this.myReflector.reflect(old));
    }

    private void assertCompatible(EObject current, EObject old) {
        if (!current.eClass().equals(old.eClass())) {
            throw new IllegalStateException(MessageFormat.format("Objects not compatible: {0}, {1}", current, old));
        }
    }

    private void checkReflector(EClass eClass) {
        if (!this.myOwner.isSuperTypeOf(eClass)) {
            throw new IllegalStateException(MessageFormat.format("EClass {0} is not compatible with expected class {1} ", eClass, this.myOwner));
        }
    }

    public static interface Reflector {
        public Object reflect(EObject var1);
    }

    public static class StructuralFeatureReflector
    implements Reflector {
        private final EStructuralFeature myFeature;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.internal.common.reconcile.ReflectiveMatcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public StructuralFeatureReflector(EStructuralFeature feature) {
            if (!$assertionsDisabled && feature == null) {
                throw new AssertionError();
            }
            this.myFeature = feature;
        }

        public Object reflect(EObject target) {
            return target.eGet(this.myFeature);
        }
    }
}

