/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalActionManager;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.SelectAllAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.DiagramState;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.IPresentationTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestActionCallback;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestCommandCallback;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractTestBase
extends TestCase {
    protected IPresentationTestFixture testFixture = null;
    public static final String SYSPROP_VERBOSE = "presentation.test.verbose";
    private static boolean _verbose = Boolean.getBoolean("presentation.test.verbose");

    public AbstractTestBase(String arg0) {
        super(arg0);
        this.setTestFixture();
    }

    protected final void enableVerbose(boolean enabled) {
        _verbose = enabled;
    }

    public final boolean isVerbose() {
        return _verbose;
    }

    public static final void println(Object msg) {
        if (_verbose) {
            System.out.println(msg);
        }
    }

    public static final void print(Object msg) {
        if (_verbose) {
            System.out.print(msg);
        }
    }

    protected CommandStack getCommandStack() {
        return this.getTestFixture().getCommandStack();
    }

    protected abstract void setTestFixture();

    protected IPresentationTestFixture getTestFixture() {
        return this.testFixture;
    }

    protected IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        return this.getTestFixture().getDiagramWorkbenchPart();
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return this.getDiagramWorkbenchPart().getSite().getPage();
    }

    protected DiagramEditPart getDiagramEditPart() {
        return this.getTestFixture().getDiagramEditPart();
    }

    protected Diagram getDiagram() {
        return this.getTestFixture().getDiagram();
    }

    protected void saveDiagram() {
        if (this.getDiagramWorkbenchPart() instanceof IEditorPart) {
            IWorkbenchPage page = this.getDiagramWorkbenchPart().getSite().getPage();
            page.saveEditor((IEditorPart)this.getDiagramWorkbenchPart(), false);
            this.flushEventQueue();
        }
    }

    protected boolean isDirty() {
        if (this.getDiagramWorkbenchPart() instanceof IEditorPart) {
            return ((IEditorPart)this.getDiagramWorkbenchPart()).isDirty();
        }
        return false;
    }

    protected DiagramState getDiagramState() {
        try {
            return (DiagramState)TransactionUtil.getEditingDomain((EObject)this.getDiagram()).runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(new DiagramState(AbstractTestBase.this.getDiagramEditPart()));
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            AbstractTestBase.assertTrue((boolean)false);
            return null;
        }
    }

    protected void testCommand(ICommand command, ITestCommandCallback callback) {
        this.testCommand((Command)new ICommandProxy(command), callback);
    }

    protected void testCommand(Command command, final ITestCommandCallback callback) {
        AbstractTestBase.assertNotNull((Object)command);
        DiagramState state1 = this.getDiagramState();
        this.getCommandStack().execute(command);
        this.flushEventQueue();
        try {
            TransactionUtil.getEditingDomain((EObject)this.getDiagram()).runExclusive(new Runnable(){

                public void run() {
                    callback.onCommandExecution();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            AbstractTestBase.assertTrue((boolean)false);
        }
        DiagramState state2 = this.getDiagramState();
        if (this.getCommandStack().canUndo()) {
            this.getCommandStack().undo();
            this.flushEventQueue();
            AbstractTestBase.assertTrue((boolean)state1.equals(this.getDiagramState()));
            this.getCommandStack().redo();
            this.flushEventQueue();
        }
        AbstractTestBase.assertTrue((boolean)state2.equals(this.getDiagramState()));
    }

    protected void testAction(IAction action, ITestActionCallback callback) {
        this.flushEventQueue();
        AbstractTestBase.assertTrue((boolean)action.isEnabled());
        action.run();
        this.flushEventQueue();
        if (action instanceof Disposable) {
            ((Disposable)action).dispose();
        }
        if (callback != null) {
            callback.onRunExecution();
        }
    }

    protected void testAction(IDisposableAction action, ITestActionCallback callback) {
        this.getWorkbenchPage().activate((IWorkbenchPart)this.getDiagramWorkbenchPart());
        action.init();
        if (action.isEnabled()) {
            action.run();
            this.flushEventQueue();
        }
        action.dispose();
        if (callback != null) {
            callback.onRunExecution();
        }
    }

    protected void testActionAndUndoRedo(IDisposableAction action, ITestActionCallback callback) {
        DiagramState state1 = this.getDiagramState();
        this.getWorkbenchPage().activate((IWorkbenchPart)this.getDiagramWorkbenchPart());
        action.init();
        if (action.isEnabled()) {
            action.run();
            this.flushEventQueue();
        }
        action.dispose();
        if (callback != null) {
            callback.onRunExecution();
        }
        DiagramState state2 = this.getDiagramState();
        AbstractTestBase.assertTrue((String)"testActionAndUndoRedo: Action cannot be undone.", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        AbstractTestBase.assertTrue((String)"diagram state different after undo of action", (boolean)state1.equals(this.getDiagramState()));
        this.getCommandStack().redo();
        AbstractTestBase.assertTrue((String)"diagram state different after redo of action", (boolean)state2.equals(this.getDiagramState()));
    }

    protected void testProperty(View view, final String property, final Object expectedValue) {
        DiagramEditPart diagramEP = this.getDiagramEditPart();
        AbstractTestBase.assertNotNull((String)"The DiagramEditPart is null", (Object)diagramEP);
        RootEditPart rootEP = diagramEP.getRoot();
        AbstractTestBase.assertNotNull((String)"The RootEditPart is null", (Object)rootEP);
        EditPartViewer viewer = rootEP.getViewer();
        AbstractTestBase.assertNotNull((String)"The EditPartViewer is null", (Object)viewer);
        Map epRegistry = viewer.getEditPartRegistry();
        AbstractTestBase.assertNotNull((String)"The EditPartRegistery is null", (Object)epRegistry);
        final IGraphicalEditPart ep = (IGraphicalEditPart)epRegistry.get(view);
        AbstractTestBase.assertNotNull((String)"Couldn't find the GraphicalEditPart in the Registery", (Object)ep);
        ChangePropertyValueRequest request = new ChangePropertyValueRequest("", property, expectedValue);
        Command cmd = ep.getCommand((Request)request);
        this.testCommand(cmd, new ITestCommandCallback(){

            public void onCommandExecution() {
                AbstractTestBase.assertEquals((Object)expectedValue, (Object)ep.getStructuralFeatureValue((EStructuralFeature)PackageUtil.getElement((String)property)));
            }
        });
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getTestFixture().setup();
    }

    protected void flushEventQueue() {
        this.getTestFixture().flushEventQueue();
    }

    protected void tearDown() throws Exception {
        this.flushEventQueue();
        this.getTestFixture().tearDown();
    }

    protected View createShapeView(DiagramEditPart diagramEP, EObject semanticElement, Point location) {
        CompoundCommand cc = new CompoundCommand();
        CreateViewRequest request = new CreateViewRequest(semanticElement, this.getTestFixture().getPreferencesHint());
        request.setLocation(location);
        cc.add(diagramEP.getCommand((Request)request));
        RefreshConnectionsRequest rcRequest = new RefreshConnectionsRequest((List)request.getNewObject());
        cc.add(this.getDiagramEditPart().getCommand((Request)rcRequest));
        this.getCommandStack().execute((Command)cc);
        return (View)((IAdaptable)((List)request.getNewObject()).get(0)).getAdapter(View.class);
    }

    protected void clearDiagram() {
        this.testAction((IDisposableAction)SelectAllAction.createSelectAllAction((IWorkbenchPage)this.getWorkbenchPage()), null);
        this.testAction((IDisposableAction)GlobalActionManager.getInstance().createActionHandler(this.getWorkbenchPage(), GlobalActionId.DELETE), null);
    }

    protected IFigure getDrawSurfaceFigure() {
        return this.getDiagramEditPart().getFigure();
    }

    protected IGraphicalEditPart getDrawSurfaceEditPart() {
        return this.getDiagramEditPart();
    }

    protected List getShapesIn(IGraphicalEditPart parent) {
        AbstractTestBase.assertNotNull((Object)parent);
        ArrayList shapes = new ArrayList();
        for (Object child : parent.getChildren()) {
            if (!(child instanceof ShapeNodeEditPart)) continue;
            shapes.add(child);
        }
        return shapes;
    }

    protected List getConnectors() {
        return this.getDiagramEditPart().getConnections();
    }

    public void runBare() throws Throwable {
        try {
            this.setUp();
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    protected Command reorientConnectionTarget(final ConnectionEditPart connectionEditPart, final IGraphicalEditPart targetEditPart, boolean supported) {
        ReconnectRequest reconnectReq = new ReconnectRequest((Object)"Reconnection target");
        reconnectReq.setConnectionEditPart(connectionEditPart);
        reconnectReq.setTargetEditPart((EditPart)targetEditPart);
        reconnectReq.setLocation(targetEditPart.getFigure().getBounds().getTopRight());
        Command cmd = targetEditPart.getCommand((Request)reconnectReq);
        if (supported) {
            this.testCommand(cmd, new ITestCommandCallback(){

                public void onCommandExecution() {
                    AbstractTestBase.assertTrue((connectionEditPart.getTarget() == targetEditPart ? 1 : 0) != 0);
                }
            });
        } else {
            AbstractTestBase.assertTrue((cmd == null || !cmd.canExecute() ? 1 : 0) != 0);
        }
        return cmd;
    }

    protected Command reorientConnectionSource(final ConnectionEditPart connectionEditPart, final IGraphicalEditPart sourceEditPart, boolean supported) {
        ReconnectRequest reconnectReq = new ReconnectRequest((Object)"Reconnection source");
        reconnectReq.setConnectionEditPart(connectionEditPart);
        reconnectReq.setTargetEditPart((EditPart)sourceEditPart);
        reconnectReq.setLocation(sourceEditPart.getFigure().getBounds().getTopRight());
        Command cmd = sourceEditPart.getCommand((Request)reconnectReq);
        if (supported) {
            this.testCommand(cmd, new ITestCommandCallback(){

                public void onCommandExecution() {
                    AbstractTestBase.assertTrue((connectionEditPart.getSource() == sourceEditPart ? 1 : 0) != 0);
                }
            });
        } else {
            AbstractTestBase.assertTrue((cmd == null || !cmd.canExecute() ? 1 : 0) != 0);
        }
        return cmd;
    }
}

