/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import junit.framework.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCanvasTest
extends ConfiguredTestCase {
    private GeneratorConfiguration.ViewerConfiguration myViewerConfiguration;
    private Bundle myGenProject;

    public AbstractCanvasTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myGenProject = this.getSetup().getGenProject().getBundle();
    }

    @Override
    protected void tearDown() throws Exception {
        this.myViewerConfiguration = null;
        super.tearDown();
    }

    protected final EditPart findEditPart(View notationElement) {
        return this.getViewerConfiguration().findEditPart(notationElement);
    }

    protected final EditPart getDiagramEditPart() {
        return this.getViewerConfiguration().getViewer().getContents();
    }

    protected final Diagram getDiagram() {
        return (Diagram)this.getDiagramEditPart().getModel();
    }

    protected void setViewerConfiguration(GeneratorConfiguration.ViewerConfiguration configuration) {
        this.myViewerConfiguration = configuration;
    }

    public GeneratorConfiguration.ViewerConfiguration getViewerConfiguration() {
        if (this.myViewerConfiguration == null) {
            try {
                this.myViewerConfiguration = this.createViewerConfiguration();
            }
            catch (Exception e) {
                AbstractCanvasTest.fail((String)e.getMessage());
            }
            AbstractCanvasTest.assertNotNull((String)"No viewer configuration", (Object)this.myViewerConfiguration);
        }
        return this.myViewerConfiguration;
    }

    protected Node createNode(GenCommonBase nodeType, View notationContainer) {
        Object[] newObjHolder;
        block5: {
            newObjHolder = new Object[1];
            AdapterImpl adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getEventType() == 3) {
                        newObjHolder[0] = msg.getNewValue();
                    }
                }

                public boolean isAdapterForType(Object type) {
                    return true;
                }
            };
            Command cmd = this.getViewerConfiguration().getCreateNodeCommand(notationContainer, nodeType);
            Assert.assertNotNull((String)"No command is available for request", (Object)cmd);
            notationContainer.eAdapters().add((Object)adapter);
            try {
                try {
                    this.execute(cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Node creation failure: " + e.getLocalizedMessage()));
                    notationContainer.eAdapters().remove((Object)adapter);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                notationContainer.eAdapters().remove((Object)adapter);
                throw throwable;
            }
            notationContainer.eAdapters().remove((Object)adapter);
        }
        AbstractCanvasTest.assertTrue((String)"Faile to create notation model Node", (boolean)(newObjHolder[0] instanceof Node));
        Node createdNode = (Node)newObjHolder[0];
        AbstractCanvasTest.assertTrue((String)"Node was not created", (createdNode.eContainer() == notationContainer ? 1 : 0) != 0);
        AbstractCanvasTest.assertEquals((String)"Incorrect node type used", (String)String.valueOf(nodeType.getVisualID()), (String)createdNode.getType());
        return createdNode;
    }

    protected Edge createLink(GenLink linkType, View source, View target) {
        Command targetCmd;
        Diagram diagram;
        AdapterImpl adapter;
        Object[] newObjHolder;
        block5: {
            newObjHolder = new Object[1];
            adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getEventType() == 3 && msg.getNewValue() instanceof Edge) {
                        newObjHolder[0] = msg.getNewValue();
                    }
                }

                public boolean isAdapterForType(Object type) {
                    return true;
                }
            };
            diagram = this.getDiagram();
            diagram.eAdapters().add((Object)adapter);
            targetCmd = this.getViewerConfiguration().getCreateLinkCommand(source, target, (GenCommonBase)linkType);
            if (targetCmd != null && targetCmd.canExecute()) break block5;
            diagram.eAdapters().remove((Object)adapter);
            return null;
        }
        try {
            try {
                this.execute(targetCmd);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Edge creation failure: " + e.getLocalizedMessage()));
                diagram.eAdapters().remove((Object)adapter);
            }
        }
        catch (Throwable throwable) {
            diagram.eAdapters().remove((Object)adapter);
            throw throwable;
        }
        diagram.eAdapters().remove((Object)adapter);
        AbstractCanvasTest.assertTrue((String)"Faile to create notation model Edge", (boolean)(newObjHolder[0] instanceof Edge));
        return (Edge)newObjHolder[0];
    }

    protected static View findChildView(View parentView, GenCommonBase childType) {
        String notationType = String.valueOf(childType.getVisualID());
        for (View next : parentView.getChildren()) {
            if (!notationType.equals(next.getType())) continue;
            return next;
        }
        return null;
    }

    protected final Class<?> loadGeneratedClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.myGenProject.loadClass(qualifiedClassName);
    }

    protected final void execute(Command cmd) {
        this.getCommandStack().execute(cmd);
    }

    protected final CommandStack getCommandStack() {
        return this.getViewerConfiguration().getViewer().getEditDomain().getCommandStack();
    }

    protected abstract GeneratorConfiguration.ViewerConfiguration createViewerConfiguration() throws Exception;
}

