/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.SelectFileControl;

public class NewFileAction
extends Action {
    private final SelectFileControl myControl;
    private final IContainer myContainer;
    private final String myBaseName;
    private final String myExtension;

    public NewFileAction(SelectFileControl control, IContainer container, String fileName) {
        this.myControl = control;
        this.myContainer = container;
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot == -1) {
            this.myBaseName = fileName;
            this.myExtension = "";
        } else {
            this.myBaseName = fileName.substring(0, lastDot);
            this.myExtension = lastDot < fileName.length() - 1 ? fileName.substring(lastDot + 1) : "";
        }
    }

    public void run() {
        IFile file = this.getFile();
        this.myControl.addCreatedFile(file);
        this.myControl.getViewer().refresh();
        this.myControl.getViewer().editElement((Object)file, 0);
    }

    private IFile getFile() {
        int idx = 0;
        while (true) {
            Path path;
            IFile file;
            StringBuffer fname = new StringBuffer();
            fname.append(this.myBaseName);
            if (idx > 0) {
                fname.append("" + idx);
            }
            if (this.myExtension.length() > 0) {
                fname.append("." + this.myExtension);
            }
            if (!(file = this.myContainer.getFile((IPath)(path = new Path(fname.toString())))).exists()) {
                return file;
            }
            ++idx;
        }
    }
}

