/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.aop.internal.AdviceContextImpl;
import org.eclipse.xtend.backend.common.AdviceContext;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.Constants;
import org.eclipse.xtend.backend.common.ContributionStateContext;
import org.eclipse.xtend.backend.common.CreationCache;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExecutionListener;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.FunctionInvoker;
import org.eclipse.xtend.backend.common.LocalVarContext;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.common.StacktraceEntry;
import org.eclipse.xtend.backend.internal.CreationCacheImpl;
import org.eclipse.xtend.backend.internal.FunctionInvokerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionContextImpl
implements ExecutionContext {
    private final CreationCache _creationCache = new CreationCacheImpl();
    private FunctionDefContext _functionDefContext;
    private LocalVarContext _localVarContext = new LocalVarContext();
    private final FunctionInvoker _functionInvoker = new FunctionInvokerImpl();
    private final BackendTypesystem _typeSystem;
    private final boolean _logStacktrace;
    private final List<StacktraceEntry> _stacktrace = new ArrayList<StacktraceEntry>();
    private AdviceContext _adviceContext = new AdviceContextImpl();
    private final ContributionStateContext _contributionStateContext = new ContributionStateContext();
    private final List<ExecutionListener> _globalExecutionListeners = new ArrayList<ExecutionListener>();

    public ExecutionContextImpl(FunctionDefContext initialFunctionDefContext, BackendTypesystem typesystem, boolean logStacktrace) {
        this._functionDefContext = initialFunctionDefContext;
        this._typeSystem = typesystem;
        this._logStacktrace = logStacktrace;
    }

    @Override
    public CreationCache getCreationCache() {
        return this._creationCache;
    }

    @Override
    public FunctionDefContext getFunctionDefContext() {
        return this._functionDefContext;
    }

    @Override
    public void setFunctionDefContext(FunctionDefContext ctx) {
        this._functionDefContext = ctx;
    }

    @Override
    public LocalVarContext getLocalVarContext() {
        return this._localVarContext;
    }

    @Override
    public void setLocalVarContext(LocalVarContext ctx) {
        this._localVarContext = ctx;
    }

    @Override
    public FunctionInvoker getFunctionInvoker() {
        return this._functionInvoker;
    }

    @Override
    public BackendTypesystem getTypesystem() {
        return this._typeSystem;
    }

    @Override
    public void logNullDeRef(SourcePos pos) {
        StringBuilder sb = new StringBuilder("dereferenced null " + (pos != null ? "(" + pos + ")" : ""));
        int i = this._stacktrace.size() - 1;
        while (i >= 0) {
            sb.append("\n  " + this._stacktrace.get(i));
            --i;
        }
        LogFactory.getLog((String)Constants.LOG_NULL_DEREF).warn((Object)sb);
    }

    @Override
    public ContributionStateContext getContributionStateContext() {
        return this._contributionStateContext;
    }

    @Override
    public List<StacktraceEntry> getStacktrace() {
        return this._stacktrace;
    }

    @Override
    public boolean isLogStacktrace() {
        return this._logStacktrace;
    }

    @Override
    public AdviceContext getAdviceContext() {
        return this._adviceContext;
    }

    @Override
    public void setAdviceContext(AdviceContext ctx) {
        this._adviceContext = ctx;
    }

    @Override
    public List<ExecutionListener> getGlobalExecutionListeners() {
        return this._globalExecutionListeners;
    }
}

