/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.lib;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.syslib.CollectionOperations;
import org.eclipse.xtend.backend.types.builtin.CollectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessor {
    private static Log _log = LogFactory.getLog(PropertyAccessor.class);

    public static Object propertyOnObject(Object owner, String propertyName, ExecutionContext ctx, SourcePos pos) {
        if (owner == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        return ctx.getTypesystem().findType(owner).getProperty(ctx, owner, propertyName);
    }

    public static Object propertyOnCollection(Collection<?> coll, String propertyName, ExecutionContext ctx, SourcePos pos) {
        if (coll == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("evaluating property " + propertyName + " on collection " + coll));
        }
        for (Object o : coll) {
            CollectionOperations.addFlattened(result, ctx.getTypesystem().findType(o).getProperty(ctx, o, propertyName));
        }
        return result;
    }

    public static Object propertyOnWhatever(Object owner, String propertyName, ExecutionContext ctx, SourcePos pos) {
        if (owner == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        BackendType t = ctx.getTypesystem().findType(owner);
        if (CollectionType.INSTANCE.isAssignableFrom(t)) {
            if (PropertyAccessor.isProperty(ctx, t, propertyName)) {
                return t.getProperty(ctx, owner, propertyName);
            }
            Collection<Object> result = CollectionOperations.createMatchingCollection((Collection)owner);
            for (Object obj : (Collection)owner) {
                CollectionOperations.addFlattened(result, ctx.getTypesystem().findType(obj).getProperty(ctx, obj, propertyName));
            }
            return result;
        }
        return t.getProperty(ctx, owner, propertyName);
    }

    private static boolean isProperty(ExecutionContext ctx, BackendType t, String propName) {
        return t.getProperties(ctx).containsKey(propName);
    }
}

