/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.ui.debug.processing.PluginAdapter;
import org.eclipse.emf.mwe.ui.debug.processing.PluginExtensionManager;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.editor.BreakpointActionGroup;

public class ToggleBreakpointAction
extends Action {
    private final TextEditor editor;
    private final BreakpointActionGroup group;

    public ToggleBreakpointAction(TextEditor editor, BreakpointActionGroup group) {
        this.editor = editor;
        this.group = group;
        this.setText(Messages.ToggleBreakpointAction_ToggleAction);
        this.setToolTipText(Messages.ToggleBreakpointAction_Description);
    }

    public void updateText() {
        int end;
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        PluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(resource.getFileExtension());
        if (adapter == null) {
            return;
        }
        int line = this.group.getLastSelectedLine() + 1;
        int start = this.group.getLastSelectedOffset();
        int n = end = this.group.isRulerSelected() ? this.group.getOffsetAtLine(line) : start;
        if (this.group.isRulerSelected()) {
            this.setEnabled(true);
        } else {
            try {
                this.setEnabled(adapter.isToggleBpEnabled(resource, start, end, line));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            this.toggleBreakpoint();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void toggleBreakpoint() throws CoreException {
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        int line = this.group.getLastSelectedLine() + 1;
        int start = this.group.getLastSelectedOffset();
        int end = start + this.group.getLine(line - 1).length();
        PluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(resource.getFileExtension());
        if (adapter == null) {
            return;
        }
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.emf.mwe.debug.model");
        IBreakpoint bp = adapter.checkBreakpoints(breakpoints, resource, start, end, line);
        if (bp != null) {
            bp.delete();
            return;
        }
        bp = adapter.createBreakpoint(resource, start, end, line);
        if (bp == null) {
            return;
        }
        breakpointManager.addBreakpoint(bp);
    }
}

