/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.prefuse.examples.treeview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.gmt.modisco.infra.prefuse.examples.treeview.TreeView;
import prefuse.Visualization;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.io.TreeMLReader;
import prefuse.util.FontLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.visual.VisualItem;

public class TreeViewUtils {
    public static JComponent demo(InputStream datafile, String label) {
        Graph t = null;
        try {
            t = new TreeMLReader().readGraph(datafile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return TreeViewUtils.demo(t, label);
    }

    public static JPanel demo(Graph g, final String label) {
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.BLACK;
        TreeView tview = new TreeView(g, label, null);
        tview.setBackground(BACKGROUND);
        tview.setForeground(FOREGROUND);
        JSearchPanel search = new JSearchPanel(tview.getVisualization(), "tree.nodes", Visualization.SEARCH_ITEMS, label, true, true);
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        search.setBackground(BACKGROUND);
        search.setForeground(FOREGROUND);
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        title.setBackground(BACKGROUND);
        title.setForeground(FOREGROUND);
        tview.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add((Component)search);
        box.add(Box.createHorizontalStrut(3));
        box.setBackground(BACKGROUND);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(BACKGROUND);
        panel.setForeground(FOREGROUND);
        panel.add((Component)((Object)tview), "Center");
        panel.add((Component)box, "South");
        return panel;
    }
}

