/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Spring;

public abstract class AbstractForce
implements Force {
    protected float[] params;
    protected float[] minValues;
    protected float[] maxValues;

    public void init(ForceSimulator fsim) {
    }

    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    public float getParameter(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[i];
    }

    public float getMinValue(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.minValues[i];
    }

    public float getMaxValue(int i) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.maxValues[i];
    }

    public String getParameterName(int i) {
        String[] pnames = this.getParameterNames();
        if (i < 0 || pnames == null || i >= pnames.length) {
            throw new IndexOutOfBoundsException();
        }
        return pnames[i];
    }

    public void setParameter(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.params[i] = val;
    }

    public void setMinValue(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.minValues[i] = val;
    }

    public void setMaxValue(int i, float val) {
        if (i < 0 || this.params == null || i >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.maxValues[i] = val;
    }

    protected abstract String[] getParameterNames();

    public boolean isItemForce() {
        return false;
    }

    public boolean isSpringForce() {
        return false;
    }

    public void getForce(ForceItem item) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }

    public void getForce(Spring spring) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }
}

