/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class DiscovererParameterDescriptionTooltip
extends ToolTip {
    private final Table table;

    public DiscovererParameterDescriptionTooltip(Table table) {
        super((Control)table, 1, false);
        this.table = table;
    }

    protected boolean shouldCreateToolTip(Event event) {
        DiscovererParameter parameter = this.getDiscovererParameterAt(event);
        if (parameter == null || parameter.getDescription() == null) {
            return false;
        }
        return event.x <= this.table.getColumns()[0].getWidth();
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        DiscovererParameter parameter = this.getDiscovererParameterAt(event);
        if (parameter == null) {
            return new Composite(parent, 0);
        }
        Composite result = new Composite(parent, 0);
        result.setBackground(parent.getDisplay().getSystemColor(29));
        result.setLayout((Layout)new GridLayout());
        Text text = new Text(result, 64);
        text.setBackground(parent.getDisplay().getSystemColor(29));
        text.setForeground(parent.getDisplay().getSystemColor(28));
        String txt = parameter.getDescription();
        text.setText(txt);
        Dialog.applyDialogFont((Control)text);
        GC gc = new GC((Drawable)text);
        Point textExtent = gc.textExtent(txt);
        if (textExtent.x > 400) {
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 400;
            text.setLayoutData((Object)gridData);
        }
        this.setShift(new Point(0, 20));
        return result;
    }

    protected abstract DiscovererParameter getDiscovererParameterAt(Event var1);
}

