/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.discoverer.internal;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KdmFactory;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Segment;
import org.eclipse.gmt.modisco.omg.kdm.source.Directory;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryContainer;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryItem;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryModel;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceFactory;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceFile;

public class KDMSourceDiscoverer {
    private boolean rootIsProject = false;
    private InventoryContainer rootContainer = null;
    private static final IContentTypeManager CONTENT_TYPE_MANAGER = Platform.getContentTypeManager();
    private static final IContentType TEXT_CONTENT_TYPE = CONTENT_TYPE_MANAGER.getContentType("org.eclipse.modisco.kdm.source.discoverer.textFile");
    private static final IContentType CONFIG_CONTENT_TYPE = CONTENT_TYPE_MANAGER.getContentType("org.eclipse.modisco.kdm.source.discoverer.confFile");
    private static final IContentType SRC_CONTENT_TYPE = CONTENT_TYPE_MANAGER.getContentType("org.eclipse.modisco.kdm.source.discoverer.srcFile");
    private static final IContentType BIN_CONTENT_TYPE = CONTENT_TYPE_MANAGER.getContentType("org.eclipse.modisco.kdm.source.discoverer.binaryFile");
    private static final IContentType IMAGE_CONTENT_TYPE = CONTENT_TYPE_MANAGER.getContentType("org.eclipse.modisco.kdm.source.discoverer.imageFile");
    private static final IContentType EXECUTABLE_CONTENT_TYPE = CONTENT_TYPE_MANAGER.getContentType("org.eclipse.modisco.kdm.source.discoverer.executableFile");

    public final Resource getKDMModelFromDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        this.rootIsProject = false;
        this.rootContainer = null;
        return this.createKDMModelFromDirectory(file, file.getName());
    }

    public final Resource getKDMModelFromProject(IProject project) {
        this.rootIsProject = true;
        this.rootContainer = null;
        return this.createKDMModelFromDirectory(project.getLocation().toFile(), project.getName());
    }

    public final Resource getKDMModelFromContainer(IContainer aContainer) {
        this.rootIsProject = aContainer == aContainer.getProject();
        this.rootContainer = null;
        return this.createKDMModelFromDirectory(aContainer.getLocation().toFile(), aContainer.getName());
    }

    private Resource createKDMModelFromDirectory(File directoryFile, String name) {
        XMIResourceImpl resultModel = new XMIResourceImpl();
        Segment segment = KdmFactory.eINSTANCE.createSegment();
        InventoryModel inventoryModel = SourceFactory.eINSTANCE.createInventoryModel();
        inventoryModel.setName(name);
        segment.getModel().add((Object)inventoryModel);
        resultModel.getContents().add((Object)segment);
        InventoryContainer project = this.createFileSystemTree(directoryFile);
        inventoryModel.getInventoryElement().add((Object)project);
        return resultModel;
    }

    private InventoryContainer createFileSystemTree(File directory) {
        File[] children;
        Directory resultDirectory;
        if (this.rootContainer == null && this.rootIsProject) {
            resultDirectory = SourceFactory.eINSTANCE.createProject();
            this.rootContainer = resultDirectory;
        } else {
            resultDirectory = SourceFactory.eINSTANCE.createDirectory();
            resultDirectory.setPath(directory.getAbsolutePath());
            if (this.rootContainer == null) {
                this.rootContainer = resultDirectory;
            }
        }
        resultDirectory.setName(directory.getName());
        File[] fileArray = children = directory.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile()) {
                InventoryItem childItem = KDMSourceDiscoverer.getElement(child);
                childItem.setPath(child.getAbsolutePath());
                childItem.setName(child.getName());
                resultDirectory.getInventoryElement().add((Object)childItem);
            } else {
                Directory childDirectory = (Directory)this.createFileSystemTree(child);
                resultDirectory.getInventoryElement().add((Object)childDirectory);
            }
            ++n2;
        }
        return resultDirectory;
    }

    private static IContentType findBestContentTypeFor(String fileName) {
        IContentType[] contentTypes = CONTENT_TYPE_MANAGER.findContentTypesFor(fileName);
        IContentType bestContentType = null;
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.getId().startsWith("org.eclipse.modisco.kdm.source.discoverer") && (bestContentType == null || contentType.isKindOf(bestContentType))) {
                bestContentType = contentType;
            }
            ++n2;
        }
        return bestContentType;
    }

    private static InventoryItem getElement(File file) {
        SourceFile item = null;
        IContentType contentType = KDMSourceDiscoverer.findBestContentTypeFor(file.getName());
        if (contentType != null) {
            if (contentType.isKindOf(BIN_CONTENT_TYPE)) {
                if (contentType.isKindOf(IMAGE_CONTENT_TYPE)) {
                    item = SourceFactory.eINSTANCE.createImage();
                    return item;
                }
                if (contentType.isKindOf(EXECUTABLE_CONTENT_TYPE)) {
                    item = SourceFactory.eINSTANCE.createExecutableFile();
                    return item;
                }
                item = SourceFactory.eINSTANCE.createBinaryFile();
            } else if (contentType.isKindOf(TEXT_CONTENT_TYPE)) {
                if (contentType.isKindOf(CONFIG_CONTENT_TYPE)) {
                    item = SourceFactory.eINSTANCE.createConfiguration();
                } else if (contentType.isKindOf(SRC_CONTENT_TYPE)) {
                    item = SourceFactory.eINSTANCE.createSourceFile();
                }
            }
        }
        if (item == null) {
            item = SourceFactory.eINSTANCE.createSourceFile();
        }
        return item;
    }
}

