/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.prefuse.examples.graphview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.modisco.infra.prefuse.examples.graphview.GraphView;
import org.eclipse.modisco.infra.prefuse.examples.graphview.Messages;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.util.io.IOLib;

public class OpenGraphAction
extends AbstractAction {
    private GraphView m_view;

    public OpenGraphAction(GraphView view) {
        this.m_view = view;
        this.putValue("Name", Messages.OpenGraphAction_OpenFile);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl O"));
    }

    public void actionPerformed(ActionEvent e) {
        Graph g = IOLib.getGraphFile((Component)((Object)this.m_view));
        if (g == null) {
            return;
        }
        String label = OpenGraphAction.getLabel((Component)((Object)this.m_view), g);
        if (label != null) {
            this.m_view.setGraph(g, label);
        }
    }

    public static String getLabel(Component cParam, Graph g) {
        Component c = cParam;
        Table t = g.getNodeTable();
        int cc = t.getColumnCount();
        String[] names = new String[cc];
        int i = 0;
        while (i < cc) {
            names[i] = t.getColumnName(i);
            ++i;
        }
        final String[] label = new String[1];
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        final JDialog dialog = new JDialog((JFrame)c, Messages.OpenGraphAction_ChooseLabelField, true);
        final JButton ok = new JButton(Messages.OpenGraphAction_OK);
        ok.setEnabled(false);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        JButton cancel = new JButton(Messages.OpenGraphAction_Cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                label[0] = null;
                dialog.setVisible(false);
            }
        });
        final JList<String> list = new JList<String>(names);
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int sel = list.getSelectedIndex();
                if (sel >= 0) {
                    ok.setEnabled(true);
                    label[0] = (String)list.getModel().getElementAt(sel);
                } else {
                    ok.setEnabled(false);
                    label[0] = null;
                }
            }
        });
        JScrollPane scrollList = new JScrollPane(list);
        JLabel title = new JLabel(Messages.OpenGraphAction_ChooseFieldToUseForNodeLabels);
        Box bbox = new Box(0);
        bbox.add(Box.createHorizontalStrut(5));
        bbox.add(Box.createHorizontalGlue());
        bbox.add(ok);
        bbox.add(Box.createHorizontalStrut(5));
        bbox.add(cancel);
        bbox.add(Box.createHorizontalStrut(5));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)title, "North");
        panel.add((Component)scrollList, "Center");
        panel.add((Component)bbox, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(c);
        dialog.setVisible(true);
        dialog.dispose();
        return label[0];
    }
}

