/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.ObjectIntSortedMap;

public class ObjectIntTreeMap
extends AbstractTreeMap
implements ObjectIntSortedMap {
    private ObjectEntry dummy = new ObjectEntry(null, Integer.MIN_VALUE, NIL, 0);
    private Comparator cmp = null;

    public ObjectIntTreeMap() {
        this((Comparator)null, false);
    }

    public ObjectIntTreeMap(boolean allowDuplicates) {
        this((Comparator)null, allowDuplicates);
    }

    public ObjectIntTreeMap(Comparator comparator) {
        this(comparator, false);
    }

    public ObjectIntTreeMap(Comparator comparator, boolean allowDuplicates) {
        super(null, allowDuplicates);
        this.cmp = comparator == null ? super.comparator() : comparator;
    }

    public Comparator comparator() {
        return this.cmp;
    }

    public boolean containsKey(Object key) {
        return this.find(key, 0) != NIL;
    }

    public int get(Object key) {
        AbstractTreeMap.Entry ret = this.find(key, 0);
        return ret == NIL ? Integer.MIN_VALUE : ret.val;
    }

    public int put(Object key, int value) {
        AbstractTreeMap.Entry t = this.root;
        this.lastOrder = 0;
        if (t == NIL) {
            this.incrementSize(true);
            this.root = new ObjectEntry(key, value, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = key;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int cmp;
            if ((cmp = this.compare(this.dummy, t)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != NIL) {
                    t = t.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                t.left = new ObjectEntry(key, value, t, this.lastOrder);
                this.fixUpInsert(t.left);
                return Integer.MIN_VALUE;
            }
            if (t.right == NIL) break;
            t = t.right;
        }
        this.incrementSize(this.lastOrder == 0);
        t.right = new ObjectEntry(key, value, t, this.lastOrder);
        this.fixUpInsert(t.right);
        return Integer.MIN_VALUE;
    }

    public int remove(Object key) {
        AbstractTreeMap.Entry x = this.allowDuplicates ? this.findPredecessor(key, Integer.MAX_VALUE) : this.find(key, 0);
        if (x == NIL) {
            return Integer.MIN_VALUE;
        }
        int val = x.val;
        this.remove(x);
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public int remove(Object key, int val) {
        x = this.findCeiling(key, 0);
        if (x != ObjectIntTreeMap.NIL && (key == null && x.getKey() != null || key != null && !x.getKey().equals(key))) {
            x = this.successor(x);
        }
        if (x != ObjectIntTreeMap.NIL && (key != null || x.getKey() == null) && (key == null || x.getKey().equals(key))) ** GOTO lbl7
        return -2147483648;
lbl-1000:
        // 1 sources

        {
            x = this.successor(x);
lbl7:
            // 2 sources

            ** while (x.val != val && x != ObjectIntTreeMap.NIL)
        }
lbl8:
        // 1 sources

        if (x == ObjectIntTreeMap.NIL) {
            return -2147483648;
        }
        this.remove(x);
        return val;
    }

    public Object firstKey() {
        return this.minimum(this.root).getKey();
    }

    public Object lastKey() {
        return this.maximum(this.root).getKey();
    }

    public Iterator keyIterator() {
        return new AbstractTreeMap.KeyIterator();
    }

    public Iterator keyRangeIterator(Object fromKey, boolean fromInc, Object toKey, boolean toInc) {
        AbstractTreeMap.Entry end;
        AbstractTreeMap.Entry start;
        boolean bmax;
        if (fromKey == toKey && (fromKey == MIN_KEY || fromKey == MAX_KEY)) {
            return Collections.EMPTY_LIST.iterator();
        }
        boolean bmin = fromKey == MIN_KEY || toKey == MAX_KEY;
        boolean bl = bmax = fromKey == MAX_KEY || toKey == MIN_KEY;
        if (!bmax && (bmin || this.cmp.compare(fromKey, toKey) <= 0)) {
            start = this.findCeiling(fromKey, fromInc ? 0 : Integer.MAX_VALUE);
            end = this.findCeiling(toKey, toInc ? Integer.MAX_VALUE : 0);
        } else {
            start = this.findCeiling(fromKey, fromInc ? Integer.MAX_VALUE : 0);
            start = this.predecessor(start);
            end = this.findCeiling(toKey, toInc ? 0 : Integer.MAX_VALUE);
            end = this.predecessor(end);
        }
        return new AbstractTreeMap.KeyIterator(start, end);
    }

    public IntIterator valueRangeIterator(Object fromKey, boolean fromInc, Object toKey, boolean toInc) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(fromKey, fromInc, toKey, toInc));
    }

    protected int compare(AbstractTreeMap.Entry e1, AbstractTreeMap.Entry e2) {
        Object k2;
        Object k1 = e1.getKey();
        if (k1 == (k2 = e2.getKey()) && (k1 == MIN_KEY || k1 == MAX_KEY)) {
            return 0;
        }
        if (k1 == MIN_KEY || k2 == MAX_KEY) {
            return -1;
        }
        if (k1 == MAX_KEY || k2 == MIN_KEY) {
            return 1;
        }
        int c = this.cmp.compare(e1.getKey(), e2.getKey());
        if (this.allowDuplicates && c == 0) {
            c = e1.order < e2.order ? -1 : (e1.order > e2.order ? 1 : 0);
            this.lastOrder = 1 + (c < 0 ? e1.order : e2.order);
        }
        return c;
    }

    private AbstractTreeMap.Entry find(Object key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.find(this.dummy);
        this.dummy.key = null;
        return e;
    }

    private AbstractTreeMap.Entry findPredecessor(Object key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findPredecessor(this.dummy);
        this.dummy.key = null;
        return e;
    }

    private AbstractTreeMap.Entry findCeiling(Object key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findCeiling(this.dummy);
        this.dummy.key = null;
        return e;
    }

    static class ObjectEntry
    extends AbstractTreeMap.Entry {
        Object key;

        public ObjectEntry(Object key, int val) {
            super(val);
            this.key = key;
        }

        public ObjectEntry(Object key, int val, AbstractTreeMap.Entry parent, int order) {
            super(val, parent, order);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public void copyFields(AbstractTreeMap.Entry x) {
            super.copyFields(x);
            this.key = x.getKey();
        }
    }
}

