/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.editor;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.facet.custom.ui.CustomizedContentProviderUtils;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.EmfUtils;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.TreeItem;

public class TreeEditorDropListener
implements DropTargetListener {
    private final EditingDomain editingDomain;

    public TreeEditorDropListener(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        TreeItem item;
        Object data;
        EStructuralFeature structFeature;
        Object value = null;
        if (event.data instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)event.data;
            value = structSelection.size() == 1 ? structSelection.getFirstElement() : structSelection.toList();
        }
        if ((structFeature = CustomizedContentProviderUtils.getEStructuralFeature((Object)(data = (item = (TreeItem)event.item).getData()))) != null) {
            EObject eObject = CustomizedContentProviderUtils.getParentEObject((Object)data);
            this.eObjDrop(eObject, structFeature, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void eObjDrop(EObject eObject, EStructuralFeature feature, Object value) {
        Command command;
        block5: {
            ResourceSet resourceSet;
            block6: {
                Resource eResource = eObject.eResource();
                resourceSet = eResource.getResourceSet();
                if (!feature.isMany()) break block6;
                if (value instanceof Collection) {
                    Collection<EObject> collection = EmfUtils.getCollectionFrom(resourceSet, (Collection)value);
                    command = AddCommand.create((EditingDomain)this.editingDomain, (Object)eObject, (Object)feature, collection);
                    break block5;
                } else if (value instanceof EObject) {
                    EObject eObjectVal = EmfUtils.getEObjectFrom(resourceSet, (EObject)value);
                    command = AddCommand.create((EditingDomain)this.editingDomain, (Object)eObject, (Object)feature, (Object)eObjectVal);
                    break block5;
                } else {
                    if (value == null) {
                        throw new IllegalStateException("Unexpected value : null found while expecting an EObject or a collection of EObjects.");
                    }
                    String message = String.format("Unexpected value type: '%s' found while expecting an EObject or a collection of EObjects.", value.getClass());
                    throw new IllegalStateException(message);
                }
            }
            EObject eObjectVal = EmfUtils.getEObjectFrom(resourceSet, (EObject)value);
            command = SetCommand.create((EditingDomain)this.editingDomain, (Object)eObject, (Object)feature, (Object)eObjectVal);
        }
        this.editingDomain.getCommandStack().execute(command);
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

