/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;

public class Clip {
    private static final byte EMPTY = 0;
    private static final byte INUSE = 1;
    private static final byte INVALID = 2;
    private double[] clip = new double[8];
    private byte status = (byte)2;

    public void reset() {
        this.status = 0;
    }

    public void invalidate() {
        this.status = (byte)2;
    }

    public void setClip(Clip c) {
        this.status = 1;
        System.arraycopy(c.clip, 0, this.clip, 0, this.clip.length);
    }

    public void setClip(Rectangle2D r) {
        this.setClip(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setClip(double x, double y, double w, double h) {
        this.status = 1;
        this.clip[0] = x;
        this.clip[1] = y;
        this.clip[6] = x + w;
        this.clip[7] = y + h;
    }

    public void transform(AffineTransform at) {
        this.clip[2] = this.clip[0];
        this.clip[3] = this.clip[7];
        this.clip[4] = this.clip[6];
        this.clip[5] = this.clip[1];
        at.transform(this.clip, 0, this.clip, 0, 4);
        double xmin = this.clip[0];
        double ymin = this.clip[1];
        double xmax = this.clip[6];
        double ymax = this.clip[7];
        int i = 0;
        while (i < 7) {
            if (this.clip[i] < xmin) {
                xmin = this.clip[i];
            }
            if (this.clip[i] > xmax) {
                xmax = this.clip[i];
            }
            if (this.clip[i + 1] < ymin) {
                ymin = this.clip[i + 1];
            }
            if (this.clip[i + 1] > ymax) {
                ymax = this.clip[i + 1];
            }
            i += 2;
        }
        this.clip[0] = xmin;
        this.clip[1] = ymin;
        this.clip[6] = xmax;
        this.clip[7] = ymax;
    }

    public void limit(double x1, double y1, double x2, double y2) {
        this.clip[0] = Math.max(this.clip[0], x1);
        this.clip[1] = Math.max(this.clip[1], y1);
        this.clip[6] = Math.min(this.clip[6], x2);
        this.clip[7] = Math.min(this.clip[7], y2);
    }

    public boolean intersects(Rectangle2D r, double margin) {
        double tw = this.clip[6] - this.clip[0];
        double th = this.clip[7] - this.clip[1];
        double rw = r.getWidth();
        double rh = r.getHeight();
        if (rw < 0.0 || rh < 0.0 || tw < 0.0 || th < 0.0) {
            return false;
        }
        double tx = this.clip[0];
        double ty = this.clip[1];
        double rx = r.getX() - margin;
        double ry = r.getY() - margin;
        return ((rw += rx + 2.0 * margin) < rx || rw > tx) && ((rh += ry + 2.0 * margin) < ry || rh > ty) && ((tw += tx) < tx || tw > rx) && ((th += ty) < ty || th > ry);
    }

    public void union(Clip c) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(c);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.min(this.clip[0], c.clip[0]);
        this.clip[1] = Math.min(this.clip[1], c.clip[1]);
        this.clip[6] = Math.max(this.clip[6], c.clip[6]);
        this.clip[7] = Math.max(this.clip[7], c.clip[7]);
    }

    public void union(Rectangle2D r) {
        if (this.status == 2) {
            return;
        }
        double minx = r.getMinX();
        double miny = r.getMinY();
        double maxx = r.getMaxX();
        double maxy = r.getMaxY();
        if (Double.isNaN(minx) || Double.isNaN(miny) || Double.isNaN(maxx) || Double.isNaN(maxy)) {
            Logger.getLogger(this.getClass().getName()).warning("Union with invalid clip region: " + r);
            return;
        }
        if (this.status == 0) {
            this.setClip(r);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.min(this.clip[0], minx);
        this.clip[1] = Math.min(this.clip[1], miny);
        this.clip[6] = Math.max(this.clip[6], maxx);
        this.clip[7] = Math.max(this.clip[7], maxy);
    }

    public void union(double x, double y, double w, double h) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(x, y, w, h);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.min(this.clip[0], x);
        this.clip[1] = Math.min(this.clip[1], y);
        this.clip[6] = Math.max(this.clip[6], x + w);
        this.clip[7] = Math.max(this.clip[7], y + h);
    }

    public void intersection(Clip c) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(c);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.max(this.clip[0], c.clip[0]);
        this.clip[1] = Math.max(this.clip[1], c.clip[1]);
        this.clip[6] = Math.min(this.clip[6], c.clip[6]);
        this.clip[7] = Math.min(this.clip[7], c.clip[7]);
    }

    public void intersection(Rectangle2D r) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(r);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.max(this.clip[0], r.getMinX());
        this.clip[1] = Math.max(this.clip[1], r.getMinY());
        this.clip[6] = Math.min(this.clip[6], r.getMaxX());
        this.clip[7] = Math.min(this.clip[7], r.getMaxY());
    }

    public void intersection(double x, double y, double w, double h) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(x, y, w, h);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.max(this.clip[0], x);
        this.clip[1] = Math.max(this.clip[1], y);
        this.clip[6] = Math.min(this.clip[6], x + w);
        this.clip[7] = Math.min(this.clip[7], y + h);
    }

    public void expandToIntegerLimits() {
        this.clip[0] = Math.floor(this.clip[0]);
        this.clip[1] = Math.floor(this.clip[1]);
        this.clip[6] = Math.ceil(this.clip[6]);
        this.clip[7] = Math.ceil(this.clip[7]);
    }

    public void expand(double b) {
        this.clip[0] = this.clip[0] - b;
        this.clip[1] = this.clip[1] - b;
        this.clip[6] = this.clip[6] + b;
        this.clip[7] = this.clip[7] + b;
    }

    public void grow(double b) {
        this.clip[6] = this.clip[6] + b;
        this.clip[7] = this.clip[7] + b;
    }

    public double getMinX() {
        return this.clip[0];
    }

    public double getMinY() {
        return this.clip[1];
    }

    public double getMaxX() {
        return this.clip[6];
    }

    public double getMaxY() {
        return this.clip[7];
    }

    public double getWidth() {
        return this.clip[6] - this.clip[0];
    }

    public double getHeight() {
        return this.clip[7] - this.clip[1];
    }

    public boolean isEmpty() {
        return this.status == 0;
    }

    public boolean isInvalid() {
        return this.status == 2;
    }

    public boolean equals(Object o) {
        if (o instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)o;
            return r.getMinX() == this.clip[0] && r.getMinY() == this.clip[1] && r.getMaxX() == this.clip[6] && r.getMaxY() == this.clip[7];
        }
        if (o instanceof Clip) {
            Clip r = (Clip)o;
            if (r.status == this.status) {
                if (this.status == 1) {
                    return r.clip[0] == this.clip[0] && r.clip[1] == this.clip[1] && r.clip[6] == this.clip[6] && r.clip[7] == this.clip[7];
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(20);
        sb.append("Clip[");
        switch (this.status) {
            case 2: {
                sb.append("invalid");
                break;
            }
            case 0: {
                sb.append("empty");
                break;
            }
            default: {
                sb.append(this.clip[0]).append(",");
                sb.append(this.clip[1]).append(",");
                sb.append(this.clip[6]).append(",");
                sb.append(this.clip[7]);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

