/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.simpletransformationschain;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.usecase.simpletransformationschain.DiscoverUmlModelFromJavaProject;
import org.eclipse.modisco.util.atl.core.internal.AtlLaunchHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelWithBidirectionalAssociationsFromJavaProject
extends AbstractModelDiscoverer<IJavaProject> {
    private static final String MODEL_FILE_SUFFIX = "_BidirectionalAssociations.uml";
    private static final String UML_MM_URI = "http://www.eclipse.org/uml2/2.1.0/UML";
    private URL customTransformation = null;

    @Parameter(name="CUSTOM_TRANSFORMATION", description="A URL pointing to an ATL transformation that will be used instead of the default one.")
    public void setCustomTransformation(URL customTransformation) {
        this.customTransformation = customTransformation;
    }

    protected URL getCustomTransformation() {
        return this.customTransformation;
    }

    public boolean isApplicableTo(IJavaProject source) {
        return source.getProject().isAccessible();
    }

    protected void basicDiscoverElement(IJavaProject source, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = source.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(project.getFullPath().append(project.getName()) + MODEL_FILE_SUFFIX), (boolean)true));
        Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
        MoDiscoLogHandler logHandler = new MoDiscoLogHandler(String.valueOf(project.getLocation().append(project.getName()).toString()) + ".log");
        logger.addHandler((Handler)logHandler);
        try {
            try {
                Resource uml2Model = DiscoverUmlModelFromJavaProject.getUML2ModelFromJavaProject(source, this.getCustomTransformation());
                ArrayList<AtlLaunchHelper.ModelInfo> inputModels = new ArrayList<AtlLaunchHelper.ModelInfo>();
                ArrayList<AtlLaunchHelper.ModelInfo> outputModels = new ArrayList<AtlLaunchHelper.ModelInfo>();
                AtlLaunchHelper.ModelInfo inputModel = new AtlLaunchHelper.ModelInfo("umlInput", uml2Model.getURI(), uml2Model, "uml", URI.createURI((String)UML_MM_URI));
                inputModels.add(inputModel);
                AtlLaunchHelper.ModelInfo outputModel = new AtlLaunchHelper.ModelInfo("umlOutput", URI.createURI((String)"memory://umlTargetModel"), null, "uml", URI.createURI((String)"platform:/plugin/org.eclipse.uml2.uml/model/UML.ecore"));
                outputModels.add(outputModel);
                AtlLaunchHelper atlHelper = new AtlLaunchHelper();
                URL transformation = ((Object)((Object)this)).getClass().getResource("transformations/UML2Copy.asm");
                URL superimposedTransformation = ((Object)((Object)this)).getClass().getResource("transformations/BidirectionalAssociation.asm");
                ArrayList<URL> superimposedTransformations = new ArrayList<URL>();
                superimposedTransformations.add(superimposedTransformation);
                List results = atlHelper.runTransformation(transformation, inputModels, outputModels, superimposedTransformations);
                if (results.size() > 0) {
                    this.setTargetModel((Resource)results.get(0));
                }
            }
            catch (Exception e) {
                throw new DiscoveryException((Throwable)e);
            }
        }
        finally {
            logger.removeHandler((Handler)logHandler);
            logHandler.close();
        }
    }
}

