/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.internal.TranslateJavaModelToKdm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverKDMModelFromJavaProject
extends AbstractModelDiscoverer<IJavaProject> {
    public static final String ID = "org.eclipse.modisco.java.discoverer.javaProjectToKDM";

    public boolean isApplicableTo(IJavaProject project) {
        return project.getProject().isAccessible();
    }

    protected void basicDiscoverElement(IJavaProject project, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(String.valueOf(project.getProject().getFullPath().append(project.getProject().getName()).toString()) + "_kdm.xmi"), (boolean)true));
        Resource kdmModel = DiscoverKDMModelFromJavaProject.discoverKDM(project, this.getDefaultTargetURI(), monitor);
        this.getResourceSet().getResources().add((Object)kdmModel);
        this.setTargetModel(kdmModel);
    }

    static Resource discoverKDM(IJavaProject project, URI kdmModelURI, IProgressMonitor monitor) throws DiscoveryException {
        try {
            DiscoverJavaModelFromJavaProject javaDiscoverer = new DiscoverJavaModelFromJavaProject();
            javaDiscoverer.discoverElement(project, monitor);
            Resource javaModel = javaDiscoverer.getTargetModel();
            TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
            Resource kdmModel = kdmTranslater.getKDMModelFromJavaModelWithCustomTransformation(javaModel.getURI(), javaModel, kdmModelURI);
            return kdmModel;
        }
        catch (IOException e) {
            throw new DiscoveryException("Error discovering KDM model", (Throwable)e);
        }
    }
}

