/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.Spring;

public class SpringForce
extends AbstractForce {
    private static String[] pnames = new String[]{"SpringCoefficient", "DefaultSpringLength"};
    public static final float DEFAULT_SPRING_COEFF = 1.0E-4f;
    public static final float DEFAULT_MAX_SPRING_COEFF = 0.001f;
    public static final float DEFAULT_MIN_SPRING_COEFF = 1.0E-5f;
    public static final float DEFAULT_SPRING_LENGTH = 50.0f;
    public static final float DEFAULT_MIN_SPRING_LENGTH = 0.0f;
    public static final float DEFAULT_MAX_SPRING_LENGTH = 200.0f;
    public static final int SPRING_COEFF = 0;
    public static final int SPRING_LENGTH = 1;

    public SpringForce(float springCoeff, float defaultLength) {
        this.params = new float[]{springCoeff, defaultLength};
        this.minValues = new float[]{1.0E-5f, 0.0f};
        this.maxValues = new float[]{0.001f, 200.0f};
    }

    public SpringForce() {
        this(1.0E-4f, 50.0f);
    }

    public boolean isSpringForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(Spring s) {
        ForceItem item1 = s.item1;
        ForceItem item2 = s.item2;
        float length = s.length < 0.0f ? this.params[1] : s.length;
        float x2 = item2.location[0];
        float x1 = item1.location[0];
        float dx = x2 - x1;
        float y2 = item2.location[1];
        float y1 = item1.location[1];
        float dy = y2 - y1;
        float r = (float)Math.sqrt(dx * dx + dy * dy);
        if ((double)r == 0.0) {
            dx = ((float)Math.random() - 0.5f) / 50.0f;
            dy = ((float)Math.random() - 0.5f) / 50.0f;
            r = (float)Math.sqrt(dx * dx + dy * dy);
        }
        float d = r - length;
        float coeff = (s.coeff < 0.0f ? this.params[0] : s.coeff) * d / r;
        item1.force[0] = item1.force[0] + coeff * dx;
        item1.force[1] = item1.force[1] + coeff * dy;
        item2.force[0] = item2.force[0] + -coeff * dx;
        item2.force[1] = item2.force[1] + -coeff * dy;
    }
}

