/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.prefuse.examples.treeview;

import java.awt.geom.Point2D;
import javax.swing.KeyStroke;
import org.eclipse.gmt.modisco.infra.prefuse.examples.treeview.AutoPanAction;
import org.eclipse.gmt.modisco.infra.prefuse.examples.treeview.Messages;
import org.eclipse.gmt.modisco.infra.prefuse.examples.treeview.NodeColorAction;
import org.eclipse.gmt.modisco.infra.prefuse.examples.treeview.OrientAction;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.filter.FisheyeTreeFilter;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class TreeView
extends Display {
    private LabelRenderer m_nodeRenderer;
    private EdgeRenderer m_edgeRenderer;
    private String m_label = "label";
    private String m_image = "image";
    private int m_orientation = 0;

    public TreeView(Graph t, String label, String image) {
        super(new Visualization());
        this.m_label = label;
        this.m_image = image;
        this.m_vis.add("tree", (TupleSet)t);
        this.m_nodeRenderer = new LabelRenderer(this.m_label, this.m_image);
        this.m_nodeRenderer.setRenderType(2);
        this.m_nodeRenderer.setHorizontalAlignment(0);
        this.m_nodeRenderer.setImagePosition(0);
        this.m_nodeRenderer.setRoundedCorner(8, 8);
        this.m_edgeRenderer = new EdgeRenderer(1);
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.m_nodeRenderer);
        rf.add((Predicate)new InGroupPredicate("tree.edges"), (Renderer)this.m_edgeRenderer);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        NodeColorAction nodeColor = new NodeColorAction("tree.nodes");
        ColorAction textColor = new ColorAction("tree.nodes", VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0));
        this.m_vis.putAction("textColor", (Action)textColor);
        ColorAction edgeColor = new ColorAction("tree.edges", VisualItem.STROKECOLOR, ColorLib.rgb((int)200, (int)200, (int)200));
        ActionList repaint = new ActionList();
        repaint.add((Action)nodeColor);
        repaint.add((Action)new RepaintAction());
        this.m_vis.putAction("repaint", (Action)repaint);
        ActionList fullPaint = new ActionList();
        fullPaint.add((Action)nodeColor);
        this.m_vis.putAction("fullPaint", (Action)fullPaint);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator("tree.nodes"));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        NodeLinkTreeLayout treeLayout = new NodeLinkTreeLayout("tree", this.m_orientation, 50.0, 0.0, 8.0);
        treeLayout.setLayoutAnchor((Point2D)new Point2D.Double(25.0, 300.0));
        this.m_vis.putAction("treeLayout", (Action)treeLayout);
        CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout("tree", this.m_orientation);
        this.m_vis.putAction("subLayout", (Action)subLayout);
        AutoPanAction autoPan = new AutoPanAction(this);
        ActionList filter = new ActionList();
        filter.add((Action)new FisheyeTreeFilter("tree", 2));
        filter.add((Action)new FontAction("tree.nodes", FontLib.getFont((String)"Tahoma", (double)16.0)));
        filter.add((Action)treeLayout);
        filter.add((Action)subLayout);
        filter.add((Action)textColor);
        filter.add((Action)nodeColor);
        filter.add((Action)edgeColor);
        this.m_vis.putAction("filter", (Action)filter);
        ActionList animate = new ActionList(1000L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)autoPan);
        animate.add((Action)new QualityControlAnimator());
        animate.add((Action)new VisibilityAnimator("tree"));
        animate.add((Action)new LocationAnimator("tree.nodes"));
        animate.add((Action)new ColorAnimator("tree.nodes"));
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("animate", (Action)animate);
        this.m_vis.alwaysRunAfter("filter", "animate");
        ActionList orient = new ActionList(2000L);
        orient.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        orient.add((Action)autoPan);
        orient.add((Action)new QualityControlAnimator());
        orient.add((Action)new LocationAnimator("tree.nodes"));
        orient.add((Action)new RepaintAction());
        this.m_vis.putAction("orient", (Action)orient);
        this.setSize(700, 600);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new FocusControl(1, "filter"));
        this.registerKeyboardAction(new OrientAction(0, this), "left-to-right", KeyStroke.getKeyStroke("ctrl 1"), 0);
        this.registerKeyboardAction(new OrientAction(2, this), "top-to-bottom", KeyStroke.getKeyStroke("ctrl 2"), 0);
        this.registerKeyboardAction(new OrientAction(1, this), "right-to-left", KeyStroke.getKeyStroke("ctrl 3"), 0);
        this.registerKeyboardAction(new OrientAction(3, this), "bottom-to-top", KeyStroke.getKeyStroke("ctrl 4"), 0);
        this.setOrientation(this.m_orientation);
        this.m_vis.run("filter");
        PrefixSearchTupleSet search = new PrefixSearchTupleSet();
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)search);
        search.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TreeView.this.m_vis.cancel("animatePaint");
                TreeView.this.m_vis.run("fullPaint");
                TreeView.this.m_vis.run("animatePaint");
            }
        });
    }

    public void setOrientation(int orientation) {
        NodeLinkTreeLayout rtl = (NodeLinkTreeLayout)this.m_vis.getAction("treeLayout");
        CollapsedSubtreeLayout stl = (CollapsedSubtreeLayout)this.m_vis.getAction("subLayout");
        switch (orientation) {
            case 0: {
                this.m_nodeRenderer.setHorizontalAlignment(0);
                this.m_edgeRenderer.setHorizontalAlignment1(1);
                this.m_edgeRenderer.setHorizontalAlignment2(0);
                this.m_edgeRenderer.setVerticalAlignment1(2);
                this.m_edgeRenderer.setVerticalAlignment2(2);
                break;
            }
            case 1: {
                this.m_nodeRenderer.setHorizontalAlignment(1);
                this.m_edgeRenderer.setHorizontalAlignment1(0);
                this.m_edgeRenderer.setHorizontalAlignment2(1);
                this.m_edgeRenderer.setVerticalAlignment1(2);
                this.m_edgeRenderer.setVerticalAlignment2(2);
                break;
            }
            case 2: {
                this.m_nodeRenderer.setHorizontalAlignment(2);
                this.m_edgeRenderer.setHorizontalAlignment1(2);
                this.m_edgeRenderer.setHorizontalAlignment2(2);
                this.m_edgeRenderer.setVerticalAlignment1(3);
                this.m_edgeRenderer.setVerticalAlignment2(4);
                break;
            }
            case 3: {
                this.m_nodeRenderer.setHorizontalAlignment(2);
                this.m_edgeRenderer.setHorizontalAlignment1(2);
                this.m_edgeRenderer.setHorizontalAlignment2(2);
                this.m_edgeRenderer.setVerticalAlignment1(4);
                this.m_edgeRenderer.setVerticalAlignment2(3);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(Messages.TreeView_UnrecognizedOrientationValue) + orientation);
            }
        }
        this.m_orientation = orientation;
        rtl.setOrientation(orientation);
        stl.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.m_orientation;
    }
}

