/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;

public abstract class BinaryExpression
extends AbstractExpression {
    protected int m_op;
    protected Expression m_left;
    protected Expression m_right;

    protected BinaryExpression(int operation, int minOp, int maxOp, Expression left, Expression right) {
        if (operation < minOp || operation > maxOp) {
            throw new IllegalArgumentException("Unknown operation type: " + operation);
        }
        if (left == null || right == null) {
            throw new IllegalArgumentException("Expressions must be non-null.");
        }
        this.m_op = operation;
        this.m_left = left;
        this.m_right = right;
    }

    public Expression getLeftExpression() {
        return this.m_left;
    }

    public Expression getRightExpression() {
        return this.m_right;
    }

    public void setLeftExpression(Expression e) {
        this.m_left.removeExpressionListener(this);
        this.m_left = e;
        if (this.hasListeners()) {
            e.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public void setRightExpression(Expression e) {
        this.m_right.removeExpressionListener(this);
        this.m_right = e;
        if (this.hasListeners()) {
            e.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public int getOperation() {
        return this.m_op;
    }

    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
        v.down();
        this.m_left.visit(v);
        v.up();
        v.down();
        this.m_right.visit(v);
        v.up();
    }

    protected void addChildListeners() {
        this.m_left.addExpressionListener(this);
        this.m_right.addExpressionListener(this);
    }

    protected void removeChildListeners() {
        this.m_left.removeExpressionListener(this);
        this.m_right.removeExpressionListener(this);
    }
}

