/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.ui.internal.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.modisco.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.modisco.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.modisco.facet.custom.core.ICustomizationManager;
import org.eclipse.modisco.facet.custom.core.ICustomizationManagerProvider;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.modisco.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialog;
import org.eclipse.modisco.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialogFactory;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IQuestionDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LoadCustomizationsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICustomizationManagerProvider customMgrProvider;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null && (customMgrProvider = (ICustomizationManagerProvider)activePart.getAdapter(ICustomizationManagerProvider.class)) != null) {
            ICustomizationManager manager = customMgrProvider.getCustomizationManager();
            HashSet availableCustoms = new HashSet();
            ICustomizationCatalogManager catalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(manager.getResourceSet());
            availableCustoms.addAll(catalog.getRegisteredCustomizations());
            availableCustoms.addAll(manager.getManagedCustomizations());
            DialogCallbackWithPreCommit callback = new DialogCallbackWithPreCommit(manager);
            ArrayList<Customization> availableCustomsL = new ArrayList<Customization>(availableCustoms);
            ILoadCustomizationsDialog<IQuestionDialog> dialog = ILoadCustomizationsDialogFactory.DEFAULT.createLoadCustomizationDialog(null, availableCustomsL, manager.getManagedCustomizations(), new ArrayList<Customization>(), callback, "");
            dialog.asyncOpen();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DialogCallbackWithPreCommit
    implements IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog> {
        private final ICustomizationManager manager;

        public DialogCallbackWithPreCommit(ICustomizationManager manager) {
            this.manager = manager;
        }

        public void committed(List<Customization> result, Boolean precommitResult) {
            if (precommitResult.booleanValue()) {
                this.manager.getManagedCustomizations().clear();
                IFacetManager facetManager = this.manager.getFacetManager();
                facetManager.getManagedFacetSets().addAll(0, result);
            }
        }

        public IQuestionDialog openPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
            return null;
        }
    }
}

